package jaxx.runtime.swing.editor;

import jaxx.runtime.swing.editor.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberEditor extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final String PROPERTY_AUTO_POPUP = "autoPopup";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_MODEL_TEXT = "modelText";
    public static final String PROPERTY_MODEL_TYPE = "modelType";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_USE_FLOAT = "useFloat";
    public static final String PROPERTY_USE_SIGN = "useSign";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.NumberEditor.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYzW8bRRQfO4mdrzaFlKiBglIScUCKY6dNaUhV2rSEYiUlqgOKsAQdeyf2hPXOZnc22SDx8SfwJ8AdkJC4cSocOCIOvSD+BVRx4Ip4M7vOeP2xnjKRsrLn/d5vfvNm3nuz/vYvNOZ76MohDsOCFzictkihfGd//73aIanze8Sve9TlzEPRXyaLslU0ZZ2N+xwtVreF+0rsvnKXtVzmEKfDe2MbTfr81CZ+kxDO0ctJj7rvr1TOzBuhG3ht1jNR/Vi//vtp9ivry2+yCIUuqFuCpSwM81IrGd1GWWpx9DzMdIxXbOw0QIZHnQboPSfG7trY9x/gFjlCn6P8Nsq52AMyjl7VX7LkkP6hy9H4UnkXO8QucvRaQql/AvMWiEXBt/AgaNWI97b84rrSOwe+rsdc4vFTji4IdQWhuBApVqjRGsFOAhHtpUKMtZhF7AQkmlBBJiRk79QlHM0omFxLh6DAJ1s2wxCQ5xRokzEbJChYHmAV2nDE1xc75sABZ7vMDdwuw4zfZCfSsBlwznr8hPkh8QnvNkSiSSgN55Vh2hVkH1Cf1mzS5ZRvYseyIapoWW8/7kf4jnBKdo7mRAjC2LEs9e8QJ+gIV7z3JThySawYFaDX1VqWytHiVzmaTYBVTJZhbos2KO9xuioGVtMx1zQwawlMHbbV68Fc1+B5QwNzQwOzPljPZBtTKg4mUqCSDmhVB9QRa7fXmhLlSc4aDfssM9qgcZHjWJTWGDdiMZ4KULOt9dEytVTeg4zcxF7pOkcXE2cpNgjkhHLwRG6pYyb5PlYnk0OCbVFiW91Hfq9t6OJTAuQ5wElzriZn4mi+S5oIjlLRcKG4v5RIUWgbBdU2VF3PVNGYF8AwR5eqvZ3mIZiiHnOpq8cIQmn9d272yU9//rjVbixXYe4X+kI7+iIU/LhAUzH1TNRVAk7tlR3sblShcBEbCrFsmpf7CKvEZhAH80UVVbgX7mO/CRRj+T8e/zL36PcRlN1Ck1B3rS0s8O/CnjRh05rMtkL3rdtS0fTJODwvwP8I7NkBqwc+huoHh/AA27C/aFqO7WLqcGKpYYA6fNmnn8LnbOlaCGG63CdMZ1prE7/+M1v54XY7VBmQPj8QrsI19iHKUcemDpFdOG6wfbvulOuTwGKqkfZrrQgqcD7Og7jkHsln0BOQDKTMAfNIw2OBY4mOaQckDAT4M7kC8emLBGEid3V584vF4vp6sTiMOpnQuuwjHrGGilYlMoV2Sm75CaGNJhfREMcojVh2Wujp7Bja4LOR5xzmtbCtTf8MwcnZ+JQBATp/08IcL9SoY0EludUzV0Y8J12NQ1LD9U+icAvM9/2ZChpMuRrzLOIZsYjh7wx1jIraDbePm1HmLcDNzaNQf8mAKJW0VD0Wj5/7M6wZM9zQWFeeOKK4pW3ThrEQc4Zbxgx3jBnuaTH8lhLJd4w1mDOUjRl2jBl29SM5gKFivBfvG69CjyFNw76xBj2GNA1VYw3DGaB80np0GR2g4iMNjnNRK4jvXSmCHmmQTRyIt28cv9UaEOWP1cvxgMUNp4HhzMUUhrrxNg9n6LrXpoRFh0vdmw2Jpji8Ae1Rt/3jxP+mGhYhop8IJgyZ+ZRVNLUYXjFigJC2cEhbQasCryopy9GhyjEXHwVpe6y3pEUjHcPS59D4cGgxZIopcdBjWDNmeHMIw38zZ2nGuBYAAA==";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected java.lang.Boolean autoPopup;
    protected java.lang.Object bean;
    protected javax.swing.JToggleButton button;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected javax.swing.JButton dot;
    protected jaxx.runtime.swing.editor.NumberEditorHandler handler;
    protected java.lang.Number model;
    protected java.lang.String modelText;
    protected java.lang.Class modelType;
    protected javax.swing.JPopupMenu popup;
    protected java.lang.Boolean popupVisible;
    protected java.lang.String property;
    protected javax.swing.JButton resetButton;
    protected java.lang.Boolean showPopupButton;
    protected java.lang.Boolean showReset;
    protected javax.swing.JTextField textField;
    protected javax.swing.JButton toggleSign;
    protected java.lang.Boolean useFloat;
    protected java.lang.Boolean useSign;
    private javax.swing.JButton $JButton10;
    private javax.swing.JButton $JButton11;
    private javax.swing.JButton $JButton12;
    private javax.swing.JButton $JButton13;
    private javax.swing.JButton $JButton14;
    private javax.swing.JButton $JButton15;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private javax.swing.JButton $JButton4;
    private javax.swing.JButton $JButton5;
    private javax.swing.JButton $JButton6;
    private javax.swing.JButton $JButton7;
    private javax.swing.JButton $JButton8;
    private javax.swing.JButton $JButton9;
    private NumberEditor $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JToolBar $JToolBar16;
    private javax.swing.JToolBar $JToolBar17;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource22 = new DataBindingListener(this, "$JButton5.enabled");
    private PropertyChangeListener $DataSource23 = new DataBindingListener(this, "$JButton9.enabled");
    private PropertyChangeListener $DataSource24 = new DataBindingListener(this, "$JButton14.enabled");
    private PropertyChangeListener $DataSource25 = new DataBindingListener(this, "toggleSign.enabled");
    private PropertyChangeListener $DataSource26 = new DataBindingListener(this, "dot.enabled");
    private PropertyChangeListener $DataSource28 = new DataBindingListener(this, "$JToolBar16.visible");
    private PropertyChangeListener $DataSource30 = new DataBindingListener(this, "resetButton.enabled");
    private PropertyChangeListener $DataSource31 = new DataBindingListener(this, "textField.enabled");
    private PropertyChangeListener $DataSource32 = new DataBindingListener(this, "textField.text");
    private PropertyChangeListener $DataSource34 = new DataBindingListener(this, "$JToolBar17.visible");
    private PropertyChangeListener $DataSource36 = new DataBindingListener(this, "button.enabled");

    /* begin raw body code */
    public void init() {
        handler.init();
    }
    
    public NumberEditor getEditor() {
        return this;
    }
    
    public void addChar(ActionEvent event) {
        getHandler().addChar(((JButton)event.getSource()).getText());
    }
    
    void showPopup() {
       if ( popupVisible || autoPopup ) {
           if (!popupVisible) {
               setPopupVisible(true);
           } else if (!getPopup().isVisible()) {
               getHandler().setPopupVisible(true);
           }
       }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public NumberEditor() {
        $initialize();
    }

    public NumberEditor(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$JButton5.enabled".equals($binding)) {    
            addPropertyChangeListener("modelText", $DataSource22);
        } else if ("$JButton9.enabled".equals($binding)) {    
            addPropertyChangeListener("modelText", $DataSource23);
            if (textField != null) {
                textField.addPropertyChangeListener("caretPosition", $DataSource23);
            }
        } else if ("$JButton14.enabled".equals($binding)) {    
            addPropertyChangeListener("editor", $DataSource24);
            if (getEditor() != null) {
                getEditor().addPropertyChangeListener("modelText", $DataSource24);
            }
        } else if ("toggleSign.enabled".equals($binding)) {    
            addPropertyChangeListener("useSign", $DataSource25);
            addPropertyChangeListener("editor", $DataSource25);
            if (getEditor() != null) {
                getEditor().addPropertyChangeListener("modelText", $DataSource25);
            }
        } else if ("dot.enabled".equals($binding)) {    
            addPropertyChangeListener("useFloat", $DataSource26);
            addPropertyChangeListener("editor", $DataSource26);
            if ( getEditor() != null) {
                getEditor().addPropertyChangeListener("modelText", $DataSource26);
            }
        } else if ("$JToolBar16.visible".equals($binding)) {    
            addPropertyChangeListener("showReset", $DataSource28);
        } else if ("resetButton.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource30);
        } else if ("textField.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource31);
        } else if ("textField.text".equals($binding)) {    
            addPropertyChangeListener("modelText", $DataSource32);
        } else if ("$JToolBar17.visible".equals($binding)) {    
            addPropertyChangeListener("showPopupButton", $DataSource34);
        } else if ("button.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource36);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JButton5.enabled".equals($dest)) {
                $JButton5.setEnabled(!getModelText().isEmpty());
            } else if ("$JButton9.enabled".equals($dest)) {
                if (textField != null) {
                    $JButton9.setEnabled(!(getModelText().isEmpty() || textField.getCaretPosition() ==0 ));
                }
            } else if ("$JButton14.enabled".equals($dest)) {
                if (getEditor() != null) {
                    $JButton14.setEnabled(!getEditor().getModelText().equals("0"));
                }
            } else if ("toggleSign.enabled".equals($dest)) {
                if (getEditor() != null) {
                    toggleSign.setEnabled(isUseSign() && !getEditor().getModelText().isEmpty());
                }
            } else if ("dot.enabled".equals($dest)) {
                if ( getEditor() != null) {
                    dot.setEnabled(isUseFloat() && getEditor().getModelText().indexOf(".") == -1 );
                }
            } else if ("$JToolBar16.visible".equals($dest)) {
                $JToolBar16.setVisible(isShowReset());
            } else if ("resetButton.enabled".equals($dest)) {
                resetButton.setEnabled(isEnabled());
            } else if ("textField.enabled".equals($dest)) {
                textField.setEnabled(isEnabled());
            } else if ("textField.text".equals($dest)) {
                jaxx.runtime.SwingUtil.setText(textField, getModelText());
            } else if ("$JToolBar17.visible".equals($dest)) {
                $JToolBar17.setVisible(isShowPopupButton());
            } else if ("button.enabled".equals($dest)) {
                button.setEnabled(isEnabled());
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$JButton5.enabled".equals($binding)) {    
            removePropertyChangeListener("modelText", $DataSource22);
        } else if ("$JButton9.enabled".equals($binding)) {    
            removePropertyChangeListener("modelText", $DataSource23);
            if (textField != null) {
                textField.removePropertyChangeListener("caretPosition", $DataSource23);
            }
        } else if ("$JButton14.enabled".equals($binding)) {    
            removePropertyChangeListener("editor", $DataSource24);
            if (getEditor() != null) {
                getEditor().removePropertyChangeListener("modelText", $DataSource24);
            }
        } else if ("toggleSign.enabled".equals($binding)) {    
            removePropertyChangeListener("useSign", $DataSource25);
            removePropertyChangeListener("editor", $DataSource25);
            if (getEditor() != null) {
                getEditor().removePropertyChangeListener("modelText", $DataSource25);
            }
        } else if ("dot.enabled".equals($binding)) {    
            removePropertyChangeListener("useFloat", $DataSource26);
            removePropertyChangeListener("editor", $DataSource26);
            if ( getEditor() != null) {
                getEditor().removePropertyChangeListener("modelText", $DataSource26);
            }
        } else if ("$JToolBar16.visible".equals($binding)) {    
            removePropertyChangeListener("showReset", $DataSource28);
        } else if ("resetButton.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource30);
        } else if ("textField.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource31);
        } else if ("textField.text".equals($binding)) {    
            removePropertyChangeListener("modelText", $DataSource32);
        } else if ("$JToolBar17.visible".equals($binding)) {    
            removePropertyChangeListener("showPopupButton", $DataSource34);
        } else if ("button.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource36);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton10(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton11(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton12(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton14(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton15(java.awt.event.ActionEvent event) {
        getHandler().validate();
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton5(java.awt.event.ActionEvent event) {
        setModel(null);
    }

    public void doActionPerformed__on__$JButton6(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton7(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton8(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton9(java.awt.event.ActionEvent event) {
        getHandler().removeChar();
    }

    public void doActionPerformed__on__button(java.awt.event.ActionEvent event) {
        getHandler().setPopupVisible(!popup.isVisible());
    }

    public void doActionPerformed__on__dot(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__resetButton(java.awt.event.ActionEvent event) {
        setModel(null);
    }

    public void doActionPerformed__on__toggleSign(java.awt.event.ActionEvent event) {
        getHandler().toggleSign();
    }

    public void doFocusGained__on__$JPanel0(java.awt.event.FocusEvent event) {
        textField.requestFocus();
    }

    public void doFocusGained__on__textField(java.awt.event.FocusEvent event) {
        showPopup();
    }

    public void doFocusLost__on__$JPanel0(java.awt.event.FocusEvent event) {
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doKeyReleased__on__textField(java.awt.event.KeyEvent event) {
        getHandler().setModel(textField.getText());
    }

    public void doMouseEntered__on__$JButton10(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton10, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton10.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton10.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton11(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton11, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton11.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton11.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton12(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton12, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton12.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton12.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton13(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton13, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton13.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton13.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton14(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton14, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton14.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton14.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton14.setFont($JButton14.getFont().deriveFont($JButton14.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton14.setFont($JButton14.getFont().deriveFont($JButton14.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton15(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton15, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton15.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton15.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton15.setFont($JButton15.getFont().deriveFont($JButton15.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton15.setFont($JButton15.getFont().deriveFont($JButton15.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton2(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton2, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton2.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton3(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton3, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton3.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton4(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton4, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton4.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton5(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton5, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton5.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton6(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton6, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton6.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton7(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton7, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton7.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton8(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton8, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton8.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton9(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton9, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton9.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__dot(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, dot, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((dot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (dot.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() | Font.BOLD));
            } else {
            dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__resetButton(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, resetButton, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
            resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__toggleSign(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, toggleSign, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((toggleSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (toggleSign.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() | Font.BOLD));
            } else {
            toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton10(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton10, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton10.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton10.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton11(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton11, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton11.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton11.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton12(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton12, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton12.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton12.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton13(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton13, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton13.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton13.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton14(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton14, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton14.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton14.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton14.setFont($JButton14.getFont().deriveFont($JButton14.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton14.setFont($JButton14.getFont().deriveFont($JButton14.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton15(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton15, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton15.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton15.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton15.setFont($JButton15.getFont().deriveFont($JButton15.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton15.setFont($JButton15.getFont().deriveFont($JButton15.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton2(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton2, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton2.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton3(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton3, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton3.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton4(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton4, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton4.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton5(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton5, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton5.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton6(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton6, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton6.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton7(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton7, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton7.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton8(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton8, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton8.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton9(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton9, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton9.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() | Font.BOLD));
            } else {
            $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JPanel0(java.awt.event.MouseEvent event) {
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doMouseExited__on__dot(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, dot, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((dot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (dot.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() | Font.BOLD));
            } else {
            dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__resetButton(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, resetButton, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
            resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__toggleSign(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, toggleSign, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((toggleSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (toggleSign.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() | Font.BOLD));
            } else {
            toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeVisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(true);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public java.lang.Boolean getAutoPopup() {
        return autoPopup;
    }

    public java.lang.Object getBean() {
        return bean;
    }

    public javax.swing.JToggleButton getButton() {
        return button;
    }

    public javax.swing.JButton getDot() {
        return dot;
    }

    public jaxx.runtime.swing.editor.NumberEditorHandler getHandler() {
        return handler;
    }

    public java.lang.Number getModel() {
        return model;
    }

    public java.lang.String getModelText() {
        return modelText;
    }

    public java.lang.Class getModelType() {
        return modelType;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public java.lang.Boolean getPopupVisible() {
        return popupVisible;
    }

    public java.lang.String getProperty() {
        return property;
    }

    public javax.swing.JButton getResetButton() {
        return resetButton;
    }

    public java.lang.Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public java.lang.Boolean getShowReset() {
        return showReset;
    }

    public javax.swing.JTextField getTextField() {
        return textField;
    }

    public javax.swing.JButton getToggleSign() {
        return toggleSign;
    }

    public java.lang.Boolean getUseFloat() {
        return useFloat;
    }

    public java.lang.Boolean getUseSign() {
        return useSign;
    }

    public java.lang.Boolean isAutoPopup() {
        return autoPopup !=null && autoPopup;
    }

    public java.lang.Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public java.lang.Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    public java.lang.Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public java.lang.Boolean isUseFloat() {
        return useFloat !=null && useFloat;
    }

    public java.lang.Boolean isUseSign() {
        return useSign !=null && useSign;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAutoPopup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.autoPopup;
        this.autoPopup = newValue;
        firePropertyChange(PROPERTY_AUTO_POPUP, oldValue, newValue);
    }

    public void setBean(java.lang.Object newValue) {
        java.lang.Object oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setModel(java.lang.Number newValue) {
        java.lang.Number oldValue = this.model;
        this.model = newValue;
        firePropertyChange(PROPERTY_MODEL, oldValue, newValue);
    }

    public void setModelText(java.lang.String newValue) {
        java.lang.String oldValue = this.modelText;
        this.modelText = newValue;
        firePropertyChange(PROPERTY_MODEL_TEXT, oldValue, newValue);
    }

    public void setModelType(java.lang.Class newValue) {
        java.lang.Class oldValue = this.modelType;
        this.modelType = newValue;
        firePropertyChange(PROPERTY_MODEL_TYPE, oldValue, newValue);
    }

    public void setPopupVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, newValue);
    }

    public void setProperty(java.lang.String newValue) {
        java.lang.String oldValue = this.property;
        this.property = newValue;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, newValue);
    }

    public void setShowPopupButton(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showPopupButton;
        this.showPopupButton = newValue;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, newValue);
    }

    public void setShowReset(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showReset;
        this.showReset = newValue;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, newValue);
    }

    public void setUseFloat(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.useFloat;
        this.useFloat = newValue;
        firePropertyChange(PROPERTY_USE_FLOAT, oldValue, newValue);
    }

    public void setUseSign(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.useSign;
        this.useSign = newValue;
        firePropertyChange(PROPERTY_USE_SIGN, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton10() {
        return $JButton10;
    }

    protected javax.swing.JButton get$JButton11() {
        return $JButton11;
    }

    protected javax.swing.JButton get$JButton12() {
        return $JButton12;
    }

    protected javax.swing.JButton get$JButton13() {
        return $JButton13;
    }

    protected javax.swing.JButton get$JButton14() {
        return $JButton14;
    }

    protected javax.swing.JButton get$JButton15() {
        return $JButton15;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JButton get$JButton5() {
        return $JButton5;
    }

    protected javax.swing.JButton get$JButton6() {
        return $JButton6;
    }

    protected javax.swing.JButton get$JButton7() {
        return $JButton7;
    }

    protected javax.swing.JButton get$JButton8() {
        return $JButton8;
    }

    protected javax.swing.JButton get$JButton9() {
        return $JButton9;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JToolBar get$JToolBar16() {
        return $JToolBar16;
    }

    protected javax.swing.JToolBar get$JToolBar17() {
        return $JToolBar17;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($JToolBar16, BorderLayout.WEST);
        add(textField, BorderLayout.CENTER);
        add($JToolBar17, BorderLayout.EAST);
        addChildrenToPopup();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton2);
        $JPanel1.add($JButton3);
        $JPanel1.add($JButton4);
        $JPanel1.add($JButton5);
        $JPanel1.add($JButton6);
        $JPanel1.add($JButton7);
        $JPanel1.add($JButton8);
        $JPanel1.add($JButton9);
        $JPanel1.add($JButton10);
        $JPanel1.add($JButton11);
        $JPanel1.add($JButton12);
        $JPanel1.add($JButton13);
        $JPanel1.add($JButton14);
        $JPanel1.add(toggleSign);
        $JPanel1.add(dot);
        $JPanel1.add($JButton15);
        // inline complete setup of $JToolBar16
        $JToolBar16.add(resetButton);
        // inline complete setup of $JToolBar17
        $JToolBar17.add(button);
        // init data bindings
        $JPanel1.setBackground(Color.WHITE);
        $JPanel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        applyDataBinding("$JButton5.enabled");
        applyDataBinding("$JButton9.enabled");
        applyDataBinding("$JButton14.enabled");
        applyDataBinding("toggleSign.enabled");
        applyDataBinding("dot.enabled");
        $JButton15.setIcon(jaxx.runtime.Util.createActionIcon("numbereditor-validate"));
        applyDataBinding("$JToolBar16.visible");
        resetButton.setIcon(jaxx.runtime.Util.createActionIcon("numbereditor-reset"));
        applyDataBinding("resetButton.enabled");
        applyDataBinding("textField.enabled");
        applyDataBinding("textField.text");
        $JToolBar17.setMaximumSize(new Dimension(24,24));
        applyDataBinding("$JToolBar17.visible");
        button.setIcon(jaxx.runtime.Util.createActionIcon("numbereditor-calculator"));
        applyDataBinding("button.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createProperty();
        createBean();
        createModel();
        createModelType();
        createUseFloat();
        createUseSign();
        createAutoPopup();
        createShowPopupButton();
        createShowReset();
        createModelText();
        createPopupVisible();
        createHandler();
        createPopup();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(4,4));
        create$JButton2();
        create$JButton3();
        create$JButton4();
        create$JButton5();
        create$JButton6();
        create$JButton7();
        create$JButton8();
        create$JButton9();
        create$JButton10();
        create$JButton11();
        create$JButton12();
        create$JButton13();
        create$JButton14();
        createToggleSign();
        createDot();
        create$JButton15();
        // inline creation of $JToolBar16
        $objectMap.put("$JToolBar16", $JToolBar16 = new javax.swing.JToolBar());
        $JToolBar16.setName("$JToolBar16");
        $JToolBar16.setBorderPainted(false);
        $JToolBar16.setFloatable(false);
        createResetButton();
        createTextField();
        // inline creation of $JToolBar17
        $objectMap.put("$JToolBar17", $JToolBar17 = new javax.swing.JToolBar());
        $JToolBar17.setName("$JToolBar17");
        $JToolBar17.setBorderPainted(false);
        $JToolBar17.setFloatable(false);
        $JToolBar17.setOpaque(false);
        createButton();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(Util.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener(Util.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$JPanel0"));
        $JPanel0.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JPanel0"));
        
        $completeSetup();
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add($JPanel1);
    }

    protected void create$JButton10() {
        $objectMap.put("$JButton10", $JButton10 = new javax.swing.JButton());
        $JButton10.setName("$JButton10");
        $JButton10.setText(_("numbereditor.1"));
        $JButton10.setFocusable(false);
        $JButton10.setFocusPainted(false);
        if ($JButton10.getFont() != null) {
            $JButton10.setFont($JButton10.getFont().deriveFont((float) 14));
        }
        $JButton10.setForeground(new Color(0, 0, 255));
        $JButton10.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton10"));
        $JButton10.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton10"));
        $JButton10.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton10"));
    }

    protected void create$JButton11() {
        $objectMap.put("$JButton11", $JButton11 = new javax.swing.JButton());
        $JButton11.setName("$JButton11");
        $JButton11.setText(_("numbereditor.2"));
        $JButton11.setFocusable(false);
        $JButton11.setFocusPainted(false);
        if ($JButton11.getFont() != null) {
            $JButton11.setFont($JButton11.getFont().deriveFont((float) 14));
        }
        $JButton11.setForeground(new Color(0, 0, 255));
        $JButton11.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton11"));
        $JButton11.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton11"));
        $JButton11.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton11"));
    }

    protected void create$JButton12() {
        $objectMap.put("$JButton12", $JButton12 = new javax.swing.JButton());
        $JButton12.setName("$JButton12");
        $JButton12.setText(_("numbereditor.3"));
        $JButton12.setFocusable(false);
        $JButton12.setFocusPainted(false);
        if ($JButton12.getFont() != null) {
            $JButton12.setFont($JButton12.getFont().deriveFont((float) 14));
        }
        $JButton12.setForeground(new Color(0, 0, 255));
        $JButton12.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton12"));
        $JButton12.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton12"));
        $JButton12.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton12"));
    }

    protected void create$JButton13() {
        $objectMap.put("$JButton13", $JButton13 = new javax.swing.JButton());
        $JButton13.setName("$JButton13");
        $JButton13.setEnabled(false);
        $JButton13.setFocusable(false);
        $JButton13.setFocusPainted(false);
        if ($JButton13.getFont() != null) {
            $JButton13.setFont($JButton13.getFont().deriveFont((float) 14));
        }
        $JButton13.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton13"));
        $JButton13.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton13"));
    }

    protected void create$JButton14() {
        $objectMap.put("$JButton14", $JButton14 = new javax.swing.JButton());
        $JButton14.setName("$JButton14");
        $JButton14.setText(_("numbereditor.0"));
        $JButton14.setFocusable(false);
        $JButton14.setFocusPainted(false);
        if ($JButton14.getFont() != null) {
            $JButton14.setFont($JButton14.getFont().deriveFont((float) 14));
        }
        $JButton14.setForeground(new Color(0, 0, 255));
        $JButton14.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton14"));
        $JButton14.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton14"));
        $JButton14.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton14"));
    }

    protected void create$JButton15() {
        $objectMap.put("$JButton15", $JButton15 = new javax.swing.JButton());
        $JButton15.setName("$JButton15");
        $JButton15.setFocusable(false);
        $JButton15.setFocusPainted(false);
        if ($JButton15.getFont() != null) {
            $JButton15.setFont($JButton15.getFont().deriveFont((float) 14));
        }
        $JButton15.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton15"));
        $JButton15.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton15"));
        $JButton15.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton15"));
    }

    protected void create$JButton2() {
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("numbereditor.7"));
        $JButton2.setFocusable(false);
        $JButton2.setFocusPainted(false);
        if ($JButton2.getFont() != null) {
            $JButton2.setFont($JButton2.getFont().deriveFont((float) 14));
        }
        $JButton2.setForeground(new Color(0, 0, 255));
        $JButton2.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        $JButton2.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton2"));
        $JButton2.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton2"));
    }

    protected void create$JButton3() {
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("numbereditor.8"));
        $JButton3.setFocusable(false);
        $JButton3.setFocusPainted(false);
        if ($JButton3.getFont() != null) {
            $JButton3.setFont($JButton3.getFont().deriveFont((float) 14));
        }
        $JButton3.setForeground(new Color(0, 0, 255));
        $JButton3.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        $JButton3.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton3"));
        $JButton3.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton3"));
    }

    protected void create$JButton4() {
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("numbereditor.9"));
        $JButton4.setFocusable(false);
        $JButton4.setFocusPainted(false);
        if ($JButton4.getFont() != null) {
            $JButton4.setFont($JButton4.getFont().deriveFont((float) 14));
        }
        $JButton4.setForeground(new Color(0, 0, 255));
        $JButton4.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        $JButton4.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton4"));
        $JButton4.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton4"));
    }

    protected void create$JButton5() {
        $objectMap.put("$JButton5", $JButton5 = new javax.swing.JButton());
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("numbereditor.clearAll"));
        $JButton5.setFocusable(false);
        $JButton5.setFocusPainted(false);
        if ($JButton5.getFont() != null) {
            $JButton5.setFont($JButton5.getFont().deriveFont((float) 14));
        }
        $JButton5.setForeground(new Color(255, 0, 0));
        $JButton5.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        $JButton5.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton5"));
        $JButton5.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton5"));
    }

    protected void create$JButton6() {
        $objectMap.put("$JButton6", $JButton6 = new javax.swing.JButton());
        $JButton6.setName("$JButton6");
        $JButton6.setText(_("numbereditor.4"));
        $JButton6.setFocusable(false);
        $JButton6.setFocusPainted(false);
        if ($JButton6.getFont() != null) {
            $JButton6.setFont($JButton6.getFont().deriveFont((float) 14));
        }
        $JButton6.setForeground(new Color(0, 0, 255));
        $JButton6.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        $JButton6.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton6"));
        $JButton6.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton6"));
    }

    protected void create$JButton7() {
        $objectMap.put("$JButton7", $JButton7 = new javax.swing.JButton());
        $JButton7.setName("$JButton7");
        $JButton7.setText(_("numbereditor.5"));
        $JButton7.setFocusable(false);
        $JButton7.setFocusPainted(false);
        if ($JButton7.getFont() != null) {
            $JButton7.setFont($JButton7.getFont().deriveFont((float) 14));
        }
        $JButton7.setForeground(new Color(0, 0, 255));
        $JButton7.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        $JButton7.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton7"));
        $JButton7.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton7"));
    }

    protected void create$JButton8() {
        $objectMap.put("$JButton8", $JButton8 = new javax.swing.JButton());
        $JButton8.setName("$JButton8");
        $JButton8.setText(_("numbereditor.6"));
        $JButton8.setFocusable(false);
        $JButton8.setFocusPainted(false);
        if ($JButton8.getFont() != null) {
            $JButton8.setFont($JButton8.getFont().deriveFont((float) 14));
        }
        $JButton8.setForeground(new Color(0, 0, 255));
        $JButton8.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        $JButton8.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton8"));
        $JButton8.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton8"));
    }

    protected void create$JButton9() {
        $objectMap.put("$JButton9", $JButton9 = new javax.swing.JButton());
        $JButton9.setName("$JButton9");
        $JButton9.setText(_("numbereditor.clearOne"));
        $JButton9.setFocusable(false);
        $JButton9.setFocusPainted(false);
        if ($JButton9.getFont() != null) {
            $JButton9.setFont($JButton9.getFont().deriveFont((float) 14));
        }
        $JButton9.setForeground(new Color(255, 0, 0));
        $JButton9.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        $JButton9.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton9"));
        $JButton9.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton9"));
    }

    protected void createAutoPopup() {
        $objectMap.put("autoPopup", autoPopup = false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createButton() {
        $objectMap.put("button", button = new javax.swing.JToggleButton());
        button.setName("button");
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setToolTipText(_("numbereditor.action.show.tip"));
        button.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__button"));
    }

    protected void createDot() {
        $objectMap.put("dot", dot = new javax.swing.JButton());
        dot.setName("dot");
        dot.setText(_("numbereditor.."));
        dot.setFocusable(false);
        dot.setFocusPainted(false);
        if (dot.getFont() != null) {
            dot.setFont(dot.getFont().deriveFont((float) 14));
        }
        dot.setForeground(new Color(0, 153, 0));
        dot.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dot"));
        dot.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__dot"));
        dot.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__dot"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.editor.NumberEditorHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createModelText() {
        $objectMap.put("modelText", modelText = "");
    }

    protected void createModelType() {
        $objectMap.put("modelType", modelType = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        popup.setName("popup");
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeVisible", this, "doPopupMenuWillBecomeVisible__on__popup"));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = false);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new javax.swing.JButton());
        resetButton.setName("resetButton");
        resetButton.setFocusPainted(false);
        resetButton.setFocusable(false);
        resetButton.setToolTipText(_("numbereditor.action.reset.tip"));
        if (resetButton.getFont() != null) {
            resetButton.setFont(resetButton.getFont().deriveFont((float) 14));
        }
        resetButton.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
        resetButton.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__resetButton"));
        resetButton.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__resetButton"));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new javax.swing.JTextField());
        textField.setName("textField");
        textField.setColumns(15);
        textField.addFocusListener(Util.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textField"));
        textField.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    protected void createToggleSign() {
        $objectMap.put("toggleSign", toggleSign = new javax.swing.JButton());
        toggleSign.setName("toggleSign");
        toggleSign.setText(_("numbereditor.toggleSign"));
        toggleSign.setFocusable(false);
        toggleSign.setFocusPainted(false);
        if (toggleSign.getFont() != null) {
            toggleSign.setFont(toggleSign.getFont().deriveFont((float) 14));
        }
        toggleSign.setForeground(new Color(0, 153, 0));
        toggleSign.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggleSign"));
        toggleSign.addMouseListener(Util.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__toggleSign"));
        toggleSign.addMouseListener(Util.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__toggleSign"));
    }

    protected void createUseFloat() {
        $objectMap.put("useFloat", useFloat = false);
    }

    protected void createUseSign() {
        $objectMap.put("useSign", useSign = false);
    }

}