package jaxx.runtime.swing;

import jaxx.runtime.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryStatusWidget extends javax.swing.JComponent implements ActionListener, jaxx.runtime.JAXXObject {
    public static final String PROPERTY_PROGRESS_BACKGROUND = "progressBackground";
    public static final String PROPERTY_PROGRESS_FOREGROUND = "progressForeground";
    public static final String PROPERTY_TIMER = "timer";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.MemoryStatusWidget.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdO7GDnfCRWFhBBBRCElGdgdYIAkEWiRyQMBJR3LD2bewN57tldw5fKBA/gZ8APQ0SHRWioKagQfwFhChoEbPrj7PJEXLF3WnnzZs3s2/efIeMVnBhj0WRo0IfRYc7mze3t+819ngTb3PdVEJioKD3pNKQrsO0OzzXCBfrVZNe6qeX1oOODHzuj2SXq5DXuO9x3eYcEc6NZzS1LtWG4XIkQzVgHYpKYn3180f6pfvidRogkqQuS60s/i8r7mSyCmnhIsxRpaes5DG/RTKU8Fuk97g5W/eY1ndZhz+B5zBVhaxkisgQlo7esuWw+ZFEmFneHIIvI6yMqdVdqu1s8U6g9mvIMNQPhdviKKUlyCJkDE4hzBp1UT/hgTmLMXNSBS3Ftb7Fmo9bKgh96vGESXBYF2kkXpCErgSK99AmMhsjCss129OGL1AwTzzj6grCqlXepF6Ex5XTa9s5gDyU5qoJFQmi4OzYIMgQTmyI+MZSdciokI4R5usHPXSfQj33zP/lHkNoo7+LhS/vv72rDCwzQbVPJ0JHHE9XSVOSNHhhSp/s+SVE4ZW2mCzXIae5R+ti12EhQVitHyZxVM9enmPSnTtMt4kiM/X1w8fio88TkK5A3guYW2EGvwE5bNPltAPPjeSNNatopnuM3qeMNoR8Y/SSr7kM2WJD+C754npEg1hIGMRQTSP36Veh9nZtMIwUiTvzT3g8kMwOZIXvCZ/bDeovR+LGTEvNQzeIlyBpLVLmm5d9r5y376Wkbid3Ax9NdCUKzWfVijZ/l47Mkd8dM/ohTH8ARkRkPR0FAAA=";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected java.awt.Color progressBackground;
    protected java.awt.Color progressForeground;
    protected javax.swing.Timer timer;
    private MemoryStatusWidget $JComponent0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource4 = new DataBindingListener(this, "$JComponent0.font");

    /* begin raw body code */
    private final static String memoryTestStr = "99999/99999Mb";
    private FontRenderContext frc;
    private LineMetrics lm;
    
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        repaint();
    }
    
    /** Adds a feature to the Notify attribute of the MemoryStatus object */
    @Override
    public void addNotify() {
        super.addNotify();
        setTimer(new javax.swing.Timer(2000, this));
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
        super.removeNotify();
    }
    
    @Override
    public void paintComponent(Graphics g) {
        Insets insets = new Insets(0, 0, 0, 0);
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int) (runtime.freeMemory() / 1024L);
        int totalMemory = (int) (runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        int width = getWidth() - insets.left - insets.right;
        int height = getHeight() - insets.top - insets.bottom - 1;
        float fraction = (float) usedMemory / (float) totalMemory;
        g.setColor(progressBackground);
        g.fillRect(insets.left, insets.top, (int) ((float) width * fraction), height);
        // No i18n string was :
        // String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
        String str = _("memorywidget.memory", usedMemory / 1024, totalMemory / 1024);
        //FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top,
                (int) ((float) width * fraction), height);
        g2.setColor(progressForeground);
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
        g2 = g.create();
        g2.setClip(insets.left + (int) ((float) width * fraction),
                insets.top, getWidth() - insets.left
                        - (int) ((float) width * fraction), height);
        g2.setColor(getForeground());
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
    }
    
    
    void $afterCompleteSetup() {
        //FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D bounds = getFont().getStringBounds(memoryTestStr, frc);
        Dimension dim = new Dimension((int) bounds.getWidth(), (int) bounds .getHeight());
        setPreferredSize(dim);
        setMaximumSize(dim);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public MemoryStatusWidget() {
        $initialize();
    }

    public MemoryStatusWidget(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$JComponent0.font".equals($binding)) {    
            if (new JLabel() != null) {
                new JLabel().addPropertyChangeListener("font", $DataSource4);
            }
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JComponent0.font".equals($dest)) {
                if (new JLabel() != null) {
                    setFont(new JLabel().getFont());
                }
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$JComponent0.font".equals($binding)) {    
            if (new JLabel() != null) {
                new JLabel().removePropertyChangeListener("font", $DataSource4);
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public java.awt.Color getProgressBackground() {
        return progressBackground;
    }

    public java.awt.Color getProgressForeground() {
        return progressForeground;
    }

    public javax.swing.Timer getTimer() {
        return timer;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setProgressBackground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressBackground;
        this.progressBackground = newValue;
        firePropertyChange(PROPERTY_PROGRESS_BACKGROUND, oldValue, newValue);
    }

    public void setProgressForeground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressForeground;
        this.progressForeground = newValue;
        firePropertyChange(PROPERTY_PROGRESS_FOREGROUND, oldValue, newValue);
    }

    public void setTimer(javax.swing.Timer newValue) {
        javax.swing.Timer oldValue = this.timer;
        this.timer = newValue;
        firePropertyChange(PROPERTY_TIMER, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // init data bindings
        setBackground(Color.WHITE);
        applyDataBinding("$JComponent0.font");
        setForeground(Color.BLACK);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JComponent0", this);
        createTimer();
        createProgressBackground();
        createProgressForeground();
        frc = new FontRenderContext(null, false, false);
        lm = new JLabel().getFont().getLineMetrics(memoryTestStr, frc);
        // inline creation of $JComponent0
        setName("$JComponent0");
        
        $completeSetup();
    }

    protected void createProgressBackground() {
        $objectMap.put("progressBackground", progressBackground = Color.decode("#666699a"));
    }

    protected void createProgressForeground() {
        $objectMap.put("progressForeground", progressForeground = Color.decode("#cccccc"));
    }

    protected void createTimer() {
        $objectMap.put("timer", timer = null);
    }

}