package org.nuiton.jaxx.widgets.gis.absolute;

/*
 * #%L
 * JAXX :: Widgets Gis
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import static org.nuiton.i18n.I18n.t;

public class CoordinatesEditor extends JPanel implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DD_FORMAT_SELECTED = "ddFormat.selected";
    public static final String BINDING_DMD_FORMAT_SELECTED = "dmdFormat.selected";
    public static final String BINDING_DMS_FORMAT_SELECTED = "dmsFormat.selected";
    public static final String BINDING_LATITUDE_DD_SHOW_RESET = "latitudeDd.showReset";
    public static final String BINDING_LATITUDE_DD_VALUE = "latitudeDd.value";
    public static final String BINDING_LATITUDE_DMD_SHOW_RESET = "latitudeDmd.showReset";
    public static final String BINDING_LATITUDE_DMD_VALUE = "latitudeDmd.value";
    public static final String BINDING_LATITUDE_DMS_SHOW_RESET = "latitudeDms.showReset";
    public static final String BINDING_LATITUDE_DMS_VALUE = "latitudeDms.value";
    public static final String BINDING_LATITUDE_LAYOUT_SELECTED = "latitudeLayout.selected";
    public static final String BINDING_LONGITUDE_DD_SHOW_RESET = "longitudeDd.showReset";
    public static final String BINDING_LONGITUDE_DD_VALUE = "longitudeDd.value";
    public static final String BINDING_LONGITUDE_DMD_SHOW_RESET = "longitudeDmd.showReset";
    public static final String BINDING_LONGITUDE_DMD_VALUE = "longitudeDmd.value";
    public static final String BINDING_LONGITUDE_DMS_SHOW_RESET = "longitudeDms.showReset";
    public static final String BINDING_LONGITUDE_DMS_VALUE = "longitudeDms.value";
    public static final String BINDING_LONGITUDE_LAYOUT_SELECTED = "longitudeLayout.selected";
    public static final String BINDING_MODEL_FORMAT = "model.format";
    public static final String BINDING_MODEL_QUADRANT = "model.quadrant";
    public static final String BINDING_QUADRANT1_SELECTED = "quadrant1.selected";
    public static final String BINDING_QUADRANT2_SELECTED = "quadrant2.selected";
    public static final String BINDING_QUADRANT3_SELECTED = "quadrant3.selected";
    public static final String BINDING_QUADRANT4_SELECTED = "quadrant4.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CoordinatesEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table coordinateEditorContainer;
    protected CoordinatesEditor coordinateEditorTopPanel = this;
    protected Table coordinatesPanel;
    protected JRadioButton ddFormat;
    protected JRadioButton dmdFormat;
    protected JRadioButton dmsFormat;
    protected JAXXButtonGroup formatBG;
    protected JPanel formatPanel;
    protected final CoordinatesEditorHandler handler = new CoordinatesEditorHandler();
    protected AbsoluteDdCoordinateEditor latitudeDd;
    protected AbsoluteDmdCoordinateEditor latitudeDmd;
    protected AbsoluteDmsCoordinateEditor latitudeDms;
    @ValidatorField( validatorId = "validator",  propertyName = "latitude",  editorName = "latitudeEditor")
    protected JPanel latitudeEditor;
    protected JLabel latitudeLabel;
    protected CardLayout2Ext latitudeLayout;
    protected AbsoluteCoordinateEditorModel latitudeModel;
    protected AbsoluteDdCoordinateEditor longitudeDd;
    protected AbsoluteDmdCoordinateEditor longitudeDmd;
    protected AbsoluteDmsCoordinateEditor longitudeDms;
    @ValidatorField( validatorId = "validator",  propertyName = "longitude",  editorName = "longitudeEditor")
    protected JPanel longitudeEditor;
    protected JLabel longitudeLabel;
    protected CardLayout2Ext longitudeLayout;
    protected AbsoluteCoordinateEditorModel longitudeModel;
    protected CoordinatesEditorModel model;
    protected JToggleButton quadrant1;
    protected JToggleButton quadrant2;
    protected JToggleButton quadrant3;
    protected JToggleButton quadrant4;
    protected JAXXButtonGroup quadrantBG;
    @ValidatorField( validatorId = "validator",  propertyName = "quadrant",  editorName = "quadrantEditor")
    protected JPanel quadrantEditor;
    @Validator( validatorId = "validator")
    protected SwingValidator<CoordinatesEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setPropertyQuadrant(String property) { model.setPropertyQuadrant(property); }
    public void setPropertyLatitude(String property) { model.setPropertyLatitude(property); }
    public void setPropertyLongitude(String property) { model.setPropertyLongitude(property); }
    public void setQuadrant(Integer quadrant) { model.setQuadrant(quadrant); }
    public void setLatitude(Float latitude) { model.setLatitude(latitude); }
    public void setLongitude(Float longitude) { model.setLongitude(longitude); }
    public void setFormat(CoordinateFormat format) { model.setFormat(format); }
    public void setShowResetButton(boolean showResetButton) { model.setShowResetButton(showResetButton); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CoordinatesEditor() {
        $initialize();
    }

    public CoordinatesEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CoordinatesEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CoordinatesEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getCoordinateEditorContainer() {
        return coordinateEditorContainer;
    }

    public Table getCoordinatesPanel() {
        return coordinatesPanel;
    }

    public JRadioButton getDdFormat() {
        return ddFormat;
    }

    public JRadioButton getDmdFormat() {
        return dmdFormat;
    }

    public JRadioButton getDmsFormat() {
        return dmsFormat;
    }

    public JAXXButtonGroup getFormatBG() {
        return formatBG;
    }

    public JPanel getFormatPanel() {
        return formatPanel;
    }

    public CoordinatesEditorHandler getHandler() {
        return handler;
    }

    public AbsoluteDdCoordinateEditor getLatitudeDd() {
        return latitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLatitudeDmd() {
        return latitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLatitudeDms() {
        return latitudeDms;
    }

    public JPanel getLatitudeEditor() {
        return latitudeEditor;
    }

    public JLabel getLatitudeLabel() {
        return latitudeLabel;
    }

    public CardLayout2Ext getLatitudeLayout() {
        return latitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLatitudeModel() {
        return latitudeModel;
    }

    public AbsoluteDdCoordinateEditor getLongitudeDd() {
        return longitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLongitudeDmd() {
        return longitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLongitudeDms() {
        return longitudeDms;
    }

    public JPanel getLongitudeEditor() {
        return longitudeEditor;
    }

    public JLabel getLongitudeLabel() {
        return longitudeLabel;
    }

    public CardLayout2Ext getLongitudeLayout() {
        return longitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLongitudeModel() {
        return longitudeModel;
    }

    public CoordinatesEditorModel getModel() {
        return model;
    }

    public JToggleButton getQuadrant1() {
        return quadrant1;
    }

    public JToggleButton getQuadrant2() {
        return quadrant2;
    }

    public JToggleButton getQuadrant3() {
        return quadrant3;
    }

    public JToggleButton getQuadrant4() {
        return quadrant4;
    }

    public JAXXButtonGroup getQuadrantBG() {
        return quadrantBG;
    }

    public JPanel getQuadrantEditor() {
        return quadrantEditor;
    }

    public SwingValidator<CoordinatesEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCoordinateEditorContainer() {
        if (!allComponentsCreated) {
            return;
        }
        coordinateEditorContainer.add(SwingUtil.boxComponentWithJxLayer(quadrantEditor), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordinateEditorContainer.add(coordinatesPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordinateEditorContainer.add(formatPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToCoordinateEditorTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(coordinateEditorContainer);
    }

    protected void addChildrenToCoordinatesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        coordinatesPanel.add(latitudeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        coordinatesPanel.add(SwingUtil.boxComponentWithJxLayer(latitudeEditor), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        coordinatesPanel.add(longitudeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        coordinatesPanel.add(SwingUtil.boxComponentWithJxLayer(longitudeEditor), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToDdFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; ddFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(ddFormat); }
    }

    protected void addChildrenToDmdFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; dmdFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmdFormat); }
    }

    protected void addChildrenToDmsFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; dmsFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmsFormat); }
    }

    protected void addChildrenToFormatPanel() {
        if (!allComponentsCreated) {
            return;
        }
        formatPanel.add(ddFormat);
        formatPanel.add(dmsFormat);
        formatPanel.add(dmdFormat);
    }

    protected void addChildrenToLatitudeEditor() {
        if (!allComponentsCreated) {
            return;
        }
        latitudeEditor.add(latitudeDd, CoordinateFormat.dd.name());
        latitudeEditor.add(latitudeDms, CoordinateFormat.dms.name());
        latitudeEditor.add(latitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToLongitudeEditor() {
        if (!allComponentsCreated) {
            return;
        }
        longitudeEditor.add(longitudeDd, CoordinateFormat.dd.name());
        longitudeEditor.add(longitudeDms, CoordinateFormat.dms.name());
        longitudeEditor.add(longitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToQuadrant1() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant1); }
    }

    protected void addChildrenToQuadrant2() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant2); }
    }

    protected void addChildrenToQuadrant3() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant3); }
    }

    protected void addChildrenToQuadrant4() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant4); }
    }

    protected void addChildrenToQuadrantEditor() {
        if (!allComponentsCreated) {
            return;
        }
        quadrantEditor.add(quadrant4);
        quadrantEditor.add(quadrant1);
        quadrantEditor.add(quadrant3);
        quadrantEditor.add(quadrant2);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setBean(model);
    }

    protected void createCoordinateEditorContainer() {
        $objectMap.put("coordinateEditorContainer", coordinateEditorContainer = new Table());
        
        coordinateEditorContainer.setName("coordinateEditorContainer");
    }

    protected void createCoordinatesPanel() {
        $objectMap.put("coordinatesPanel", coordinatesPanel = new Table());
        
        coordinatesPanel.setName("coordinatesPanel");
    }

    protected void createDdFormat() {
        $objectMap.put("ddFormat", ddFormat = new JRadioButton());
        
        ddFormat.setName("ddFormat");
        ddFormat.setText(t("jaxx.coordinate.format.dd"));
        ddFormat.setToolTipText(t("jaxx.coordinate.format.dd.tip"));
    }

    protected void createDmdFormat() {
        $objectMap.put("dmdFormat", dmdFormat = new JRadioButton());
        
        dmdFormat.setName("dmdFormat");
        dmdFormat.setText(t("jaxx.coordinate.format.dmd"));
        dmdFormat.setToolTipText(t("jaxx.coordinate.format.dmd.tip"));
    }

    protected void createDmsFormat() {
        $objectMap.put("dmsFormat", dmsFormat = new JRadioButton());
        
        dmsFormat.setName("dmsFormat");
        dmsFormat.setText(t("jaxx.coordinate.format.dms"));
        dmsFormat.setToolTipText(t("jaxx.coordinate.format.dms.tip"));
    }

    protected void createFormatBG() {
        $objectMap.put("formatBG", formatBG = new JAXXButtonGroup());
    }

    protected void createFormatPanel() {
        $objectMap.put("formatPanel", formatPanel = new JPanel());
        
        formatPanel.setName("formatPanel");
        formatPanel.setLayout(new GridLayout(0,1,0,0));
    }

    protected void createLatitudeDd() {
        $objectMap.put("latitudeDd", latitudeDd = new AbsoluteDdCoordinateEditor());
        
        latitudeDd.setName("latitudeDd");
        latitudeDd.setPropertyDegree("ddDegree");
        latitudeDd.setPropertyDecimal("ddDecimal");
    }

    protected void createLatitudeDmd() {
        $objectMap.put("latitudeDmd", latitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        latitudeDmd.setName("latitudeDmd");
        latitudeDmd.setPropertyDegree("dmdDegree");
        latitudeDmd.setPropertyMinute("dmdMinute");
        latitudeDmd.setPropertyDecimal("dmdDecimal");
    }

    protected void createLatitudeDms() {
        $objectMap.put("latitudeDms", latitudeDms = new AbsoluteDmsCoordinateEditor());
        
        latitudeDms.setName("latitudeDms");
        latitudeDms.setPropertySecond("dmsSecond");
        latitudeDms.setPropertyDegree("dmsDegree");
        latitudeDms.setPropertyMinute("dmsMinute");
    }

    protected void createLatitudeEditor() {
        $objectMap.put("latitudeEditor", latitudeEditor = new JPanel());
        
        latitudeEditor.setName("latitudeEditor");
        latitudeEditor.setLayout(latitudeLayout);
    }

    protected void createLatitudeLabel() {
        $objectMap.put("latitudeLabel", latitudeLabel = new JLabel());
        
        latitudeLabel.setName("latitudeLabel");
        latitudeLabel.setText(t("jaxx.common.latitude"));
    }

    protected void createLatitudeLayout() {
        $objectMap.put("latitudeLayout", latitudeLayout = new CardLayout2Ext(this, "latitudeEditor"));
    }

    protected void createLatitudeModel() {
        $objectMap.put("latitudeModel", latitudeModel = model.getLatitudeModel());
    }

    protected void createLongitudeDd() {
        $objectMap.put("longitudeDd", longitudeDd = new AbsoluteDdCoordinateEditor());
        
        longitudeDd.setName("longitudeDd");
        longitudeDd.setPropertyDegree("ddDegree");
        longitudeDd.setPropertyDecimal("ddDecimal");
    }

    protected void createLongitudeDmd() {
        $objectMap.put("longitudeDmd", longitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        longitudeDmd.setName("longitudeDmd");
        longitudeDmd.setPropertyDegree("dmdDegree");
        longitudeDmd.setPropertyMinute("dmdMinute");
        longitudeDmd.setPropertyDecimal("dmdDecimal");
    }

    protected void createLongitudeDms() {
        $objectMap.put("longitudeDms", longitudeDms = new AbsoluteDmsCoordinateEditor());
        
        longitudeDms.setName("longitudeDms");
        longitudeDms.setPropertySecond("dmsSecond");
        longitudeDms.setPropertyDegree("dmsDegree");
        longitudeDms.setPropertyMinute("dmsMinute");
    }

    protected void createLongitudeEditor() {
        $objectMap.put("longitudeEditor", longitudeEditor = new JPanel());
        
        longitudeEditor.setName("longitudeEditor");
        longitudeEditor.setLayout(longitudeLayout);
    }

    protected void createLongitudeLabel() {
        $objectMap.put("longitudeLabel", longitudeLabel = new JLabel());
        
        longitudeLabel.setName("longitudeLabel");
        longitudeLabel.setText(t("jaxx.common.longitude"));
    }

    protected void createLongitudeLayout() {
        $objectMap.put("longitudeLayout", longitudeLayout = new CardLayout2Ext(this, "longitudeEditor"));
    }

    protected void createLongitudeModel() {
        $objectMap.put("longitudeModel", longitudeModel = model.getLongitudeModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorModel.class));
    }

    protected void createQuadrant1() {
        $objectMap.put("quadrant1", quadrant1 = new JToggleButton());
        
        quadrant1.setName("quadrant1");
        quadrant1.setText(t("jaxx.common.quadrant1"));
    }

    protected void createQuadrant2() {
        $objectMap.put("quadrant2", quadrant2 = new JToggleButton());
        
        quadrant2.setName("quadrant2");
        quadrant2.setText(t("jaxx.common.quadrant2"));
    }

    protected void createQuadrant3() {
        $objectMap.put("quadrant3", quadrant3 = new JToggleButton());
        
        quadrant3.setName("quadrant3");
        quadrant3.setText(t("jaxx.common.quadrant3"));
    }

    protected void createQuadrant4() {
        $objectMap.put("quadrant4", quadrant4 = new JToggleButton());
        
        quadrant4.setName("quadrant4");
        quadrant4.setText(t("jaxx.common.quadrant4"));
    }

    protected void createQuadrantBG() {
        $objectMap.put("quadrantBG", quadrantBG = new JAXXButtonGroup());
    }

    protected void createQuadrantEditor() {
        $objectMap.put("quadrantEditor", quadrantEditor = new JPanel());
        
        quadrantEditor.setName("quadrantEditor");
        quadrantEditor.setLayout(new GridLayout(2,2,0,0));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CoordinatesEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCoordinateEditorTopPanel();
        addChildrenToValidator();
        addChildrenToCoordinateEditorContainer();
        addChildrenToQuadrantEditor();
        addChildrenToQuadrant4();
        addChildrenToQuadrant1();
        addChildrenToQuadrant3();
        addChildrenToQuadrant2();
        addChildrenToCoordinatesPanel();
        addChildrenToLatitudeEditor();
        addChildrenToLongitudeEditor();
        addChildrenToFormatPanel();
        addChildrenToDdFormat();
        addChildrenToDmsFormat();
        addChildrenToDmdFormat();
        
        // apply 23 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        { quadrant4.putClientProperty("$value", new Integer(4));  Object $buttonGroup = quadrant4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant1.putClientProperty("$value", new Integer(1));  Object $buttonGroup = quadrant1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant3.putClientProperty("$value", new Integer(3));  Object $buttonGroup = quadrant3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant2.putClientProperty("$value", new Integer(2));  Object $buttonGroup = quadrant2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeLabel.setLabelFor(latitudeEditor);
        latitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDd.setBean(latitudeModel);
        latitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDms.setBean(latitudeModel);
        latitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDmd.setBean(latitudeModel);
        longitudeLabel.setLabelFor(longitudeEditor);
        longitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDd.setBean(longitudeModel);
        longitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDms.setBean(longitudeModel);
        longitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDmd.setBean(longitudeModel);
        { ddFormat.putClientProperty("$value", CoordinateFormat.dd);  Object $buttonGroup = ddFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { dmsFormat.putClientProperty("$value", CoordinateFormat.dms);  Object $buttonGroup = dmsFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { dmdFormat.putClientProperty("$value", CoordinateFormat.dmd);  Object $buttonGroup = dmdFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("coordinateEditorTopPanel", coordinateEditorTopPanel);
        createModel();
        createLatitudeModel();
        createLongitudeModel();
        createValidator();
        createLatitudeLayout();
        createLongitudeLayout();
        createCoordinateEditorContainer();
        createQuadrantEditor();
        createQuadrant4();
        createQuadrant1();
        createQuadrant3();
        createQuadrant2();
        createCoordinatesPanel();
        createLatitudeLabel();
        createLatitudeEditor();
        createLatitudeDd();
        createLatitudeDms();
        createLatitudeDmd();
        createLongitudeLabel();
        createLongitudeEditor();
        createLongitudeDd();
        createLongitudeDms();
        createLongitudeDmd();
        createFormatPanel();
        createDdFormat();
        createDmsFormat();
        createDmdFormat();
        createQuadrantBG();
        createFormatBG();
        // inline creation of coordinateEditorTopPanel
        setName("coordinateEditorTopPanel");
        
        // registers 23 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 23 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatBG != null) {
                    formatBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatBG != null) {
                    model.setFormat((CoordinateFormat)formatBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatBG != null) {
                    formatBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_QUADRANT, true) {
        
            @Override
            public void applyDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (quadrantBG != null) {
                    model.setQuadrant((Integer)quadrantBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT4_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant4.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 4));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant1.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT3_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant3.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 3));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT2_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant2.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 2));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDd.setValue(latitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDms.setValue(latitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDmd.setValue(latitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDd.setValue(longitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDms.setValue(longitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDmd.setValue(longitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ddFormat.setSelected(model.getFormat() == CoordinateFormat.dd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMS_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmsFormat.setSelected(model.getFormat() == CoordinateFormat.dms);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmdFormat.setSelected(model.getFormat() == CoordinateFormat.dmd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
    }

}