/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JPanel;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.extra.editor.Editor;
import org.nuiton.jaxx.widgets.extra.editor.EditorInterface;
import org.nuiton.util.FileUtil;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;
import org.syntax.jedit.tokenmarker.XMLTokenMarker;

public class JEditEditor
extends JPanel
implements EditorInterface,
DocumentListener {
    private static final long serialVersionUID = 5880160718377536089L;
    private static Log log = LogFactory.getLog(JEditEditor.class);
    protected JEditTextArea editor = new JEditTextArea();
    protected boolean isModified = false;

    public JEditEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.editor, "Center");
    }

    @Override
    public boolean accept(File file) {
        String ext = FileUtil.extension((File)file, (String[])new String[0]);
        boolean result = "java".equalsIgnoreCase(ext);
        result = result || "xml".equalsIgnoreCase(ext);
        return result;
    }

    @Override
    public boolean accept(Editor.EditorSyntaxConstant editorSyntaxConstant) {
        return editorSyntaxConstant.isSupported(Editor.EditorSyntaxConstant.JAVA, Editor.EditorSyntaxConstant.XML);
    }

    @Override
    public void setSyntax(Editor.EditorSyntaxConstant editorSyntax) {
        JavaTokenMarker tokenMarker = null;
        if (editorSyntax.equals((Object)Editor.EditorSyntaxConstant.JAVA)) {
            tokenMarker = new JavaTokenMarker();
        } else if (editorSyntax.equals((Object)Editor.EditorSyntaxConstant.XML)) {
            tokenMarker = new XMLTokenMarker();
        } else {
            log.warn((Object)("Syntax '" + editorSyntax.getName() + "' is not yet supported by JEditEditor"));
        }
        if (tokenMarker != null) {
            this.editor.setTokenMarker((TokenMarker)tokenMarker);
        }
    }

    @Override
    public boolean open(File file) {
        block11: {
            try {
                int last;
                this.editor.getDocument().removeDocumentListener((DocumentListener)this);
                BufferedReader in = new BufferedReader(new FileReader(file));
                String text = "";
                while ((last = ((Reader)in).read()) != -1) {
                    int c = last;
                    if (13 == c) {
                        ((Reader)in).mark(1);
                        last = ((Reader)in).read();
                        if (last != -1) {
                            if ('\n' != (char)last) {
                                ((Reader)in).reset();
                            }
                            c = 10;
                        }
                    }
                    text = text + (char)c;
                }
                String ext = FileUtil.extension((File)file, (String[])new String[0]);
                if ("java".equalsIgnoreCase(ext)) {
                    this.editor.setTokenMarker((TokenMarker)new JavaTokenMarker());
                } else if ("xml".equalsIgnoreCase(ext)) {
                    this.editor.setTokenMarker((TokenMarker)new XMLTokenMarker());
                }
                this.editor.setText(text);
                this.editor.setCaretPosition(0);
                this.editor.getDocument().addDocumentListener((DocumentListener)this);
                this.isModified = false;
                return true;
            }
            catch (FileNotFoundException eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Can't find file: " + file), (Throwable)eee);
                }
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block11;
                log.warn((Object)("Can't open file: " + file), (Throwable)eee);
            }
        }
        return false;
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.editor.getDocument().addDocumentListener(listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.editor.getDocument().removeDocumentListener(listener);
    }

    @Override
    public void addCaretListener(CaretListener listener) {
        this.editor.addCaretListener(listener);
    }

    @Override
    public void removeCaretListener(CaretListener listener) {
        this.editor.removeCaretListener(listener);
    }

    @Override
    public String getText() {
        String result = this.editor.getText();
        return result;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.editor.setEnabled(b);
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public boolean saveAs(File file) {
        try {
            FileUtil.writeString((File)file, (String)this.editor.getText(), (String)"utf-8");
            this.isModified = false;
            return true;
        }
        catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't save file", (Throwable)eee);
            }
            return false;
        }
    }

    @Override
    public void setText(String text) {
        this.editor.setText(text);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void copy() {
        this.editor.copy();
    }

    @Override
    public void cut() {
        this.editor.cut();
    }

    @Override
    public void paste() {
        this.editor.paste();
    }
}

