package org.nuiton.jaxx.widgets.about;

/*-
 * #%L
 * JAXX :: Widgets About
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class AboutUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ICON_PATH = "iconPath";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BOTTOM_LABEL_VISIBLE = "bottomLabel.visible";
    public static final String BINDING_TITLE_LABEL_VISIBLE = "titleLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JDIALOG0_ICON_IMAGE = "$JDialog0.iconImage";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz48MQRSuHTuzZsaPtcNasZLFcKKHEJcVLLKxm8HGrgSTiOrpMlPUdJWq17Y5iD/Bn8DdReLmJA7ODi7iXxBxcBWven70Nm2mY+dQM3n1va++9+p73fP6G8kbTQ4+oGHo6MAH3mHO8sKtW9fdB6wJl5lpaq5AatL9jOVIrkHK3iBugBxu1G16rZdeuyQ7SvrM35A9XyclA08EM23GAMiBZEbTmNrqYHs+VIHusw5EpbG+/PE998J7/ipHSKhQXRlLmRuVFVcyXic57gGZwpMe05qgfgtlaO63UO92G7skqDHXaIc9Is/IRJ0UFNVIBuRQ9pIjjig/VECK1eXLnArZOgHkiNQtxw84SN+JVK9zr8XAONSVATgLdr25pFSUXQCylTelv0KhDWTSqnOsYqerOEZNVNeoKxjyzyRaYdYR5kR7FlmMaavLK9RnAjOmLG3Yg3ajFrRzgC0BB8Hq1GXiT3QUtLCpGF1dXpNSXKQauXcn0L14Ep9vCmkYkEoCejEA7JCFzMSaQaqBvN1JjeNAXbTl3uR51HWZZ1OS4H7xJ1OIyq7EkzuDwvba5bBCk+1PdBbt68T2jf011iB5HWAYr6Lxt+Nv4FbX6zN/eN0SRru/piuf3319u9g3+BSevScVumE+0XhKS8U0cHv0zq67A+CidpWq+QYpGiZwuKPhnU0RttrbRnF43q7IajbduUJNGynyE1/ef5i+92kLyS2SkpDUW6QWv0SK0NbYBSm8UJ2/ECnatr4V10mrDd1vHbzUoehysuOsR4HOudz38IbOhdiH2ZQ+DMS4xY8/K6tvLvR7MYba9v0THvcjf4cUuC+4z6Jx701y6niXlWGBJ+OJTZvhMftdUr2BOxatJ1KLxVbwp3becFTOdiXMUcBxdQNgWLDNPB1VYn+dyUxcDnyPNaWmwKJy5v+fquBK7bFoDE+ls0xmYCm5tPmwpSXqGsJUyaJH0Cf41NskS/G+9OE4Np8Nac90BqKJx9zw3gPzH3qy0GzvdnmFcn/4le3LVBxOHPQf45sgKkhFHwWbZRm3Iz2kP7MjOWz47hAVoxmiG28GZkRTshCVAV9Ma1ytsRA2RWXD14f0pZpBTKUtNX+KXqZiQfCW38F/GEMoj2YSdXsEw28fBOa3EwoAAA==";
    private static final Log log = LogFactory.getLog(AboutUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel bottomLabel;
    protected JButton close;
    protected String iconPath;
    protected JTabbedPane tabs;
    protected JLabel titleLabel;
    protected JPanel topPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AboutUI $JDialog0 = this;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JToolBar $JToolBar0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void display() {
        setSize((int)(getOwner().getWidth() * 0.7), (int)(getOwner().getHeight() * 0.7));
        SwingUtil.center(getOwner(), this);
        setVisible(true);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AboutUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI() {
        $initialize();
    }

    public AboutUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AboutUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AboutUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doWindowClosed__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        SwingUtil.destroy(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getBottomLabel() {
        return bottomLabel;
    }

    public JButton getClose() {
        return close;
    }

    public String getIconPath() {
        return iconPath;
    }

    public JTabbedPane getTabs() {
        return tabs;
    }

    public JLabel getTitleLabel() {
        return titleLabel;
    }

    public JPanel getTopPanel() {
        return topPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setIconPath(String iconPath) {
        String oldValue = this.iconPath;
        this.iconPath = iconPath;
        firePropertyChange(PROPERTY_ICON_PATH, oldValue, iconPath);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBottomLabel() {
        $objectMap.put("bottomLabel", bottomLabel = new JLabel());
        
        bottomLabel.setName("bottomLabel");
    }

    protected void createClose() {
        $objectMap.put("close", close = new JButton());
        
        close.setName("close");
        close.setBorderPainted(false);
        close.setFocusable(false);
        close.setToolTipText(t("aboutframe.close"));
    }

    protected void createIconPath() {
        $objectMap.put("iconPath", iconPath = "/icons/action-close.png");
    }

    protected void createTabs() {
        $objectMap.put("tabs", tabs = new JTabbedPane());
        
        tabs.setName("tabs");
    }

    protected void createTitleLabel() {
        $objectMap.put("titleLabel", titleLabel = new JLabel());
        
        titleLabel.setName("titleLabel");
        if (titleLabel.getFont() != null) {
            titleLabel.setFont(titleLabel.getFont().deriveFont((float) 12));
        }
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new JPanel());
        
        topPanel.setName("topPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        $Table0.add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        $Table0.add(tabs, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(titleLabel, BorderLayout.CENTER);
        $JPanel0.add($JToolBar0, BorderLayout.EAST);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(close);
        // inline complete setup of $JPanel1
        $JPanel1.add(bottomLabel, BorderLayout.CENTER);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        $Table0.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        $JPanel0.setBackground(Color.WHITE);
        close.setIcon(SwingUtil.createActionIcon("close"));
        bottomLabel.setHorizontalAlignment(SwingConstants.CENTER);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createIconPath();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createTitleLabel();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        $JToolBar0.setOpaque(false);
        createClose();
        createTopPanel();
        createTabs();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createBottomLabel();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setResizable(true);
        setUndecorated(true);
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosed", this, "doWindowClosed__on__$JDialog0"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JDIALOG0_ICON_IMAGE, true ,"iconPath") {
        
            @Override
            public void processDataBinding() {
                setIconImage(SwingUtil.createIcon(getIconPath()).getImage());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_LABEL_VISIBLE, true ,"title") {
        
            @Override
            public void processDataBinding() {
                titleLabel.setVisible(getTitle() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BOTTOM_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (bottomLabel != null) {
                    bottomLabel.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bottomLabel != null) {
                    bottomLabel.setVisible(bottomLabel.getText() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bottomLabel != null) {
                    bottomLabel.removePropertyChangeListener("text", this);
                }
            }
        });
    }

}