/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;

/**
 * @param <M> type of model
 * @param <U> type of ui
 * @param <H> type of handler
 * @author chemit */
public abstract class ShowUIAction<M extends DialogUIModel, U extends DialogUI<H>, H extends DialogUIHandler<M, U>> extends javax.swing.AbstractAction {

    protected static Log log = LogFactory.getLog(AbstractUIAction.class);

    protected transient DialogUI<?> ui;

    private static final long serialVersionUID = 1L;

    protected DialogUIDef<M, U, H> uiDef;

    protected transient UIFactory factory;

    protected String position;

    protected boolean undecorated = true;

    protected U initUI(ActionEvent e) {
        return getFactory().getUI(uiDef);
    }

    public ShowUIAction(DialogUI<?> ui, DialogUIDef<M, U, H> uiDef, UIFactory factory, boolean showText) {
        super(uiDef.getShowActionLibelle(), uiDef.getShowUIActionIcon());
        this.ui = ui;
        this.uiDef = uiDef;
        String name = (String) getValue(NAME);
        putValue(DISPLAYED_MNEMONIC_INDEX_KEY, name.length() - 1);
        putValue(ACCELERATOR_KEY, (int) name.charAt(name.length() - 1));
        if (!showText) {
            putValue(NAME, null);
        }
        putValue(SHORT_DESCRIPTION, uiDef.getShowActionTip());
        this.factory = factory;
    }

    public DialogUI<?> getUi() {
        return ui;
    }

    public DialogUIDef<M, U, H> getUiDef() {
        return uiDef;
    }

    public UIFactory getFactory() {
        return factory;
    }

    public void setUiDef(DialogUIDef<M, U, H> uiDef) {
        this.uiDef = uiDef;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
    }

    @Override
    public void actionPerformed(java.awt.event.ActionEvent e) {
        checkInit();
        U gui = initUI(e);
        gui.setTitle(uiDef.getUiTitle());
        log.info(gui.getTitle());
        //TODO ui.setUndecorated(undecorated);
        setPosition(this.getUi(), gui, position);

        gui.setVisible(true);
    }

    protected void setPosition(javax.swing.JDialog parentUI, javax.swing.JDialog ui, String position) {
        if (position == null || parentUI == null) {
            return;
        }
        Point parentLocation = parentUI.getLocationOnScreen();
        Dimension parentSize = parentUI.getSize();

        if (position.equals("bottom-left")) {
            int top = (int) (parentLocation.getY() + parentSize.getHeight());
            int left = (int) (parentLocation.getX());
            Point newLocation = new Point(left, top);
            newLocation.setLocation(left, top);
            ui.setLocation(newLocation);
            return;
        }
        if (position.equals("top-left")) {
            int top = (int) (parentLocation.getY());
            int left = (int) (parentLocation.getX());
            Point newLocation = new Point(left, top);
            newLocation.setLocation(left, top);
            ui.setLocation(newLocation);
            return;
        }
        if (position.equals("top-right")) {
            int top = (int) (parentLocation.getY());
            int left = (int) (parentLocation.getX() + parentSize.getWidth());
            Point newLocation = new Point(left, top);
            newLocation.setLocation(left, top);
            ui.setLocation(newLocation);
            return;
        }
        if (position.equals(("center"))) {
            //TODO
        }
    }

    protected void checkInit() throws IllegalStateException {
        if (factory == null) {
            throw new IllegalStateException("no factory found in " + this);
        }
    }
}