/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.context;

import java.util.regex.Pattern;
import jaxx.runtime.context.DataContext;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DataContextEntryIteratorTest {
    static DataContext.DataContextEntry<?>[] entries;
    DataContext.DataContextEntryIterator instance;

    @BeforeClass
    public static void setUpClass() throws Exception {
        entries = new DataContext.DataContextEntry[3];
        DataContextEntryIteratorTest.entries[0] = new DataContextEntry2();
        DataContextEntryIteratorTest.entries[1] = new DataContextEntry2(entries[0]);
        DataContextEntryIteratorTest.entries[2] = new DataContextEntry2(entries[1]);
    }

    @Test
    public void testEmptyIterator() {
        this.instance = new DataContext.DataContextEntryIterator(DataContext.EMPTY_DATA_CONTEXT_ENTRY_ARRAY);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testEmptyReverseIterator() {
        this.instance = new DataContext.DataContextEntryIterator(DataContext.EMPTY_DATA_CONTEXT_ENTRY_ARRAY, true);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testEmptyLevelIterator() {
        this.instance = new DataContext.DataContextEntryIterator(DataContext.EMPTY_DATA_CONTEXT_ENTRY_ARRAY, 0);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
        this.instance = new DataContext.DataContextEntryIterator(new DataContext.DataContextEntry[]{entries[1]}, 0);
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testSingletonIterator() {
        this.instance = new DataContext.DataContextEntryIterator(new DataContext.DataContextEntry[]{entries[0]});
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        DataContext.DataContextEntry data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        Assert.assertEquals((long)0L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testSingletonReverseIterator() {
        this.instance = new DataContext.DataContextEntryIterator(new DataContext.DataContextEntry[]{entries[0]}, true);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        DataContext.DataContextEntry data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        Assert.assertEquals((long)0L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testSingletonLevelIterator() {
        this.instance = new DataContext.DataContextEntryIterator(new DataContext.DataContextEntry[]{entries[0]}, 0);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        DataContext.DataContextEntry data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        Assert.assertEquals((long)0L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
        this.instance = new DataContext.DataContextEntryIterator(new DataContext.DataContextEntry[]{entries[0]}, 1);
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        Assert.assertEquals((long)0L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
        this.instance = new DataContext.DataContextEntryIterator(entries, 0);
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        Assert.assertEquals((long)0L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testIterator() {
        this.instance = new DataContext.DataContextEntryIterator(entries);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        DataContext.DataContextEntry data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        Assert.assertEquals((long)0L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[1], (Object)data);
        Assert.assertEquals((long)1L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[2], (Object)data);
        Assert.assertEquals((long)2L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testReverseIterator() {
        this.instance = new DataContext.DataContextEntryIterator(entries, true);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        DataContext.DataContextEntry data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[2], (Object)data);
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[1], (Object)data);
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testLevelIterator() {
        this.instance = new DataContext.DataContextEntryIterator(entries, 2);
        boolean result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        DataContext.DataContextEntry data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[0], (Object)data);
        Assert.assertEquals((long)0L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[1], (Object)data);
        Assert.assertEquals((long)1L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)true, (Object)result);
        data = this.instance.next();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals(entries[2], (Object)data);
        Assert.assertEquals((long)2L, (long)data.getLevel());
        result = this.instance.hasNext();
        Assert.assertEquals((Object)false, (Object)result);
    }

    static class DataContextEntry2
    extends DataContext.DataContextEntry<Object> {
        public DataContextEntry2() {
            super(Object.class);
        }

        public DataContextEntry2(DataContext.DataContextEntry<?> previous) {
            super(Object.class, previous);
        }

        public Pattern getPattern() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getContextPath(Object ... args) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean acceptType(Class<?> type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

