/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import jaxx.runtime.DefaultApplicationContext;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultApplicationContextTest {
    static int helloCount;
    static int helloGetCount;
    DefaultApplicationContext context;

    @BeforeClass
    public static void setUpClass() throws Exception {
        helloCount = 0;
        helloGetCount = 0;
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
        this.context = new DefaultApplicationContext();
        Assert.assertEquals((long)0L, (long)helloCount);
        Assert.assertEquals((long)0L, (long)helloGetCount);
    }

    @After
    public void tearDown() {
        this.context = null;
        helloGetCount = 0;
        helloCount = 0;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAutoLoadNamed() {
        this.context.getContextValue(Hello.class, "fakeName");
    }

    @Test
    public void testAutoLoad() {
        Hello hello = (Hello)this.context.getContextValue(Hello.class);
        Assert.assertNotNull((Object)hello);
        Assert.assertEquals((long)1L, (long)helloCount);
        Hello hello2 = (Hello)this.context.getContextValue(Hello.class);
        Assert.assertNotNull((Object)hello2);
        Assert.assertEquals((long)1L, (long)helloCount);
        Assert.assertEquals((Object)hello, (Object)hello2);
    }

    @Test
    public void testForward() {
        this.context.getContextValue(Hello.class);
        Assert.assertEquals((long)1L, (long)helloCount);
        String response = (String)this.context.getContextValue(String.class, "John");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)helloGetCount);
        Assert.assertEquals((Object)new Hello().hello("John"), (Object)response);
    }

    @Test
    public void testRemove() {
        this.context.getContextValue(Hello.class);
        Assert.assertEquals((long)1L, (long)helloCount);
        Assert.assertEquals((long)1L, (long)this.context.forwards.size());
        String response = (String)this.context.getContextValue(String.class, "John");
        Assert.assertNotNull((Object)response);
        this.context.removeContextValue(Hello.class);
        Assert.assertEquals((long)0L, (long)this.context.forwards.size());
        response = (String)this.context.getContextValue(String.class, "John");
        Assert.assertEquals((long)1L, (long)helloCount);
        Assert.assertNull((Object)response);
        this.context.getContextValue(Hello.class);
        Assert.assertEquals((long)2L, (long)helloCount);
        Assert.assertEquals((long)1L, (long)this.context.forwards.size());
        this.context.removeContextValue(Hello.class, "fake");
        Assert.assertEquals((long)1L, (long)this.context.forwards.size());
        this.context.getContextValue(Hello.class);
        Assert.assertEquals((long)2L, (long)helloCount);
    }

    @DefaultApplicationContext.AutoLoad
    @DefaultApplicationContext.MethodAccess(methodName="hello", target=String.class)
    public static class Hello {
        public Hello() {
            ++helloCount;
        }

        public String hello(String name) {
            ++helloGetCount;
            return "hello " + name;
        }
    }
}

