/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime;

import jaxx.css.Stylesheet;

import java.io.Serializable;

public class JAXXObjectDescriptor implements Serializable {
    private ComponentDescriptor[] descriptors;
    private Stylesheet stylesheet;
    private static final long serialVersionUID = 1L;


    public JAXXObjectDescriptor(ComponentDescriptor[] descriptors,
                                Stylesheet stylesheet) {
        this.descriptors = descriptors;
        this.stylesheet = stylesheet;
    }


    public ComponentDescriptor[] getComponentDescriptors() {
        return descriptors;
    }


    public Stylesheet getStylesheet() {
        return stylesheet;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (ComponentDescriptor descriptor : descriptors) {
            buffer.append("\n").append(descriptor);
        }
        buffer.append("\n").append(stylesheet);
        return buffer.toString();
    }
}