package jaxx.runtime;

import java.awt.Container;
import java.util.Map.Entry;

/**
 * An initial context to be inject in a {@link JAXXObject}.
 * <p/>
 * The method {@link #add(Object)}  register a simple value.
 * <p/>
 * The method {@link #add(String, Object)} register a named value.
 * <p/>
 * The method {@link #to(JAXXContext)} inject in the {@link JAXXObject} the values registred in the initial context.
 * <p/>
 * The  initial context is also a "limited" {@link JAXXContext}, since we can only use the two methods
 * <p/>
 * {@link #getContextValue(Class)} or {@link #getContextValue(Class, String)}.
 *
 * @see JAXXContext
 */
public class JAXXInitialContext extends DefaultJAXXContext {

    public JAXXInitialContext() {
        super();
    }

    /**
     * Register a simple (none named) value in the context.
     *
     * @param value the value to be registred in the context
     * @return the instance of the context
     */
    public JAXXInitialContext add(Object value) {
        return add(null, value);
    }

    /**
     * Register a named value in the context.
     *
     * @param name  the name of the value
     * @param value the value to registred
     * @return the instance of the context
     */
    public JAXXInitialContext add(String name, Object value) {
        super.setContextValue(value, name);
        return this;
    }

    /**
     * Inject all the registed values into the {@link JAXXObject}
     *
     * @param dst the object to fill.
     */
    public void to(JAXXContext dst) {
        if (parentContext != null) {
            dst.setContextValue(parentContext);
        }
        for (Entry<JAXXContextEntryDef, Object> entry : data.entrySet()) {
            dst.setContextValue(entry.getValue(), entry.getKey().getName());
        }
    }

    @Override
    public void setContextValue(Object o) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setContextValue(Object o, String name) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public <T> void removeContextValue(Class<T> klazz) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public <T> void removeContextValue(Class<T> klazz, String name) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public <O extends Container> O getParentContainer(Object top, Class<O> clazz) {
        throw new RuntimeException("not implemented");
    }

}
