/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.nuiton.jaxx.plugin.AbstractGenerateHelpMojo;
import org.nuiton.jaxx.plugin.NodeItem;
import org.nuiton.jaxx.plugin.XmlHelper;
import org.nuiton.plugin.VelocityTemplateGenerator;
import org.nuiton.util.SortedProperties;

public class GenerateHelpFilesMojo
extends AbstractGenerateHelpMojo {
    protected static final String AUTOREMOVE_LINE = "REMOVE THS LINE TO DISABLE AUTO-REGENERATE THE FILE";
    protected File outputHelp;
    protected String helpsetName;
    protected File helpsetTemplate;
    protected File mapTemplate;
    protected File indexTemplate;
    protected File tocTemplate;
    protected File contentTemplate;
    protected String mapFileName;
    protected String indexFileName;
    protected String tocFileName;
    protected int touchedFiles;
    protected File idsFile;
    protected Properties helpIds;

    @Override
    public File getTargetDirectory() {
        return this.outputHelp;
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.outputHelp = targetDirectory;
    }

    @Override
    public void init() throws Exception {
        if (!this.generateHelp) {
            return;
        }
        this.checkResource(this.helpsetTemplate);
        this.checkResource(this.mapTemplate);
        this.checkResource(this.indexTemplate);
        this.checkResource(this.tocTemplate);
        this.checkResource(this.contentTemplate);
        this.mapFileName = this.helpsetName + "Map.jhm";
        this.indexFileName = this.helpsetName + "Index.xml";
        this.tocFileName = this.helpsetName + "TOC.xml";
        this.touchedFiles = 0;
        super.init();
        this.idsFile = this.isForce() ? this.getMergeHelpIdsStoreFile() : this.getHelpIdsStoreFile();
        if (!this.idsFile.exists()) {
            return;
        }
        this.helpIds = new SortedProperties();
        Set<String> ids = this.loadHelpIds(this.idsFile);
        for (String id : ids) {
            String path = id.replaceAll("\\.", File.separator) + ".html";
            this.helpIds.put(id, path);
        }
    }

    @Override
    protected boolean checkSkip() {
        boolean b = super.checkSkip();
        if (b) {
            if (!this.idsFile.exists()) {
                if (this.isForce()) {
                    this.getLog().info((CharSequence)("Force flag is on, but no helpIdStore-all to react at " + this.idsFile));
                } else {
                    this.getLog().info((CharSequence)("no helpIdStore to react at " + this.idsFile));
                }
                return false;
            }
            if (this.helpIds == null || this.helpIds.isEmpty()) {
                this.getLog().info((CharSequence)"No help ids to treate.");
                return false;
            }
        }
        return b;
    }

    @Override
    protected void postDoAction() {
        this.getLog().info((CharSequence)(this.touchedFiles + " file(s) treated."));
    }

    @Override
    protected void doActionForLocale(Locale locale, boolean isDefaultLocale, File localizedTarget, String localePath) throws Exception {
        String language = locale.getLanguage();
        this.getLog().info((CharSequence)("Generate help for language " + language));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("  Localized target : " + localizedTarget));
        }
        Properties env = new Properties();
        env.put("helpSetName", this.helpsetName);
        env.put("locale", language);
        env.put("localePath", localePath);
        env.put("separator", "    ");
        env.put("autoremoveLine", AUTOREMOVE_LINE);
        String localeSuffix = isDefaultLocale ? "" : "_" + language;
        String helpsetFileName = this.helpsetName + localeSuffix + ".hs";
        env.put("helpSetFileName", helpsetFileName);
        env.put("mapFileName", this.mapFileName);
        env.put("indexFileName", this.indexFileName);
        env.put("tocFileName", this.tocFileName);
        env.put("generateSearch", (Object)this.generateSearch);
        File file = new File(this.getTargetDirectory(), helpsetFileName);
        boolean doCreate = this.generateHelpsetFile(file, env);
        if (doCreate) {
            ++this.touchedFiles;
        }
        file = new File(localizedTarget, this.mapFileName);
        this.generateMapFile(file, env);
        ++this.touchedFiles;
        file = new File(localizedTarget, this.indexFileName);
        this.generateIndexFile(file, env);
        ++this.touchedFiles;
        file = new File(localizedTarget, this.tocFileName);
        this.generateTocFile(file, env);
        ++this.touchedFiles;
        this.touchedFiles += this.generateContentFiles(localizedTarget, env, localePath);
    }

    protected int generateContentFiles(File localizedTarget, Properties env, String localePath) throws Exception {
        int touchedFiles = 0;
        VelocityTemplateGenerator gen = this.prepareGenerator(this.contentTemplate);
        Enumeration<Object> keys = this.helpIds.keys();
        while (keys.hasMoreElements()) {
            String content;
            String key = (String)keys.nextElement();
            String url = (String)this.helpIds.get(key);
            url = this.helpsetName + File.separator + url;
            File f = new File(localizedTarget, url);
            boolean exist = f.exists();
            if (exist && !(content = FileUtils.readFileToString((File)f)).contains(AUTOREMOVE_LINE)) {
                if (!this.isVerbose()) continue;
                this.getLog().debug((CharSequence)("skip existing file " + f));
                continue;
            }
            this.createDirectoryIfNecessary(f.getParentFile());
            if (this.isVerbose()) {
                if (exist) {
                    this.getLog().info((CharSequence)("regenerate content file " + f));
                } else {
                    this.getLog().info((CharSequence)("generate   content file " + f));
                }
            }
            env.put("helpId", key);
            env.put("helpIdUrl", localePath + "/" + url);
            gen.generate(env, f);
            ++touchedFiles;
        }
        return touchedFiles;
    }

    protected boolean generateHelpsetFile(File file, Properties env) throws Exception {
        String content;
        if (file.exists() && !(content = FileUtils.readFileToString((File)file)).contains(AUTOREMOVE_LINE)) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("skip existing helpset main file " + file));
            }
            return false;
        }
        if (this.isVerbose()) {
            if (file.exists()) {
                this.getLog().info((CharSequence)("regenerate helpset main file " + file));
            } else {
                this.getLog().info((CharSequence)("generate helpset main file " + file));
            }
        }
        this.doGen(this.helpsetTemplate, file, env);
        return true;
    }

    protected Properties generateMapFile(File file, Properties env) throws Exception {
        boolean create;
        Object mergedHelpIds;
        if (file.exists()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("loading existing helpset map file " + file));
            }
            mergedHelpIds = XmlHelper.getExistingHelpIds(file, this.isVerbose(), this.getLog());
            create = false;
        } else {
            mergedHelpIds = new SortedProperties();
            create = true;
        }
        for (Object k : this.helpIds.keySet()) {
            ((Properties)mergedHelpIds).put(k, this.helpsetName + "/" + this.helpIds.get(k));
        }
        if (!((Properties)mergedHelpIds).contains("top")) {
            String topUrl = this.helpsetName + ".html";
            this.helpIds.put("top", topUrl);
            ((Properties)mergedHelpIds).put("top", this.helpsetName + "/" + topUrl);
            if (this.isVerbose()) {
                this.getLog().debug((CharSequence)("add top entry with url " + topUrl));
            }
        }
        if (this.isVerbose()) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset map file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset map file " + file));
            }
        }
        env.put("helpIds", mergedHelpIds);
        this.doGen(this.mapTemplate, file, env);
        env.remove("helpIds");
        return mergedHelpIds;
    }

    protected NodeItem generateIndexFile(File file, Properties env) throws Exception {
        boolean create;
        NodeItem rootItem = null;
        if (file.exists()) {
            create = false;
            rootItem = XmlHelper.getExistingItems("indexitem", file);
        } else {
            create = true;
        }
        if (rootItem == null) {
            rootItem = new NodeItem("top", this.helpsetName);
        }
        for (Object k : this.helpIds.keySet()) {
            NodeItem toc = rootItem.findChild(k + "");
            if (!this.isVerbose()) continue;
            this.getLog().debug((CharSequence)("index " + k + " : " + toc));
        }
        if (this.isVerbose()) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset index file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset index file " + file));
            }
        }
        env.put("rootItem", rootItem);
        this.doGen(this.indexTemplate, file, env);
        env.remove("rootItem");
        return rootItem;
    }

    protected NodeItem generateTocFile(File file, Properties env) throws Exception {
        boolean create;
        NodeItem rootItem = null;
        if (file.exists()) {
            create = false;
            rootItem = XmlHelper.getExistingItems("tocitem", file);
        } else {
            create = true;
        }
        if (rootItem == null) {
            rootItem = new NodeItem("top", this.helpsetName);
        }
        for (Object k : this.helpIds.keySet()) {
            NodeItem toc = rootItem.findChild(k + "");
            if (!this.isVerbose()) continue;
            this.getLog().debug((CharSequence)("toc " + k + " : " + toc));
        }
        if (this.isVerbose()) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset toc file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset toc file " + file));
            }
        }
        env.put("rootItem", rootItem);
        this.doGen(this.tocTemplate, file, env);
        env.remove("rootItem");
        return rootItem;
    }

    protected void doGen(File template, File f, Properties env) throws Exception {
        VelocityTemplateGenerator gen = this.prepareGenerator(template);
        gen.generate(env, f);
    }

    protected VelocityTemplateGenerator prepareGenerator(File template) throws Exception {
        URL templateURL = this.getTemplate(template);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("using template " + templateURL));
        }
        VelocityTemplateGenerator gen = new VelocityTemplateGenerator(this.getProject(), templateURL);
        return gen;
    }
}

