/*
 * #%L
 * JAXX :: Maven plugin
 * 
 * $Id: GenerateHelpIdsMojo.java 2384 2012-07-05 16:08:24Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.8/jaxx-maven-plugin/src/main/java/org/nuiton/jaxx/plugin/GenerateHelpIdsMojo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jaxx.plugin;

import jaxx.compiler.decorators.HelpRootCompiledObjectDecorator;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

import java.io.File;
import java.util.Locale;
import java.util.Set;

/**
 * Generate the help ids files from the previous jaxx generation.
 * <p/>
 * Created: 22 déc. 2009
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.0
 */
@Mojo(name = "generate-help-ids",
      defaultPhase = LifecyclePhase.PROCESS_SOURCES, requiresProject = true)
public class GenerateHelpIdsMojo extends AbstractGenerateHelpMojo {

    /** help ids to react. */
    protected Set<String> helpIds;

    @Override
    public void init() throws Exception {
        if (!generateHelp) {

            return;
        }

        super.init();

        // check there is some bundle
        if (getHelpIdsFilename() == null) {
            throw new MojoFailureException(
                    "you must set the 'helpIdStore' property.");
        }
        if (getMergeHelpIdsFilename() == null) {
            throw new MojoFailureException(
                    "you must set the 'helpIdStoreAll' property.");
        }

        helpIds = HelpRootCompiledObjectDecorator.getHelpIds();

        // always clean helpIdsStore before all
        cleanHelpIdsStore();

    }

    @Override
    protected boolean checkSkip() {
        boolean b = super.checkSkip();
        if (b) {

            if (helpIds.isEmpty()) {
//            if (isVerbose()) {
                // no ids detected in this compilation round
                getLog().info("No help ids to treate, will skip goal.");
//            }
                return false;
            }
        }
        return b;
    }

    @Override
    public void doAction() throws Exception {

        // store current jaxx session detected help ids

        File idsStore = getHelpIdsStoreFile();
        getLog().info("Store detected help ids to " + idsStore);

        storeHelpIds(idsStore, helpIds);

        // store merged help ids (to make possible a force on help generation)


        File idsStoreAll = getMergeHelpIdsStoreFile();
        getLog().info("Merge help ids to " + idsStoreAll);

        if (idsStoreAll.exists()) {
            Set<String> allIds = loadHelpIds(idsStoreAll);
            helpIds.addAll(allIds);
            allIds.clear();
        }

        storeHelpIds(idsStoreAll, helpIds);

        helpIds.clear();

    }

    @Override
    protected void doActionForLocale(Locale locale,
                                     boolean isDefaultLocale,
                                     File source,
                                     String localePath) throws Exception {
        // nothing to do specific to locale
    }

    @Override
    protected void postDoAction() {
    }

    @Override
    public File getTargetDirectory() {
        return getOutputHelpIds();
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        setOutputHelpIds(targetDirectory);
    }
}
