package org.nuiton.jaxx.demo.fun;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n.t;

public class CalculatorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISPLAY_TEXT = "display.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz08TQRTHp4WWXyoqCSQmJk1A0Ii7gKKYEhSpREkRIxyINcbp7liGTHeHmVlYLhw8ePMf8ODVi+F/IJ5MvHjt/2DCn+CbbemC2d2i28NsM+/7Pu/N6863336jnBRo0hU1w/Goch1jG/u+ITxH0ToxVhY3N9eq28RSJSItQblyBWp+MlmUraABu70vFTIqZSCZTZKpSWaLZC65de46xDkFKpZRv1T7jMgtQpRCN2OTLSnN9bay6HNPtGpFdh1V6+fH6UaGlD5nEfI5tD8Cx779D4Dw1N1llKW2QlfL23gXmww7NWhOUKcGB7qo95YYlvIFrpMddIB6yijPsQCYQnf+azwBLkD5XKGBsRKpuy+xQ9iUQhN/H8GGoPHec4wlzCyPYQBpPecBIa9Qnjg16hCFbp0j9WmgDZN7xjZwlREoPBo3O7kHkzACmU7qC3NtKjnD+zA5PSS/pVwp4yphWjPYlmYshYbOiJ54CioFKoVyFiNYnIizVlBoJDKYJzseZvK0oNflROjDtQH2gzMAm9aoCoNzScGH8cFuzrxOhe8lsWeTgvfjg73SqyqBLdWh+HQSfyYpeDeheN1jinK236H4VMLgJK05ieldtqvi8/M23aU2iSYINB735oLLGKHLhBc+U0E54cE2vPXxBqc96hWomu40Gu9Oukwg/HB4IL7uHTdOLGkImit0yjrlvuAPXOiDKap7G2z6kacoM1cxL1ZQnyQMrDuw5onkztdbSugeuriiSYYmGc+w3AJarqdx9H343a8ulF1G/czF9jLW+ueoT20JmJjLbJ8/ehw0d2GvF9bLuk34NeDKu3B70aV5GytcqFLHhiu94MOUJpKn1G7qcO34x5dPN45OJpWBHsfOkxlOK/ca5anDwM0C+245c6RdD3BJPNsNbTfKiDP62c9b1rgRrJtR5+9WxA9e1orv6ceboH/97W3AGOrI0NtVcM35Zv8FrODfpuopshBNHD4fUS+1aMK11ITrqQmF1ITR1ITx1ITJ1AQzNWEmNWE2NWEuNaGYmrCQmrCYmlBKTVhJTVgFwh+9+Giq+QsAAA==";
    private static final Log log = LogFactory.getLog(CalculatorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton c;
    protected JButton ce;
    protected JButton d0;
    protected JButton d1;
    protected JButton d2;
    protected JButton d3;
    protected JButton d4;
    protected JButton d5;
    protected JButton d6;
    protected JButton d7;
    protected JButton d8;
    protected JButton d9;
    protected JLabel display;
    protected JButton divide;
    protected JButton dot;
    protected CalculatorEngine engine;
    protected JButton equals;
    protected JButton multiply;
    protected JButton plus;
    protected JButton sign;
    protected JButton subtract;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CalculatorDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    protected String[] getSources() {
        return addDefaultSources( "CalculatorEngine.java" );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CalculatorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CalculatorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CalculatorDemo() {
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__c(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.clear();
    }

    public void doActionPerformed__on__ce(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.clearEntry();
    }

    public void doActionPerformed__on__d0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(0);
    }

    public void doActionPerformed__on__d1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(1);
    }

    public void doActionPerformed__on__d2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(2);
    }

    public void doActionPerformed__on__d3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(3);
    }

    public void doActionPerformed__on__d4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(4);
    }

    public void doActionPerformed__on__d5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(5);
    }

    public void doActionPerformed__on__d6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(6);
    }

    public void doActionPerformed__on__d7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(7);
    }

    public void doActionPerformed__on__d8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(8);
    }

    public void doActionPerformed__on__d9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(9);
    }

    public void doActionPerformed__on__divide(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.divide();
    }

    public void doActionPerformed__on__dot(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.dot();
    }

    public void doActionPerformed__on__equals(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.equal();
    }

    public void doActionPerformed__on__multiply(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.multiply();
    }

    public void doActionPerformed__on__plus(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.add();
    }

    public void doActionPerformed__on__sign(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.toggleSign();
    }

    public void doActionPerformed__on__subtract(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.subtract();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getC() {
        return c;
    }

    public JButton getCe() {
        return ce;
    }

    public JButton getD0() {
        return d0;
    }

    public JButton getD1() {
        return d1;
    }

    public JButton getD2() {
        return d2;
    }

    public JButton getD3() {
        return d3;
    }

    public JButton getD4() {
        return d4;
    }

    public JButton getD5() {
        return d5;
    }

    public JButton getD6() {
        return d6;
    }

    public JButton getD7() {
        return d7;
    }

    public JButton getD8() {
        return d8;
    }

    public JButton getD9() {
        return d9;
    }

    public JLabel getDisplay() {
        return display;
    }

    public JButton getDivide() {
        return divide;
    }

    public JButton getDot() {
        return dot;
    }

    public CalculatorEngine getEngine() {
        return engine;
    }

    public JButton getEquals() {
        return equals;
    }

    public JButton getMultiply() {
        return multiply;
    }

    public JButton getPlus() {
        return plus;
    }

    public JButton getSign() {
        return sign;
    }

    public JButton getSubtract() {
        return subtract;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createC() {
        $objectMap.put("c", c = new JButton());
        
        c.setName("c");
        c.setText(t("C"));
        c.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__c"));
    }

    protected void createCe() {
        $objectMap.put("ce", ce = new JButton());
        
        ce.setName("ce");
        ce.setText(t("CE"));
        ce.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ce"));
    }

    protected void createD0() {
        $objectMap.put("d0", d0 = new JButton());
        
        d0.setName("d0");
        d0.setText(t("0"));
        d0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d0"));
    }

    protected void createD1() {
        $objectMap.put("d1", d1 = new JButton());
        
        d1.setName("d1");
        d1.setText(t("1"));
        d1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d1"));
    }

    protected void createD2() {
        $objectMap.put("d2", d2 = new JButton());
        
        d2.setName("d2");
        d2.setText(t("2"));
        d2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d2"));
    }

    protected void createD3() {
        $objectMap.put("d3", d3 = new JButton());
        
        d3.setName("d3");
        d3.setText(t("3"));
        d3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d3"));
    }

    protected void createD4() {
        $objectMap.put("d4", d4 = new JButton());
        
        d4.setName("d4");
        d4.setText(t("4"));
        d4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d4"));
    }

    protected void createD5() {
        $objectMap.put("d5", d5 = new JButton());
        
        d5.setName("d5");
        d5.setText(t("5"));
        d5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d5"));
    }

    protected void createD6() {
        $objectMap.put("d6", d6 = new JButton());
        
        d6.setName("d6");
        d6.setText(t("6"));
        d6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d6"));
    }

    protected void createD7() {
        $objectMap.put("d7", d7 = new JButton());
        
        d7.setName("d7");
        d7.setText(t("7"));
        d7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d7"));
    }

    protected void createD8() {
        $objectMap.put("d8", d8 = new JButton());
        
        d8.setName("d8");
        d8.setText(t("8"));
        d8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d8"));
    }

    protected void createD9() {
        $objectMap.put("d9", d9 = new JButton());
        
        d9.setName("d9");
        d9.setText(t("9"));
        d9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d9"));
    }

    protected void createDisplay() {
        $objectMap.put("display", display = new JLabel());
        
        display.setName("display");
    }

    protected void createDivide() {
        $objectMap.put("divide", divide = new JButton());
        
        divide.setName("divide");
        divide.setText(t("\u00f7"));
        divide.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__divide"));
    }

    protected void createDot() {
        $objectMap.put("dot", dot = new JButton());
        
        dot.setName("dot");
        dot.setText(t("."));
        dot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dot"));
    }

    protected void createEngine() {
        $objectMap.put("engine", engine = new CalculatorEngine());
    }

    protected void createEquals() {
        $objectMap.put("equals", equals = new JButton());
        
        equals.setName("equals");
        equals.setText(t("="));
        equals.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__equals"));
    }

    protected void createMultiply() {
        $objectMap.put("multiply", multiply = new JButton());
        
        multiply.setName("multiply");
        multiply.setText(t("x"));
        multiply.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__multiply"));
    }

    protected void createPlus() {
        $objectMap.put("plus", plus = new JButton());
        
        plus.setName("plus");
        plus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__plus"));
    }

    protected void createSign() {
        $objectMap.put("sign", sign = new JButton());
        
        sign.setName("sign");
        sign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sign"));
    }

    protected void createSubtract() {
        $objectMap.put("subtract", subtract = new JButton());
        
        subtract.setName("subtract");
        subtract.setText(t("-"));
        subtract.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__subtract"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createEngine();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createDisplay();
        createC();
        createCe();
        createEquals();
        createD7();
        createD8();
        createD9();
        createPlus();
        createD4();
        createD5();
        createD6();
        createSubtract();
        createD1();
        createD2();
        createD3();
        createMultiply();
        createD0();
        createSign();
        createDot();
        createDivide();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        plus.setText("+");sign.setText("+/-");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (engine != null) {
                    engine.addPropertyChangeListener("displayText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (engine != null) {
                    display.setText(t(engine.getDisplayText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (engine != null) {
                    engine.removePropertyChangeListener("displayText", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(display, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(c, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ce, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(equals, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d7, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d8, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d9, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(plus, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d5, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d6, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subtract, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d3, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multiply, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d0, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sign, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(dot, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(divide, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}