package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.editor.SimpleTimeEditor;
import static org.nuiton.i18n.I18n.t;

public class SimpleTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUvW4TQRDHx05sxzYQQChCoomISfgId1BQGRFQTASWQxBOEeGGtW+xz1rfLrt7+NKkoKDjBShoaVDeIaJCoqH1OyDlEZhdf8XIZwK4uLNmZ37zn7mZ/fITUkrCOpdNJwh9zQOnTaLIkWGg/Q51yo/29nbqbdrQJaoa0heaS+j/EklI1iDvjexKg1OrIMntk1xDcgckd5N3BA9ocAJUrEBO6X1GVYtSreF6bHBDKbc68ixGIpSDXFNVT8v1/f3dXoKWPiYBIoHyM1j2rb8AjKuer0DS9zRcrLTJW+IyEjRRnPSDJhZ01tg2GVHqGenQN3AAmQqkBZEI03D7n9pjcRYVCQ35Qol2+HMSUHZHw8bvJXh46DSGtL6NengunarfEYzuYrrH1mA4QlhyWkPWRG5zjzINpf+kWswYnSnskjqjKHclruOqi/1zrJsJyo5i8w0evPabtl7suWlvNPAuW6PxWxy5p/uqNNybnSlG/CQsJ6kKmTZpjOXS5OlCoVwhdfsVJmVZq3G6LHDIVuOE4FA746Eez1eiBikZohnbFb9PZiVeoFd/GVbil8GksY7vDg/k5+5xb7gBcyhu+U9RJ5Ydx1FILqjUvtG22B//UPvM3SaiWIOsogxvCnsTrM1WXh14onpUccGQHENynhDVQloq0zv6uvTqxxwktyDHOPG2iPF/Clndwq/S4syLxMZDK+5MdwGf541MHABG9nmIu3buvkc0Wa77gYdf5UGEXVqb3aWRqMOd42+fPlw7GnYqgRoLp4kcdyv1EtJ+wPyA2tticBFMvR3yQtHQ4+Mtn7b3CfPOicFOXbXP1an117n0qB3kG1FoXjdtBebfuqUsnYIyr2mkZzCuIOMXWF+7MzwGAAA=";
    private static final Log log = LogFactory.getLog(SimpleTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configPanel;
    protected SimpleTimeEditorDemoModel demoModel;
    protected SimpleTimeEditor editor;
    protected SimpleTimeEditorDemoHandler handler;
    protected JPanel resultPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimpleTimeEditorDemo $DemoPanel0;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimpleTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SimpleTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo() {
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigPanel() {
        return configPanel;
    }

    public SimpleTimeEditorDemoModel getDemoModel() {
        return demoModel;
    }

    public SimpleTimeEditor getEditor() {
        return editor;
    }

    public SimpleTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPane() {
        return resultPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToResultPane() {
        resultPane.add($JLabel0, BorderLayout.CENTER);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new JPanel());
        
        configPanel.setName("configPanel");
    }

    protected void createDemoModel() {
        $objectMap.put("demoModel", demoModel = new SimpleTimeEditorDemoModel());
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new SimpleTimeEditor(this));
        
        editor.setName("editor");
    }

    protected void createResultPane() {
        $objectMap.put("resultPane", resultPane = new JPanel());
        
        resultPane.setName("resultPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new SimpleTimeEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigPanel();
        createEditor();
        createResultPane();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel0.setText(t(t("jaxxdemo.timeeditor.value", demoModel.getTime())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToResultPane();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 2 property setters
        editor.setBorder(new TitledBorder(t("jaxxdemo.timeeditor.editor")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}