package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id: BeanComboBoxDemoHandler.java 2783 2014-02-04 07:27:32Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.3/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/BeanComboBoxDemoHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.entities.DemoDecoratorProvider;
import jaxx.demo.entities.People;
import jaxx.runtime.spi.UIHandler;
import org.nuiton.decorator.JXPathDecorator;

import java.util.List;

import static org.nuiton.i18n.I18n.t;
import static org.nuiton.i18n.I18n.n;

/**
 * Handlerof {@link BeanComboBoxDemo}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.9
 */
public class BeanComboBoxDemoHandler implements UIHandler<BeanComboBoxDemo> {

    private JXPathDecorator<People> decorator;

    @Override
    public void beforeInit(BeanComboBoxDemo ui) {
        this.decorator = (JXPathDecorator<People>)
                new DemoDecoratorProvider().getDecoratorByType(People.class);
    }

    @Override
    public void afterInit(BeanComboBoxDemo ui) {
        List<People> data = new DemoDataProvider().getPeoples();

        ui.getComboBox().init(decorator, data);
    }

    public String getSelectedResult(People people) {
        String result;

        if (people == null) {
            result = t("jaxxdemo.beancomboboxdemo.no.people.selected");
        } else {
            result = t("jaxxdemo.beancomboboxdemo.selected.people", decorator.toString(people));
        }
        return result;
    }

    static {
        n("jaxxdemo.common.people");
        n("jaxxdemo.common.firstName");
        n("jaxxdemo.common.lastName");
        n("jaxxdemo.common.age");
    }
}
