package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id: CoordinateDemoModel.java 2765 2014-01-08 18:55:30Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.3/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/CoordinateDemoModel.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.jdesktop.beans.AbstractSerializableBean;

/**
 * Created on 11/26/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.6
 */
public class CoordinateDemoModel extends AbstractSerializableBean {

    public static final String PROPERTY_LONGITUDE = "longitude";

    public static final String PROPERTY_LATITUDE = "latitude";

    private static final long serialVersionUID = 1L;

    protected Float latitude;

    protected Float longitude;

    public Float getLongitude() {
        return longitude;
    }

    public void setLongitude(Float longitude) {
        Object oldValue = getLongitude();
        this.longitude = longitude;
        firePropertyChange(PROPERTY_LONGITUDE, oldValue, longitude);
    }

    public Float getLatitude() {
        return latitude;
    }

    public void setLatitude(Float latitude) {
        Object oldValue = getLatitude();
        this.latitude = latitude;
        firePropertyChange(PROPERTY_LATITUDE, oldValue, latitude);
    }
}
