/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: NumberEditorDemoModel.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.22/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/NumberEditorDemoModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.component.jaxx.editor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.5
 */
public class NumberEditorDemoModel {

    public static final String INTEGER_PROPERTY = "integerProperty";

    public static final String FLOAT_PROPERTY = "floatProperty";

    protected PropertyChangeSupport p;

    protected int integerProperty;

    protected float floatProperty;

    public NumberEditorDemoModel() {
        p = new PropertyChangeSupport(this);
    }

    public float getFloatProperty() {
        return floatProperty;
    }

    public int getIntegerProperty() {
        return integerProperty;
    }

    public void setFloatProperty(float floatProperty) {
        float old = this.floatProperty;
        this.floatProperty = floatProperty;
        p.firePropertyChange(FLOAT_PROPERTY, old, floatProperty);
    }

    public void setIntegerProperty(int integerProperty) {
        int old = this.integerProperty;
        this.integerProperty = integerProperty;
        p.firePropertyChange(INTEGER_PROPERTY, old, integerProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }
}
