/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box.Filler;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.FontSizor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class DemoSources extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CURRENT_SOURCE = "currentSource";
    public static final String PROPERTY_INCOMING_CLASS = "incomingClass";
    public static final String PROPERTY_SOURCES = "sources";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_FONT_SIZE = "editor.font-size";
    public static final String BINDING_FONT_SIZOR_FONT_SIZE = "fontSizor.fontSize";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz2sTQRSeRpM2qbX1R2uLFapWEMSNICjSok1bQizxB02xYi5OstN2ZHZnOjNrth7EP8E/Qe9eBG+exINnD17Ef0HEg1fxzWySTXRNAskhyc689833vXnf2zffUVpJdPYJDkNHBr6mHnE2Cg8f3qs9IXW9TlRdUqG5RNFnJIVSVTTutteVRuerZZOeb6bn17gnuE/8juylMsopfcCI2iNEa3SmO6OuVL7S3l4KRSBbqG1SSaivfv5IvXRfvE4hFApgNw5SFvplxUoOl1GKuhodh5Oe4jzD/i7QkNTfBb4TZm2NYaXuYo/so+dotIwyAksA0+jc4JIths0PhUZjixv3sU/YFY2mLVOXeNxZh68KD2SdKCFscEaj0T3su4xIjeYTI0vRdpwwQf0694C+PVKjSSPBMbIcu9IRWQ+kERIhaTQVR0YF6GChotM0OmqDAk2ZU6ZKxyFTxKWg2OgqEewaxidNbOioBmA5G1ucs1UsTXi2nZWLgLdwTdladMRDOWt8lYcmcradcGQRlhaLlIFoKN9MZ0q8052T3eGgkj7j7Sq2OiPKK7a2u9NysSKNTnVxq9QlZ8zsdMvJRCkaXeJy19mhO8QJqCPVga9xqEmooXOws1mxz1vwXIBnk7sooGtPd3EDPzixH+KGHamitAyYuYzZ6r8W2oStyDyzf5nHANrd3zMnvrz/9q7YcswUnD2dGNpheOhkIbmAe6Xm6MnILqYR8newWKqirCIMpoWdBvMJxCrNbSAH5x2L+6iE1R5ApEe/fvg48/jzIZQqohzj2C1iE38bZfWehCpw5obi1opldKQxZogbblB1hg94AIY8uuxijRdq1Hfhmm6GUIT5hCK0mdSyn36dqLxdaRViBIjN/Tc8Lkb6EcpQn1Gf2OHRnAuJw2JcKBK4PPZ/0kQYMb850TRT3n5fTVI6UeMSrHUfU18TM7SWIxoLWINja4EmINpkX7dqzL8bFnxuAPDsDhRd4xqz3IcAynCB94NhUdIedwkz29eSQeYHABlrWp/0wDnXF8csl3rI6Y8AgwsauFHsYDME1lSds8Dzozn7gJJGD3UXBsAbjfBUD1oXBym2mX59+mcQHDuvL6vetzYQIeONbYnFkITG4X1KvcDr00iDQB0zb4ECDJcCo1iVwMdDAk40QJ99T2zDbOgj9A/33j7S6gkAAA==";
    private static final Log log = LogFactory.getLog(DemoSources.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String currentSource;
    protected RSyntaxTextArea editor;
    protected JScrollPane editorPane;
    protected JToolBar editorPaneHeader;
    protected FontSizor fontSizor;
    protected DemoSourcesHandler handler;
    protected Class<?> incomingClass;
    protected JComboBox sourceTabs;
    protected List<String> sources;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DemoSources $JPanel0 = this;
    private Filler $Box$Filler0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        //fontSizor.setDefaultFontSize(getConfig().getFontSize());
        fontSizor.init();
        fontSizor.setCallBack(new Runnable() {
    
            @Override
            public void run() {
                log.info("update font size : " + fontSizor.getFontSize());
                getConfig().setFontSize(fontSizor.getFontSize());
            }
        });
        handler.init(this);    
    }
    
    public DemoConfig getConfig() {
        return getContextValue(DemoConfig.class);
    }
    
    public void updateSource(ItemEvent event) {
        setCurrentSource((String) sourceTabs.getSelectedItem());
        editor.setText(handler.getSourceContent(this, getCurrentSource()));
        editor.setSyntaxEditingStyle(handler.getSourceEditingStyle(this, getCurrentSource()));
        editor.setCaretPosition(0);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoSources(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources() {
        $initialize();
    }

    public DemoSources(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__sourceTabs(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if(event.getStateChange() == ItemEvent.SELECTED) { updateSource(event); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getCurrentSource() {
        return currentSource;
    }

    public RSyntaxTextArea getEditor() {
        return editor;
    }

    public JScrollPane getEditorPane() {
        return editorPane;
    }

    public JToolBar getEditorPaneHeader() {
        return editorPaneHeader;
    }

    public FontSizor getFontSizor() {
        return fontSizor;
    }

    public DemoSourcesHandler getHandler() {
        return handler;
    }

    public Class<?> getIncomingClass() {
        return incomingClass;
    }

    public JComboBox getSourceTabs() {
        return sourceTabs;
    }

    public List<String> getSources() {
        return sources;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCurrentSource(String currentSource) {
        String oldValue = this.currentSource;
        this.currentSource = currentSource;
        firePropertyChange(PROPERTY_CURRENT_SOURCE, oldValue, currentSource);
    }

    public void setIncomingClass(Class<?> incomingClass) {
        Class<?> oldValue = this.incomingClass;
        this.incomingClass = incomingClass;
        firePropertyChange(PROPERTY_INCOMING_CLASS, oldValue, incomingClass);
    }

    public void setSources(List<String> sources) {
        List<String> oldValue = this.sources;
        this.sources = sources;
        firePropertyChange(PROPERTY_SOURCES, oldValue, sources);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Filler get$Box$Filler0() {
        return $Box$Filler0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPane() {
        if (!allComponentsCreated) {
            return;
        }
        editorPane.getViewport().add(editor);
    }

    protected void addChildrenToEditorPaneHeader() {
        if (!allComponentsCreated) {
            return;
        }
        editorPaneHeader.add(sourceTabs);
        editorPaneHeader.add($Box$Filler0);
        editorPaneHeader.add(fontSizor);
    }

    protected void createCurrentSource() {
        $objectMap.put("currentSource", currentSource = null);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new RSyntaxTextArea());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.setColumns(80);
        editor.setEditable(false);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(false);
    }

    protected void createEditorPane() {
        $objectMap.put("editorPane", editorPane = new JScrollPane());
        
        editorPane.setName("editorPane");
    }

    protected void createEditorPaneHeader() {
        $objectMap.put("editorPaneHeader", editorPaneHeader = new JToolBar());
        
        editorPaneHeader.setName("editorPaneHeader");
        editorPaneHeader.setBorderPainted(false);
        editorPaneHeader.setFloatable(false);
        editorPaneHeader.setOpaque(false);
    }

    protected void createFontSizor() {
        $objectMap.put("fontSizor", fontSizor = new FontSizor());
        
        fontSizor.setName("fontSizor");
        fontSizor.setOpaque(false);
        fontSizor.setShowFontSize(true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new DemoSourcesHandler());
    }

    protected void createIncomingClass() {
        $objectMap.put("incomingClass", incomingClass = null);
    }

    protected void createSourceTabs() {
        $objectMap.put("sourceTabs", sourceTabs = new JComboBox());
        
        sourceTabs.setName("sourceTabs");
        sourceTabs.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__sourceTabs"));
    }

    protected void createSources() {
        $objectMap.put("sources", sources = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(editorPaneHeader, BorderLayout.SOUTH);
        add(editorPane, BorderLayout.CENTER);
        addChildrenToEditorPaneHeader();
        addChildrenToEditorPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        sourceTabs.setModel(new DefaultComboBoxModel());
        editorPane.setColumnHeaderView(editorPaneHeader);
        editor.setMinimumSize(SwingUtil.newMinDimension());
        editor.setTextAntiAliasHint(RenderingHints.KEY_ANTIALIASING.toString());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createIncomingClass();
        createCurrentSource();
        createSources();
        createEditorPaneHeader();
        createSourceTabs();
        // inline creation of $Box$Filler0
        $objectMap.put("$Box$Filler0", $Box$Filler0 = new Filler(SwingUtil.newMinDimension(), SwingUtil.newMinDimension(), SwingUtil.newMaxXDimension()));
        
        $Box$Filler0.setName("$Box$Filler0");
        createFontSizor();
        createEditorPane();
        createEditor();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FONT_SIZOR_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fontSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    fontSizor.setFontSize(getConfig().getFontSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fontSize", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fontSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    if (editor.getFont() != null) {
                        editor.setFont(editor.getFont().deriveFont((float) getConfig().getFontSize()));
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fontSize", this);
                }
            }
        });
    }

}