package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TQU8TQRR+LbbQgoIgBCIaVDwYZWu8YhShaZRUMNADsRenu0N3cLszzszKcjH+BH+C3r2YePNkPHj24MX4F4zx4NX4ZrrdUmjFJt3dvPd933zvzXtvf0BOSbi0R+LYkVGoWYs66/d2djYbe9TVZapcyYTmEtq/TBaydRj10rjScKVeNfRSQi+t8ZbgIQ0PsZerUFT6IKDKp1RruNDLcJUqbafp5VhEsqOamuqn+vrXz+wr7+WbLEAs0F0BS1k4idWt5FQVsszTMIknPSelgIRNtCFZ2ES/p01sLSBKbZAWfQYvYLgKeUEkimm4/P8lWw3Lj4WG0cUybfFHJKTBTQ23rFkPI47bkXBsjHoMRZxVSsIyjxoBrTKlDVUIK5bXMLxYI5hAmdmemtU+VuDYnEEWUsKky8Nd1owk0YyH1gMGTZ1xQlq3QQMfS1kTuyzQVBq51UhrHmqY7uGs+dR9uspjgx9PaXM+a/oB/nXF8ms01m2+AZzrBY8rn+9vUUUHQ6YMpExdju65HAxru90MN4jr84Gwopc2VcNSn/Yl/W9g/49cQtIdCed7aDjDTneGu0OWqUNORhjGa6ofH/stTLUHfvbIwBtBm/0zM/X1w/f3lc6UD+HZ032hh5YUp09ILqjUzBw93h7xSLOg9JCI5TruCg1ww+0Gz/cxtp2k0Ryed9bQHUN37hPlo0Ru+NvHTzNPvgxBtgLFgBOvQgz+ARS0L7ELPPBicXfFOhrbH8HnhPGmIR+QA44XA2due0SThQYLPWz5nRibMN+nCamTRuHz76ntdyudRmTQ2NxAeLcZuceQZ2HAQmoXPtnlvgs+KhSNPN7d2X5bnDHvokg28ap9XjteqQlfN48bcWReS9ay+SrZ3MSJChpGzADWDgT9h85F1PkLN+Mj8sgFAAA=";
    private static final Log log = LogFactory.getLog(BeanDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected BeanDoubleList<People> doubleList;
    protected JCheckBox filterOnNachoButton;
    protected JCheckBox filterableButton;
    protected final BeanDoubleListDemoHandler handler = createHandler();
    protected JCheckBox highlightFilterTextButton;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanDoubleListDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanDoubleListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo() {
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getFilterOnNachoButton() {
        return filterOnNachoButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(filterOnNachoButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new BeanDoubleList<People>());
        
        doubleList.setName("doubleList");
    }

    protected void createFilterOnNachoButton() {
        $objectMap.put("filterOnNachoButton", filterOnNachoButton = new JCheckBox());
        
        filterOnNachoButton.setName("filterOnNachoButton");
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
    }

    protected BeanDoubleListDemoHandler createHandler() {
        return new BeanDoubleListDemoHandler();
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
        
        // apply 3 property setters
        doubleList.setBeanType(People.class);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createFilterOnNachoButton();
        createDoubleList();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}