package jaxx.demo.component.jaxx.editor.gis;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.gis.DmdCoordinate;
import jaxx.runtime.swing.editor.gis.DmdCoordinateEditor;
import jaxx.runtime.swing.editor.gis.DmsCoordinate;
import jaxx.runtime.swing.editor.gis.DmsCoordinateEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoordinateDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LATITUDE_DD = "latitudeDd";
    public static final String PROPERTY_LONGITUDE_DD = "longitudeDd";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVu24TQRQdG+zECUlwICGIh/IwCAlpndAgkQCBBBOQISgGCeECxp7BXljvLDuzZGkQn8AnQE+DREeFKKgpaBC/gBAFLeLO7JtMQpBTjKN7zz1zH3P3vPmOCtxFM4+w7xuuZwuzR43rl+7eXW89om2xSnnbNR3BXBT85fIo30TDJLZzgeaadRleDcOrK6znMJvaqejFOhri4plFeZdSIdCxbESb82ojdi/6judGrHFSOtZXP3/kX5IXr/MI+Q5kNw2lTP8rKqlkbx3lTSLQONz0FFctbHcgDde0O5DviLStWJjzm7hHn6DnaKCOig52gUyg2d2XrDhUvO8INFxZpT12C9vUmhfojEqWgMVoRxSGslFiAonRMTnUwFxi2lhQGeo4iqwoUKHHCLUEOvv/JDdkZMI0bGFhCo/Q1R7M83Smg3wT+pFmAkxCpuUgu+AgOo6hmAMoxuQADDkUo2YxLBLYPovZnShfaSvrfUTaDqZTjH3KdShxDVRu45ZFYSRTmsyVTyJLcUCxzeyHZgcej0zTD4HX1WAl5HiMHA2Q9bA0aZ2Tx0yMKEdlN7psc4NyuSETGdqVLm0/vsx8GVBJmKO4OzyY3FQmaAMTk132hGD2TnGqFaeziJE0QgcYC4uKGqqpajzudlyW9JySx3xCFKOCIuK7toUQDWQ0A9EhBivBbObjTI+n3kxYrUTE/nNb5wP5XVGPWKCF/1iSIEaSLek4ya45yc6c+5P1iShPbk950+u1qKvjGYm7uU1DxtMLmDAsy+OqFkUS1EoWVU4tZQKqZUFFl3LPEprZjQaeaLv+3sc6bgX7uJ48pzAi/XQbIcRFRzINA2EyEmFKlCPXRAXXAzPsXHOrlm2AK1Cxqb9UTBIq7+/JA1/ef3tXi6RrEO6e0EJTyguS4rjMoa4w5dVjgW55wrSqN7Cz2EQlTi2QbSXLRzWJNUI3JAf3ldUXVoYba5h3gaIw8PXDx8kHn/egfA2+xgyTGpb4a6gkutC3LrOI71xcVhnt2xyEc7/MDSZk4WcMvjVodIlggadbpg0PtXPBhyYc1TQhzqRV+vTrQOPtctSIHCR2eFt40ozCPVQ0bcu0qVLxUKC1qj3scOoRlgixTppz8nfICSWhqc77WyuVZiyPlu/Jn7ZKWf5HlW+2b4YTfTMs9M2w2DfD+b4Z1vpmuAUMfwAf1o5D4QoAAA==";
    private static final Log log = LogFactory.getLog(CoordinateDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected JPanel configLatitude;
    protected JPanel configLongitude;
    protected final CoordinateDemoHandler handler = createHandler();
    protected Float latitudeDd;
    protected NumberEditor latitudeDdEditor;
    protected DmdCoordinate latitudeDmd;
    protected DmdCoordinateEditor latitudeDmdEditor;
    protected DmsCoordinate latitudeDms;
    protected DmsCoordinateEditor latitudeDmsEditor;
    protected JPanel latitudePane;
    protected JCheckBox latitudeShowReset;
    protected JRadioButton latitudeUseDd;
    protected JRadioButton latitudeUseDmd;
    protected JRadioButton latitudeUseDms;
    protected Float longitudeDd;
    protected NumberEditor longitudeDdEditor;
    protected DmdCoordinate longitudeDmd;
    protected DmdCoordinateEditor longitudeDmdEditor;
    protected DmsCoordinate longitudeDms;
    protected DmsCoordinateEditor longitudeDmsEditor;
    protected JPanel longitudePane;
    protected JCheckBox longitudeShowReset;
    protected JRadioButton longitudeUseDd;
    protected JRadioButton longitudeUseDmd;
    protected JRadioButton longitudeUseDms;
    protected CoordinateDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinateDemo $DemoPanel0 = this;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinateDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CoordinateDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo() {
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__latitudeUseDd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDdEditor();
    }

    public void doActionPerformed__on__latitudeUseDmd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDmdEditor();
    }

    public void doActionPerformed__on__latitudeUseDms(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDmsEditor();
    }

    public void doActionPerformed__on__longitudeUseDd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDdEditor();
    }

    public void doActionPerformed__on__longitudeUseDmd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDmdEditor();
    }

    public void doActionPerformed__on__longitudeUseDms(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDmsEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public JPanel getConfigLatitude() {
        return configLatitude;
    }

    public JPanel getConfigLongitude() {
        return configLongitude;
    }

    public CoordinateDemoHandler getHandler() {
        return handler;
    }

    public Float getLatitudeDd() {
        return latitudeDd;
    }

    public NumberEditor getLatitudeDdEditor() {
        return latitudeDdEditor;
    }

    public DmdCoordinate getLatitudeDmd() {
        return latitudeDmd;
    }

    public DmdCoordinateEditor getLatitudeDmdEditor() {
        return latitudeDmdEditor;
    }

    public DmsCoordinate getLatitudeDms() {
        return latitudeDms;
    }

    public DmsCoordinateEditor getLatitudeDmsEditor() {
        return latitudeDmsEditor;
    }

    public JPanel getLatitudePane() {
        return latitudePane;
    }

    public JCheckBox getLatitudeShowReset() {
        return latitudeShowReset;
    }

    public JRadioButton getLatitudeUseDd() {
        return latitudeUseDd;
    }

    public JRadioButton getLatitudeUseDmd() {
        return latitudeUseDmd;
    }

    public JRadioButton getLatitudeUseDms() {
        return latitudeUseDms;
    }

    public Float getLongitudeDd() {
        return longitudeDd;
    }

    public NumberEditor getLongitudeDdEditor() {
        return longitudeDdEditor;
    }

    public DmdCoordinate getLongitudeDmd() {
        return longitudeDmd;
    }

    public DmdCoordinateEditor getLongitudeDmdEditor() {
        return longitudeDmdEditor;
    }

    public DmsCoordinate getLongitudeDms() {
        return longitudeDms;
    }

    public DmsCoordinateEditor getLongitudeDmsEditor() {
        return longitudeDmsEditor;
    }

    public JPanel getLongitudePane() {
        return longitudePane;
    }

    public JCheckBox getLongitudeShowReset() {
        return longitudeShowReset;
    }

    public JRadioButton getLongitudeUseDd() {
        return longitudeUseDd;
    }

    public JRadioButton getLongitudeUseDmd() {
        return longitudeUseDmd;
    }

    public JRadioButton getLongitudeUseDms() {
        return longitudeUseDms;
    }

    public CoordinateDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLatitudeDd(Float latitudeDd) {
        Float oldValue = this.latitudeDd;
        this.latitudeDd = latitudeDd;
        firePropertyChange(PROPERTY_LATITUDE_DD, oldValue, latitudeDd);
    }

    public void setLongitudeDd(Float longitudeDd) {
        Float oldValue = this.longitudeDd;
        this.longitudeDd = longitudeDd;
        firePropertyChange(PROPERTY_LONGITUDE_DD, oldValue, longitudeDd);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        if (!allComponentsCreated) {
            return;
        }
        config.add(configLatitude);
        config.add(configLongitude);
    }

    protected void addChildrenToConfigLatitude() {
        if (!allComponentsCreated) {
            return;
        }
        configLatitude.add(latitudeShowReset);
        configLatitude.add(latitudeUseDms);
        configLatitude.add(latitudeUseDmd);
        configLatitude.add(latitudeUseDd);
    }

    protected void addChildrenToConfigLongitude() {
        if (!allComponentsCreated) {
            return;
        }
        configLongitude.add(longitudeShowReset);
        configLongitude.add(longitudeUseDms);
        configLongitude.add(longitudeUseDmd);
        configLongitude.add(longitudeUseDd);
    }

    protected void addChildrenToLatitudePane() {
        if (!allComponentsCreated) {
            return;
        }
        latitudePane.add(latitudeDmsEditor);
        latitudePane.add(latitudeDmdEditor);
        latitudePane.add(latitudeDdEditor);
    }

    protected void addChildrenToLongitudePane() {
        if (!allComponentsCreated) {
            return;
        }
        longitudePane.add(longitudeDmsEditor);
        longitudePane.add(longitudeDmdEditor);
        longitudePane.add(longitudeDdEditor);
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(1,0));
    }

    protected void createConfigLatitude() {
        $objectMap.put("configLatitude", configLatitude = new JPanel());
        
        configLatitude.setName("configLatitude");
        configLatitude.setLayout(new GridLayout(0,1));
    }

    protected void createConfigLongitude() {
        $objectMap.put("configLongitude", configLongitude = new JPanel());
        
        configLongitude.setName("configLongitude");
        configLongitude.setLayout(new GridLayout(0,1));
    }

    protected CoordinateDemoHandler createHandler() {
        return new CoordinateDemoHandler();
    }

    protected void createLatitudeDd() {
        $objectMap.put("latitudeDd", latitudeDd = null);
    }

    protected void createLatitudeDdEditor() {
        $objectMap.put("latitudeDdEditor", latitudeDdEditor = new NumberEditor(this));
        
        latitudeDdEditor.setName("latitudeDdEditor");
    }

    protected void createLatitudeDmd() {
        $objectMap.put("latitudeDmd", latitudeDmd = new DmdCoordinate());
    }

    protected void createLatitudeDmdEditor() {
        $objectMap.put("latitudeDmdEditor", latitudeDmdEditor = new DmdCoordinateEditor(this));
        
        latitudeDmdEditor.setName("latitudeDmdEditor");
    }

    protected void createLatitudeDms() {
        $objectMap.put("latitudeDms", latitudeDms = new DmsCoordinate());
    }

    protected void createLatitudeDmsEditor() {
        $objectMap.put("latitudeDmsEditor", latitudeDmsEditor = new DmsCoordinateEditor(this));
        
        latitudeDmsEditor.setName("latitudeDmsEditor");
    }

    protected void createLatitudePane() {
        $objectMap.put("latitudePane", latitudePane = new JPanel());
        
        latitudePane.setName("latitudePane");
        latitudePane.setLayout(new GridLayout(0,1));
    }

    protected void createLatitudeShowReset() {
        $objectMap.put("latitudeShowReset", latitudeShowReset = new JCheckBox());
        
        latitudeShowReset.setName("latitudeShowReset");
    }

    protected void createLatitudeUseDd() {
        $objectMap.put("latitudeUseDd", latitudeUseDd = new JRadioButton());
        
        latitudeUseDd.setName("latitudeUseDd");
        latitudeUseDd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDd"));
    }

    protected void createLatitudeUseDmd() {
        $objectMap.put("latitudeUseDmd", latitudeUseDmd = new JRadioButton());
        
        latitudeUseDmd.setName("latitudeUseDmd");
        latitudeUseDmd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDmd"));
    }

    protected void createLatitudeUseDms() {
        $objectMap.put("latitudeUseDms", latitudeUseDms = new JRadioButton());
        
        latitudeUseDms.setName("latitudeUseDms");
        latitudeUseDms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDms"));
    }

    protected void createLongitudeDd() {
        $objectMap.put("longitudeDd", longitudeDd = null);
    }

    protected void createLongitudeDdEditor() {
        $objectMap.put("longitudeDdEditor", longitudeDdEditor = new NumberEditor(this));
        
        longitudeDdEditor.setName("longitudeDdEditor");
    }

    protected void createLongitudeDmd() {
        $objectMap.put("longitudeDmd", longitudeDmd = new DmdCoordinate());
    }

    protected void createLongitudeDmdEditor() {
        $objectMap.put("longitudeDmdEditor", longitudeDmdEditor = new DmdCoordinateEditor(this));
        
        longitudeDmdEditor.setName("longitudeDmdEditor");
    }

    protected void createLongitudeDms() {
        $objectMap.put("longitudeDms", longitudeDms = new DmsCoordinate());
    }

    protected void createLongitudeDmsEditor() {
        $objectMap.put("longitudeDmsEditor", longitudeDmsEditor = new DmsCoordinateEditor(this));
        
        longitudeDmsEditor.setName("longitudeDmsEditor");
    }

    protected void createLongitudePane() {
        $objectMap.put("longitudePane", longitudePane = new JPanel());
        
        longitudePane.setName("longitudePane");
        longitudePane.setLayout(new GridLayout(0,1));
    }

    protected void createLongitudeShowReset() {
        $objectMap.put("longitudeShowReset", longitudeShowReset = new JCheckBox());
        
        longitudeShowReset.setName("longitudeShowReset");
    }

    protected void createLongitudeUseDd() {
        $objectMap.put("longitudeUseDd", longitudeUseDd = new JRadioButton());
        
        longitudeUseDd.setName("longitudeUseDd");
        longitudeUseDd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDd"));
    }

    protected void createLongitudeUseDmd() {
        $objectMap.put("longitudeUseDmd", longitudeUseDmd = new JRadioButton());
        
        longitudeUseDmd.setName("longitudeUseDmd");
        longitudeUseDmd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDmd"));
    }

    protected void createLongitudeUseDms() {
        $objectMap.put("longitudeUseDms", longitudeUseDms = new JRadioButton());
        
        longitudeUseDms.setName("longitudeUseDms");
        longitudeUseDms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDms"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new CoordinateDemoModel());
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToConfigLatitude();
        addChildrenToConfigLongitude();
        // inline complete setup of $JPanel0
        $JPanel0.add(latitudePane);
        $JPanel0.add(longitudePane);
        addChildrenToLatitudePane();
        addChildrenToLongitudePane();
        addChildrenToResult();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        createLatitudeDms();
        createLatitudeDmd();
        createLatitudeDd();
        createLongitudeDms();
        createLongitudeDmd();
        createLongitudeDd();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createConfigLatitude();
        createLatitudeShowReset();
        createLatitudeUseDms();
        createLatitudeUseDmd();
        createLatitudeUseDd();
        createConfigLongitude();
        createLongitudeShowReset();
        createLongitudeUseDms();
        createLongitudeUseDmd();
        createLongitudeUseDd();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createLatitudePane();
        createLatitudeDmsEditor();
        createLatitudeDmdEditor();
        createLatitudeDdEditor();
        createLongitudePane();
        createLongitudeDmsEditor();
        createLongitudeDmdEditor();
        createLongitudeDdEditor();
        createResult();
        createResultLatitude();
        createResultLongitude();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}