package jaxx.demo.component.jaxx.widgets.select;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.select.FilterableDoubleList;
import static org.nuiton.i18n.I18n.t;

public class FilterableDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_LIST_ENABLED = "doubleList.enabled";
    public static final String BINDING_DOUBLE_LIST_FILTERABLE = "doubleList.filterable";
    public static final String BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT = "doubleList.highlightFilterText";
    public static final String BINDING_DOUBLE_LIST_SELECTED = "doubleList.selected";
    public static final String BINDING_DOUBLE_LIST_SHOW_DECORATOR = "doubleList.showDecorator";
    public static final String BINDING_DOUBLE_LIST_SHOW_RESET = "doubleList.showReset";
    public static final String BINDING_RESULT_TEXT = "result.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWQW8bRRR+ceMktltSEqW0aoE0tMgR0hpUISEFQUhCBJVbqiSHCl+69k68U8Y7y8xbvJFVxBVO/AS4c0Hixglx4MyBC+IvIMSBK+LNrrPrdcZ2UCJlEr1575vvfW/em/3uTyhrBbefunHsqChA3mPO/fceP/6o/ZR1cI/pjuIhSgXpz1wJSi2oeZldI7zSaprwxjC8sSt7oQxYMBK91YSqxhPBtM8YIrxYjOho3TjMtrfiMFKnqBkpG+o3f/9V+tr74tsSQBwSuxqlsj4rKs9kvgkl7iGs0EmfuQ3hBl2ioXjQJb5XjG1XuFo/dHvsU/gcFpuwELqKwBA2zp9ygpHExyFC7c4e68lHbsDE6wjbCVmPLE7nFMJJbH3udRlqRzNBdXD2uUCm3LZgezKitck1GqAwTKAXEMo96TGB8P5FIR8YnBx38c6R8SGy1wvK6j7p5CR7xrOSBax0ZHDMu5FykcsgyZSMRs14GHQ/MRr35Szq6nFGZydClAHCWiFm12edT3ZkbPxXsrAbPu/6gn4xTeeIxZjGG4cXis7L2pf9A6bZZJdV47LHOpLYSzXR7TILcqaW/aqXSYpwT6quE0ScXM9diKI4C4rpSOC4JCZZI+XQWcHNQoWoq5y8q/JrP9eCsorITCVtnW3EA9pKW/D6WAsawGT332urv/34xw/7o323ZnUdGRvUD6GSIVPIzdHLadNFyEXjgRtutaCS6pHMlFsWYofDbSJH5z1vwh0T7nzgap8gyou///TztSe/XoLSPlSFdL191/h/CBX0SUFfCi8O391OGF3uL9F61XAjfdtSeUQMdgYB668fcRTM20lsdaxvGCZJQ7WZG6SVFVSjYY+NXPaNzc1nMQl3yyJcxr5d+eWf1cPvt0/Fm6Nkbkx0zwUsfwwLPBA8YMnYGk4k65iqhZpFnswnj20WgbVVw2Hnv5asjTNqlRCW0joxmpzzqCJm/tBNRHh1mlB5f8eRgb6XpG7+exMs7f//eJSPXaFzIo1pRCwTw8Zo8mS5iER3pzHLxpONz/jwugiLzVkssgloY2KbkRdhM7W/0kFro1GYwbPOrxBtS0ER6oOJdXa4PhxSrm8+o5cwPZD43xyMnj3uN5Lo2iB5lR0a9wWXKwUJSYKBRdNx3HkjD9FIMclQzZsG4eXBeAuNx1f5G28FjxQ75jE1XCY6fSX0yJl4D8fzSSGFSnbvEF4ajF3C4hG2Ko28hLNqdCnv34FPF0Ew5USh5yI7SJ4/U5m6RU+TW40mGdKXztFJSFpUDEzDxx59eSwxj2MqUTolbCyHD+wshuapEO6JpNzhubeJmbve5oFHj/E7Z1DnzFqdiWjMX5rlKzvC6jk4LZmLYTKfgnObcP4DQGHCY+0LAAA=";
    private static final Log log = LogFactory.getLog(FilterableDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected FilterableDoubleList<People> doubleList;
    protected JCheckBox enableButton;
    protected JCheckBox filterableButton;
    protected final FilterableDoubleListDemoHandler handler = createHandler();
    protected JCheckBox highlightFilterTextButton;
    protected FilterableDoubleListDemoModel model;
    protected JTextPane result;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FilterableDoubleListDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FilterableDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FilterableDoubleListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterableDoubleListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterableDoubleListDemo() {
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public FilterableDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public FilterableDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public FilterableDoubleListDemoModel getModel() {
        return model;
    }

    public JTextPane getResult() {
        return result;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(enableButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new FilterableDoubleList<People>());
        
        doubleList.setName("doubleList");
        doubleList.setI18nPrefix("jaxxdemo.common.");
        doubleList.setProperty("selected");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
        enableButton.setText(t("jaxxdemo.beandoublelistdemo.enable"));
        enableButton.setSelected(true);
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(t("jaxxdemo.beandoublelistdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected FilterableDoubleListDemoHandler createHandler() {
        return new FilterableDoubleListDemoHandler();
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
        highlightFilterTextButton.setText(t("jaxxdemo.beandoublelistdemo.highlightFilterText"));
        highlightFilterTextButton.setSelected(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FilterableDoubleListDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JTextPane());
        
        result.setName("result");
        result.setContentType("text/html");
        result.setEditable(false);
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beandoublelistdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beandoublelistdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        doubleList.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beandoublelistdemo.configuration")));
        doubleList.setBean(model);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createEnableButton();
        createDoubleList();
        createResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (highlightFilterTextButton != null) {
                    $bindingSources.put("highlightFilterTextButton.getModel()", highlightFilterTextButton.getModel());
                    highlightFilterTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    highlightFilterTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (highlightFilterTextButton != null) {
                    doubleList.setHighlightFilterText(highlightFilterTextButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (highlightFilterTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("highlightFilterTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    highlightFilterTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enableButton != null) {
                    $bindingSources.put("enableButton.getModel()", enableButton.getModel());
                    enableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    enableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enableButton != null) {
                    doubleList.setEnabled(enableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    enableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_ENABLED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    doubleList.setSelected(model.getSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    doubleList.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    doubleList.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleList.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(result, handler.updateResultText(model.getSelected()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selected", this);
                }
            }
        });
    }

}