package jaxx.demo.component.jaxx.widgets.gis;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import static org.nuiton.i18n.I18n.t;

public class CoordinatesEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL = "editor.displayZeroWhenNull";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_LATITUDE = "editor.latitude";
    public static final String BINDING_EDITOR_LONGITUDE = "editor.longitude";
    public static final String BINDING_EDITOR_QUADRANT = "editor.quadrant";
    public static final String BINDING_EDITOR_SHOW_RESET_BUTTON = "editor.showResetButton";
    public static final String BINDING_RESULT_LATITUDE_TEXT = "resultLatitude.text";
    public static final String BINDING_RESULT_LONGITUDE_TEXT = "resultLongitude.text";
    public static final String BINDING_RESULT_QUADRANT_TEXT = "resultQuadrant.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW8bRRieuLHTfNC0DQmFFhHSSiRVWYMQIBFE26REtHILNJWo6gtjz9SeMp7ZzszijawgfgBI/AS4c0Hixglx4MyBC+IvIMSBK+Kd2fV41x6I1eSwWb+fz/v17Ld/oKpW6MVHOE0jlQjDejS6df3+/fdbj2jb3KC6rVhspELZ30wFVZpokXi5Nuhis2Hd67l7fVf2YimoKHhvN9CCNgec6i6lxqDnyx5trev7Xr2dxokaRvWgQlG//uvPylfk828qCKUxoFuCUtaP8hpVMttAFUYMOguZPsV1jkUHYCgmOoD3KSvb5VjrO7hHH6PP0FwD1WKsIJhBG9OX7GI4/zQ2aPHSDdqTH2BB+SsGveXAEpBE7WGIyMn6jHSo0VGHaShCKsIENlS/SxjEtiHi2AWtGVTtSUK5QVefPNhtG2EUce7SPdziFACeK3VT96E3kdNZy3nvUGtL8ZB1oJW2a2lueMuVaU2WveW87sr+XartFqyWjHe7tP3Jjkyt4Vlvv0SFTbeTGCOFlT1T1q8QpmOODx5QJT/qUnEn4TxgVqOuVoPekKoTiQR+iMne4JaWPDF0sknlImqK6oQb++vpsuZUpvkwwURhuyjlhjRwK2vIC+MeDWyYSYjr68WyxXJuIUVnwkSh86UJwSVFo0sarfpME1VVAmIYaXPy+O6CKju7c2NnZwM67T9rK7/+8Pv3e8VbWw2aFqgCbiBWMqbKMJt6OTu0xDBev43j7SasA+XAM45HLgSA7edqAAf5zlj3yLpH72HdhRDVud9+/Gnt419OoMoeWuASkz1s7W+iedOFvnUlJ2l89ZpDtNQ/Cc/TFhvMsAUjBmDo+kDQ/vo9ZjglO062aTY3LJL8lMZWIcp2PVEwMSk2trYOU+jbhUDfPPjW/M9/r+x/d23Yuxmo5dn/NB/1r/oA1ZjgTFDHVDkJBZlpMdY0IXJENiH6Qf5S4/zYX3bPVycaVDHoZDYaCgQ5a1RC7T+aWvIO9CbyZ50mNuLrrkr79iYqHv1x8j4XypvRQyhpiTmOk/elUN4A7YRAhOjpKCwLQMAZdoByflAsI2J6P0e5uXVo0Jn8ug48OUCz+ej9tNfn9AJlcv8626LAUWhu4D4gh2G08K0bBMTjSIpZ17KAEfCqx+WMCrlXCza5MDN57KmzYDLkU2fiixqxbMFr2e9a1jIgvIEXlVGHBpZ/KI6aUZFAXpuWQKKMyDPKCKTO1FOkzhfz8qCLBeFUlVoUaFo439i36gnz+ukF5vm/eYdm0+e9UsrrNyu0bOHM41/SaaYMey9hkdCptwk2eL3FBAyz885E+Bn7XDgyohV/YR9fhiOsHDvCOkT4FwMIzobXCwAA";
    private static final Log log = LogFactory.getLog(CoordinatesEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected JCheckBox displayZeroWhenNull;
    protected CoordinatesEditor editor;
    protected JCheckBox enableButton;
    protected final CoordinatesEditorDemoHandler handler = createHandler();
    protected CoordinatesEditorDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;
    protected JLabel resultQuadrant;
    protected JCheckBox showReset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinatesEditorDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CoordinatesEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo() {
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public JCheckBox getDisplayZeroWhenNull() {
        return displayZeroWhenNull;
    }

    public CoordinatesEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public CoordinatesEditorDemoHandler getHandler() {
        return handler;
    }

    public CoordinatesEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    public JLabel getResultQuadrant() {
        return resultQuadrant;
    }

    public JCheckBox getShowReset() {
        return showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        if (!allComponentsCreated) {
            return;
        }
        config.add(showReset);
        config.add(enableButton);
        config.add(displayZeroWhenNull);
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultQuadrant);
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(0,1));
    }

    protected void createDisplayZeroWhenNull() {
        $objectMap.put("displayZeroWhenNull", displayZeroWhenNull = new JCheckBox());
        
        displayZeroWhenNull.setName("displayZeroWhenNull");
        displayZeroWhenNull.setText(t("jaxxdemo.coordinate.displayZeroWhenNull"));
        displayZeroWhenNull.setSelected(true);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new CoordinatesEditor());
        
        editor.setName("editor");
        editor.setPropertyLatitude("latitude");
        editor.setPropertyLongitude("longitude");
        editor.setPropertyQuadrant("quadrant");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
        enableButton.setText(t("jaxxdemo.coordinate.enable"));
        enableButton.setSelected(true);
    }

    protected CoordinatesEditorDemoHandler createHandler() {
        return new CoordinatesEditorDemoHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    protected void createResultQuadrant() {
        $objectMap.put("resultQuadrant", resultQuadrant = new JLabel());
        
        resultQuadrant.setName("resultQuadrant");
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = new JCheckBox());
        
        showReset.setName("showReset");
        showReset.setText(t("jaxxdemo.coordinate.showReset"));
        showReset.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToResult();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        config.setBorder(new TitledBorder(t("jaxxdemo.coordinatesEditor.configuration")));
        editor.setBean(model);
        result.setBorder(new TitledBorder(t("jaxxdemo.coordinate.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createShowReset();
        createEnableButton();
        createDisplayZeroWhenNull();
        createEditor();
        createResult();
        createResultQuadrant();
        createResultLatitude();
        createResultLongitude();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enableButton != null) {
                    $bindingSources.put("enableButton.getModel()", enableButton.getModel());
                    enableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    enableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enableButton != null) {
                    editor.setEnabled(enableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    enableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (displayZeroWhenNull != null) {
                    $bindingSources.put("displayZeroWhenNull.getModel()", displayZeroWhenNull.getModel());
                    displayZeroWhenNull.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    displayZeroWhenNull.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (displayZeroWhenNull != null) {
                    editor.setDisplayZeroWhenNull(displayZeroWhenNull.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (displayZeroWhenNull != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("displayZeroWhenNull.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    displayZeroWhenNull.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LONGITUDE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setLongitude(model.getLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LATITUDE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setLatitude(model.getLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_RESET_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showReset != null) {
                    $bindingSources.put("showReset.getModel()", showReset.getModel());
                    showReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_SHOW_RESET_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showReset != null) {
                    editor.setShowResetButton(showReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_SHOW_RESET_BUTTON));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_QUADRANT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setQuadrant(model.getQuadrant());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_QUADRANT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultQuadrant.setText(t(handler.getQuadrant(model.getQuadrant())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LATITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLatitude.setText(t(handler.getLatitude(model.getLatitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LONGITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLongitude.setText(t(handler.getLongitude(model.getLongitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
    }

}