/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JCheckBoxDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTy27TQBS9CXk0fVDa0NKqRWohCBCSw4INatUHrSqowkMUoYpsGNtDM8UZD+Nxa1ggPoFPgD0bJHasEAvWLNggfgEhFmwRdyaJkxS3jRQvxva955459/XuJ2QDCfO7JIosGXLF6tTaXN3evmvvUket08CRTChfQuNJpSFdhSE3tgcKzlcrOrzcDC+v+XXhc8o7ohcqMBio5x4NapQqBWe7I5wgKG/F7oVIhLLFGotKYn3z+1f6tfvqbRogEqguj6nMHRfVziRTgTRzFYzjTXuk7BG+gzIk4zuod0Tb1jwSBHdInT6Dl5CvQE4QiWQKzvWesuEw8ZFQMFRap3X/HuHUu6rgohHrosVyWhRWsI8KrM21GnWe3vAjjRfCMOQU5EoP0YahZ7rybMRol8YVYni+9IDYHkX8VALe+DRyOA7I2L6HJZnQ2UcHpWjMaAwdKG1WiG3yGO+CG2s3NscU8Zij/053ewohd6n0GKedTgkzXXpxQqz2hLRbmKpCVoZoxgSr/w/VfXQ1xmnqwDhpQuP9O1n89vHHh43WDA3i3ROJ0I4VwN4K6QsqFdNXjzYGKFTMK98mYqEKhYB6uD9mP2YThG013SgO7xvT4ZYOt26SoIYU2fz3T58nH389AekNGPR84m4Qjb8FBVWTWAXsUiSWV4yi4f0BPE9pbQqKNV+yFz7Heq96bIfXzbyOLzKuazxHFA64HSq6FGFVZhOqEkuzC1/+FLfer7Qqk0Kl04fC29XJPsJ2m9vMfjVXJ3GfhkRAQ9dvr0jS0qT0e0Q0d2DenBeSUh/b0w1xOhLX0EtRqF+XTQb660rPhBlFo6M4ij1wDNQ5LjBvzH4fPJknvm7kyUWXKDJnM+7iri0l800ey6fN1/Sx3DfDITlN98RwvW+GozTM9K1BM/wDcEokViQHAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JCheckBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JCheckBox bold;
    protected javax.swing.JCheckBox italic;
    protected javax.swing.JCheckBox underline;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JCheckBoxDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.VBox $VBox0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getText(boolean bold, boolean italic, boolean underline) {
            String text ="Sample Text";
            if (bold)
                text = "<b>" + text + "</b>";
            if (italic)
                text = "<i>" + text + "</i>";
            if (underline)
                text = "<u>" + text + "</u>";
            return "<html>" + text;
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBoxDemo() {
        super();
        $initialize();
    }

    public JCheckBoxDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JCheckBox getBold() {
        return bold;
    }

    public javax.swing.JCheckBox getItalic() {
        return italic;
    }

    public javax.swing.JCheckBox getUnderline() {
        return underline;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBold() {
        $objectMap.put("bold", bold = new javax.swing.JCheckBox());
        
        bold.setName("bold");
        bold.setText(_("Bold"));
        bold.setMnemonic(66);
    }

    protected void createItalic() {
        $objectMap.put("italic", italic = new javax.swing.JCheckBox());
        
        italic.setName("italic");
        italic.setText(_("Italic"));
        italic.setMnemonic(73);
    }

    protected void createUnderline() {
        $objectMap.put("underline", underline = new javax.swing.JCheckBox());
        
        underline.setName("underline");
        underline.setText(_("Underline"));
        underline.setMnemonic(85);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($Table0);
        // inline complete setup of $Table0
        $Table0.add(bold, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(italic, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(underline, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JLabel0.setFont(new Font("Arial", 0, 18));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createBold();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        createItalic();
        createUnderline();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bold != null) {
                    $bindingSources.put("bold.getModel()", bold.getModel());
                    bold.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    bold.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (italic != null) {
                    $bindingSources.put("italic.getModel()", italic.getModel());
                    italic.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    italic.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (underline != null) {
                    $bindingSources.put("underline.getModel()", underline.getModel());
                    underline.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    underline.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bold != null && italic != null && underline != null) {
                    $JLabel0.setText(_(getText(bold.isSelected(), italic.isSelected(), underline.isSelected())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bold != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("bold.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    bold.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (italic != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("italic.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    italic.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (underline != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("underline.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    underline.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            public void $pr$u0(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
    }

}