/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JButtonDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uu24TQRS93sQxToA8TEIQiZRAKBBiTTqkBMhLgUTmoURCEW4Y747tidYzw8xsskmB+AQ+AXoaJDoqREFNQYP4BYQoaBF31utHYuchLHm1uo9zzpx7Z9/9hLRWML1NoshVITesRt31xa2tx6Vt6pkVqj3FpBEK6r+UA04RBvxmXBu4WizY9nzSnl8WNSk45W3dcwXo12YvoLpKqTEwebDD0zq/2UzPRTJUDdSmqG6ob37/cl77r946AJFEdfYoUyd1tU7SWwCH+QZGkGmH5APCKyhDMV5BvedsbDkgWj8iNfoCXkKmAH2SKAQzcOX0R44x4v5IGhiYWaE18YRwGtwycC0W62PE9RoQrt5FBe76UmiM4LZayri/zyA/5R4LDIxadVFSulYjFbrmCd5WOPN0SUTIcPGAHfV6m7J12WZ5diahw45cO3QStmWDndWzNnAhThpIlwn39nAClw9Q4mzd1mxb5qeKkFYhhg2MFzvXYQNT9UUYP7QIFjDO/h3Lffv448NqY/oZ5B7tWtq2vDgVqYSkyjBLPVgffWhYkH9I5FwRspoGuPnxZk90EbaZpFEc8g3bdte2uw+IriJEOvP90+ex5197wFmF/kAQf5XY+jXImqpCF0TgR/LeQqzo7O4ZfA7hvwdtLQtubmq2jzY5s7cbgTLxMJBeVIzg4PvLQtGKEiHHxe0tBSGN0KOJLh41hZayX/7kNt8vNHxKoe5LR5a3vEo/gz7GA8ZpfE+SK9D1XgxITUNftFa92/IDrn8m2RzZ3BebnIyf0x2mOPF5rSkWC7eaGRIw75ALPYr6UWgRrsens2832snQyZoINRU7OPbT8KbwFlSFYvvYS4LFgFV4Lb72I/N1Q6aIwe9EKTT0bgdzyj6HZHIXj6EYtnKY10ZgS+/8P2CvodFxGLnTYDDPGnZ+3ieGTJUY9/EzcMQhx07Es+H7xyiyCP8AJ+D8LoMGAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.ImageIcon pencil;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButtonDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.VBox $VBox0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void buttonClicked(JButton button) {
        JOptionPane.showMessageDialog(this, button.getText() + " clicked!",
        "onActionPerformed",
        JOptionPane.INFORMATION_MESSAGE);
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JButtonDemo() {
        super();
        $initialize();
    }

    public JButtonDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        buttonClicked((JButton) event.getSource());
    }

    public void doMouseEntered__on__$JButton1(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.component.swing.JButtonDemo.this, $JButton1, "font-style", "italic", jaxx.runtime.css.Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((java.lang.String) value).equals("italic")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.ITALIC));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
        value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.component.swing.JButtonDemo.this, $JButton1, "foreground", new Color(255, 0, 0), jaxx.runtime.css.Pseudoclasses.wrap($JButton1.getForeground()), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            $JButton1.setForeground((java.awt.Color) value);
        }
    }

    public void doMouseExited__on__$JButton1(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.component.swing.JButtonDemo.this, $JButton1, "font-style", "italic", jaxx.runtime.css.Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((java.lang.String) value).equals("italic")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.ITALIC));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
        value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.component.swing.JButtonDemo.this, $JButton1, "foreground", new Color(255, 0, 0), jaxx.runtime.css.Pseudoclasses.wrap($JButton1.getForeground()), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            $JButton1.setForeground((java.awt.Color) value);
        }
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        buttonClicked((JButton) event.getSource());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.ImageIcon getPencil() {
        return pencil;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void create$JButton1() {
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("Fancy Button"));
        if ($JButton1.getFont() != null) {
            $JButton1.setFont($JButton1.getFont().deriveFont((float) 18));
        }
        if ($JButton1.getFont() != null) {
            $JButton1.setFont(new Font("Arial", $JButton1.getFont().getStyle(), $JButton1.getFont().getSize()));
        }
        $JButton1.setForeground(new Color(0, 0, 255));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton1"));
    }

    protected void createPencil() {
        $objectMap.put("pencil", pencil = new javax.swing.ImageIcon(getClass().getResource("/jaxx/demo/images/pencil_black.gif")));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JButton0);
        $VBox0.add($JButton1);
        
        // apply 1 property setters
        $JButton1.setIcon(pencil);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        createPencil();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("Simple Button"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        create$JButton1();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $completeSetup();
    }

}