/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.feature.validation;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.entities.*;
import jaxx.demo.feature.validation.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ValidationTableDemo extends jaxx.demo.DemoPanel implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AGE_VALUE = "age.value";
    public static final String BINDING_CONFIG_TEXT = "config.text";
    public static final String BINDING_DIR_TEXT = "dir.text";
    public static final String BINDING_EMAIL2_TEXT = "email2.text";
    public static final String BINDING_FIRST_NAME_TEXT = "firstName.text";
    public static final String BINDING_LAST_NAME_TEXT = "lastName.text";
    public static final String BINDING_RATIO_VALUE = "ratio.value";
    public static final String BINDING_TEXT2_TEXT = "text2.text";
    public static final String BINDING_TEXT_TEXT = "text.text";
    public static final String BINDING__RATIO_VALUE = "_ratio.value";
    public static final String BINDING__TEXT2_TEXT = "_text2.text";
    public static final String BINDING__TEXT_TEXT = "_text.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL13_TEXT = "$JLabel13.text";
    private static final String BINDING_$JLABEL15_TEXT = "$JLabel15.text";
    private static final String BINDING_$JLABEL17_TEXT = "$JLabel17.text";
    private static final String BINDING_$JLABEL25_TEXT = "$JLabel25.text";
    private static final String BINDING_$JLABEL27_TEXT = "$JLabel27.text";
    private static final String BINDING_$JLABEL29_TEXT = "$JLabel29.text";
    private static final String BINDING_$JLABEL31_TEXT = "$JLabel31.text";
    private static final String BINDING_$JLABEL33_TEXT = "$JLabel33.text";
    private static final String BINDING_$JLABEL35_TEXT = "$JLabel35.text";
    private static final String BINDING_$JLABEL4_TEXT = "$JLabel4.text";
    private static final String BINDING_$JLABEL6_TEXT = "$JLabel6.text";
    private static final String BINDING_$JLABEL8_TEXT = "$JLabel8.text";
    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(jaxx.demo.feature.validation.ValidationTableDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSlider _ratio;
    protected javax.swing.JTextField _text;
    protected javax.swing.JTextField _text2;
    protected javax.swing.JSlider age;
    protected javax.swing.JButton cancel;
    protected javax.swing.JTextField config;
    protected javax.swing.JTextField dir;
    protected javax.swing.JTextField email2;
    protected javax.swing.JTable errorTable;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errors2;
    protected javax.swing.JTextField firstName;
    protected jaxx.demo.entities.Identity identity;
    protected javax.swing.JTextField lastName;
    protected jaxx.demo.entities.Model model1;
    protected jaxx.demo.entities.Model model2;
    protected javax.swing.JButton ok;
    protected javax.swing.JSlider ratio;
    protected javax.swing.JTextField text;
    protected javax.swing.JTextField text2;
    protected jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Model > validator;
    protected jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Model > validator2;
    protected jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Identity > validator3;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ValidationTableDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JPanel $JPanel2;
    private jaxx.runtime.swing.Table $Table3;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JLabel $JLabel10;
    private javax.swing.JLabel $JLabel11;
    private javax.swing.JPanel $JPanel3;
    private jaxx.runtime.swing.Table $Table4;
    private javax.swing.JLabel $JLabel12;
    private javax.swing.JLabel $JLabel13;
    private javax.swing.JLabel $JLabel14;
    private javax.swing.JLabel $JLabel15;
    private javax.swing.JLabel $JLabel16;
    private javax.swing.JLabel $JLabel17;
    private javax.swing.JPanel $JPanel4;
    private jaxx.runtime.swing.Table $Table5;
    private javax.swing.JLabel $JLabel18;
    private javax.swing.JLabel $JLabel19;
    private javax.swing.JLabel $JLabel20;
    private javax.swing.JLabel $JLabel21;
    private javax.swing.JLabel $JLabel22;
    private javax.swing.JLabel $JLabel23;
    private javax.swing.JPanel $JPanel5;
    private jaxx.runtime.swing.Table $Table6;
    private javax.swing.JLabel $JLabel24;
    private javax.swing.JLabel $JLabel25;
    private javax.swing.JLabel $JLabel26;
    private javax.swing.JLabel $JLabel27;
    private javax.swing.JLabel $JLabel28;
    private javax.swing.JLabel $JLabel29;
    private javax.swing.JLabel $JLabel30;
    private javax.swing.JLabel $JLabel31;
    private javax.swing.JLabel $JLabel32;
    private javax.swing.JLabel $JLabel33;
    private javax.swing.JLabel $JLabel34;
    private javax.swing.JLabel $JLabel35;
    private javax.swing.JPanel $JPanel6;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel7;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        SwingValidatorUtil.installUI(errorTable, new SwingValidatorMessageTableRenderer());
    }
    
    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(), "Validation.css",
            "Identity.java", "Identity-error-validation.xml", "Identity-info-validation.xml", "Identity-warning-validation.xml",
            "Model.java", "Model-error-validation.xml", "Model-info-validation.xml", "Model-warning-validation.xml"
        };
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ValidationTableDemo() {
        super();
        $initialize();
    }

    public ValidationTableDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Model > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        JOptionPane.showMessageDialog(this, cancel.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doActionPerformed__on__ok(java.awt.event.ActionEvent event) {
        JOptionPane.showMessageDialog(this, ok.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doKeyReleased__on___text(java.awt.event.KeyEvent event) {
        model2.setText(_text.getText());
    }

    public void doKeyReleased__on___text2(java.awt.event.KeyEvent event) {
        model2.setText2(_text2.getText());
    }

    public void doKeyReleased__on__config(java.awt.event.KeyEvent event) {
        identity.setConfig(new java.io.File(config.getText()));
    }

    public void doKeyReleased__on__dir(java.awt.event.KeyEvent event) {
        identity.setDir(new java.io.File(dir.getText()));
    }

    public void doKeyReleased__on__email2(java.awt.event.KeyEvent event) {
        identity.setEmail(email2.getText());
    }

    public void doKeyReleased__on__firstName(java.awt.event.KeyEvent event) {
        identity.setFirstName(firstName.getText());
    }

    public void doKeyReleased__on__lastName(java.awt.event.KeyEvent event) {
        identity.setLastName(lastName.getText());
    }

    public void doKeyReleased__on__text(java.awt.event.KeyEvent event) {
        model1.setText(text.getText());
    }

    public void doKeyReleased__on__text2(java.awt.event.KeyEvent event) {
        model1.setText2(text2.getText());
    }

    public void doStateChanged__on___ratio(javax.swing.event.ChangeEvent event) {
        model2.setRatio(_ratio.getValue());
    }

    public void doStateChanged__on__age(javax.swing.event.ChangeEvent event) {
        identity.setAge(age.getValue());
    }

    public void doStateChanged__on__ratio(javax.swing.event.ChangeEvent event) {
        model1.setRatio(ratio.getValue());
    }

    public void doTableChanged__on__errors2(javax.swing.event.TableModelEvent event) {
        ok.setEnabled(errors2.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JSlider getAge() {
        return age;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JTextField getConfig() {
        return config;
    }

    public javax.swing.JTextField getDir() {
        return dir;
    }

    public javax.swing.JTextField getEmail2() {
        return email2;
    }

    public javax.swing.JTable getErrorTable() {
        return errorTable;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrors2() {
        return errors2;
    }

    public javax.swing.JTextField getFirstName() {
        return firstName;
    }

    public jaxx.demo.entities.Identity getIdentity() {
        return identity;
    }

    public javax.swing.JTextField getLastName() {
        return lastName;
    }

    public jaxx.demo.entities.Model getModel1() {
        return model1;
    }

    public jaxx.demo.entities.Model getModel2() {
        return model2;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public javax.swing.JSlider getRatio() {
        return ratio;
    }

    public javax.swing.JTextField getText() {
        return text;
    }

    public jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Identity > getValidator3() {
        return validator3;
    }

    public javax.swing.JTextField getText2() {
        return text2;
    }

    public jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Model > getValidator2() {
        return validator2;
    }

    public javax.swing.JSlider get_ratio() {
        return _ratio;
    }

    public javax.swing.JTextField get_text() {
        return _text;
    }

    public javax.swing.JTextField get_text2() {
        return _text2;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("ratio", ratio);
        validator.setFieldRepresentation("text", text);
        validator.setFieldRepresentation("text2", text2);
        validator2.setFieldRepresentation("ratio", _ratio);
        validator2.setFieldRepresentation("text", _text);
        validator2.setFieldRepresentation("text2", _text2);
        validator3.setFieldRepresentation("age", age);
        validator3.setFieldRepresentation("config", config);
        validator3.setFieldRepresentation("dir", dir);
        validator3.setFieldRepresentation("email", email2);
        validator3.setFieldRepresentation("firstName", firstName);
        validator3.setFieldRepresentation("lastName", lastName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected javax.swing.JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected javax.swing.JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected javax.swing.JLabel get$JLabel12() {
        return $JLabel12;
    }

    protected javax.swing.JLabel get$JLabel13() {
        return $JLabel13;
    }

    protected javax.swing.JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected javax.swing.JLabel get$JLabel15() {
        return $JLabel15;
    }

    protected javax.swing.JLabel get$JLabel16() {
        return $JLabel16;
    }

    protected javax.swing.JLabel get$JLabel17() {
        return $JLabel17;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected jaxx.runtime.swing.Table get$Table5() {
        return $Table5;
    }

    protected javax.swing.JLabel get$JLabel18() {
        return $JLabel18;
    }

    protected javax.swing.JLabel get$JLabel19() {
        return $JLabel19;
    }

    protected javax.swing.JLabel get$JLabel20() {
        return $JLabel20;
    }

    protected javax.swing.JLabel get$JLabel21() {
        return $JLabel21;
    }

    protected javax.swing.JLabel get$JLabel22() {
        return $JLabel22;
    }

    protected javax.swing.JLabel get$JLabel23() {
        return $JLabel23;
    }

    protected javax.swing.JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected jaxx.runtime.swing.Table get$Table6() {
        return $Table6;
    }

    protected javax.swing.JLabel get$JLabel24() {
        return $JLabel24;
    }

    protected javax.swing.JLabel get$JLabel25() {
        return $JLabel25;
    }

    protected javax.swing.JLabel get$JLabel26() {
        return $JLabel26;
    }

    protected javax.swing.JLabel get$JLabel27() {
        return $JLabel27;
    }

    protected javax.swing.JLabel get$JLabel28() {
        return $JLabel28;
    }

    protected javax.swing.JLabel get$JLabel29() {
        return $JLabel29;
    }

    protected javax.swing.JLabel get$JLabel30() {
        return $JLabel30;
    }

    protected javax.swing.JLabel get$JLabel31() {
        return $JLabel31;
    }

    protected javax.swing.JLabel get$JLabel32() {
        return $JLabel32;
    }

    protected javax.swing.JLabel get$JLabel33() {
        return $JLabel33;
    }

    protected javax.swing.JLabel get$JLabel34() {
        return $JLabel34;
    }

    protected javax.swing.JLabel get$JLabel35() {
        return $JLabel35;
    }

    protected javax.swing.JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel7() {
        return $JPanel7;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errors2);
        jaxx.runtime.validator.swing.SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model1);
    }

    protected void addChildrenToValidator2() {
        if (!allComponentsCreated) {
            return;
        }
        validator2.setErrorTableModel(errors2);
        jaxx.runtime.validator.swing.SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator2.setUiClass(jaxx.runtime.validator.swing.ui.IconValidationUI.class);
        validator2.setBean(model2);
    }

    protected void addChildrenToValidator3() {
        if (!allComponentsCreated) {
            return;
        }
        validator3.setErrorTableModel(errors2);
        jaxx.runtime.validator.swing.SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator3.setUiClass(jaxx.runtime.validator.swing.ui.TranslucentValidationUI.class);
        validator3.setBean(identity);
    }

    protected void createAge() {
        $objectMap.put("age", age = new javax.swing.JSlider());
        
        age.setName("age");
        age.setValue(0);
        age.setMaximum(100);
        age.setMinimum(0);
        age.setMajorTickSpacing(10);
        age.setPaintTicks(true);
        age.setMinorTickSpacing(5);
        age.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__age"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createConfig() {
        $objectMap.put("config", config = new javax.swing.JTextField());
        
        config.setName("config");
        config.setColumns(15);
        config.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__config"));
    }

    protected void createDir() {
        $objectMap.put("dir", dir = new javax.swing.JTextField());
        
        dir.setName("dir");
        dir.setColumns(15);
        dir.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__dir"));
    }

    protected void createEmail2() {
        $objectMap.put("email2", email2 = new javax.swing.JTextField());
        
        email2.setName("email2");
        email2.setColumns(15);
        email2.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__email2"));
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new javax.swing.JTable());
        
        errorTable.setName("errorTable");
        errorTable.setAutoCreateRowSorter(true);
        errorTable.setAutoResizeMode(2);
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setSelectionMode(0);
    }

    protected void createErrors2() {
        $objectMap.put("errors2", errors2 = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        
        errors2.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errors2"));
    }

    protected void createFirstName() {
        $objectMap.put("firstName", firstName = new javax.swing.JTextField());
        
        firstName.setName("firstName");
        firstName.setColumns(15);
        firstName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__firstName"));
    }

    protected void createIdentity() {
        $objectMap.put("identity", identity = new jaxx.demo.entities.Identity());
    }

    protected void createLastName() {
        $objectMap.put("lastName", lastName = new javax.swing.JTextField());
        
        lastName.setName("lastName");
        lastName.setColumns(15);
        lastName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__lastName"));
    }

    protected void createModel1() {
        $objectMap.put("model1", model1 = new jaxx.demo.entities.Model());
    }

    protected void createModel2() {
        $objectMap.put("model2", model2 = new jaxx.demo.entities.Model());
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new javax.swing.JButton());
        
        ok.setName("ok");
        ok.setText(_("valid"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRatio() {
        $objectMap.put("ratio", ratio = new javax.swing.JSlider());
        
        ratio.setName("ratio");
        ratio.setValue(0);
        ratio.setMaximum(100);
        ratio.setMinimum(0);
        ratio.setMajorTickSpacing(10);
        ratio.setPaintTicks(true);
        ratio.setMinorTickSpacing(5);
        ratio.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__ratio"));
        ratio.putClientProperty("validatorLabel", n_("form.ratio"));
    }

    protected void createText() {
        $objectMap.put("text", text = new javax.swing.JTextField());
        
        text.setName("text");
        text.setColumns(15);
        text.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__text"));
        text.putClientProperty("validatorLabel", n_("form.text"));
    }

    protected void createValidator2() {
        $objectMap.put("validator2", validator2 = new jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Model >(jaxx.demo.entities.Model.class, null));
    }

    protected void createText2() {
        $objectMap.put("text2", text2 = new javax.swing.JTextField());
        
        text2.setName("text2");
        text2.setColumns(15);
        text2.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__text2"));
        text2.putClientProperty("validatorLabel", n_("form.text2"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Model >(jaxx.demo.entities.Model.class, null));
    }

    protected void createValidator3() {
        $objectMap.put("validator3", validator3 = new jaxx.runtime.validator.swing.SwingValidator< jaxx.demo.entities.Identity >(jaxx.demo.entities.Identity.class, null));
    }

    protected void create_ratio() {
        $objectMap.put("_ratio", _ratio = new javax.swing.JSlider());
        
        _ratio.setName("_ratio");
        _ratio.setValue(0);
        _ratio.setMaximum(100);
        _ratio.setMinimum(0);
        _ratio.setMajorTickSpacing(10);
        _ratio.setPaintTicks(true);
        _ratio.setMinorTickSpacing(5);
        _ratio.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on___ratio"));
        _ratio.putClientProperty("validatorLabel", n_("form2.ratio"));
    }

    protected void create_text() {
        $objectMap.put("_text", _text = new javax.swing.JTextField());
        
        _text.setName("_text");
        _text.setColumns(15);
        _text.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on___text"));
        _text.putClientProperty("validatorLabel", n_("form2.text"));
    }

    protected void create_text2() {
        $objectMap.put("_text2", _text2 = new javax.swing.JTextField());
        
        _text2.setName("_text2");
        _text2.setColumns(15);
        _text2.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on___text2"));
        _text2.putClientProperty("validatorLabel", n_("form2.text2"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($Table0);
        addChildrenToValidator();
        addChildrenToValidator2();
        addChildrenToValidator3();
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel4, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel5, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel6, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel7, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($Table1);
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(text), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(text2), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(ratio), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add($Table2);
        // inline complete setup of $Table2
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel6, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel7, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel8, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel2
        $JPanel2.add($Table3);
        // inline complete setup of $Table3
        $Table3.add($JLabel9, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(_text), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel10, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(_text2), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel11, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(_ratio), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel3
        $JPanel3.add($Table4);
        // inline complete setup of $Table4
        $Table4.add($JLabel12, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel13, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel14, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel15, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel16, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel17, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel4
        $JPanel4.add($Table5);
        // inline complete setup of $Table5
        $Table5.add($JLabel18, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(firstName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(lastName), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel20, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(email2), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel21, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(age), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel22, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(config), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel23, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(dir), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel5
        $JPanel5.add($Table6);
        // inline complete setup of $Table6
        $Table6.add($JLabel24, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel25, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel26, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel27, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel28, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel29, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel30, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel31, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel32, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel33, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel34, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel35, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel6
        $JPanel6.add($JScrollPane0);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        // inline complete setup of $JPanel7
        $JPanel7.add(cancel);
        $JPanel7.add(ok);
        
        // apply 25 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Form"));
        $JPanel1.setBorder(BorderFactory.createTitledBorder("Model"));
        $JPanel2.setBorder(BorderFactory.createTitledBorder("Form2"));
        $JPanel3.setBorder(BorderFactory.createTitledBorder("Model2"));
        $JPanel4.setBorder(BorderFactory.createTitledBorder("Identify Form"));
        $JPanel5.setBorder(BorderFactory.createTitledBorder("Identity Model"));
        $JPanel6.setBorder(BorderFactory.createTitledBorder("Messages"));
        errorTable.setModel(errors2);
        // late initializer
        // register 3 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds.add("validator2");
        getValidator("validator2").installUIs();
        getValidator("validator2").reloadBean();
        validatorIds.add("validator3");
        getValidator("validator3").installUIs();
        getValidator("validator3").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        createModel1();
        createModel2();
        createIdentity();
        createErrors2();
        createValidator();
        createValidator2();
        createValidator3();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,120);
        $JPanel0.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel0,250);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Text:"));
        createText();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("Text2:"));
        createText2();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("Ratio:"));
        createRatio();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        SwingUtil.setComponentHeight($JPanel1,120);
        $JPanel1.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel1,250);
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("Text:"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("Text2:"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("Ratio:"));
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new javax.swing.JLabel());
        
        $JLabel8.setName("$JLabel8");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        
        $JPanel2.setName("$JPanel2");
        SwingUtil.setComponentHeight($JPanel2,120);
        $JPanel2.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel2,250);
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new jaxx.runtime.swing.Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new javax.swing.JLabel());
        
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("Text:"));
        create_text();
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new javax.swing.JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(_("Text2:"));
        create_text2();
        // inline creation of $JLabel11
        $objectMap.put("$JLabel11", $JLabel11 = new javax.swing.JLabel());
        
        $JLabel11.setName("$JLabel11");
        $JLabel11.setText(_("Ratio:"));
        create_ratio();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new javax.swing.JPanel());
        
        $JPanel3.setName("$JPanel3");
        SwingUtil.setComponentHeight($JPanel3,120);
        $JPanel3.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel3,250);
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new jaxx.runtime.swing.Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel12
        $objectMap.put("$JLabel12", $JLabel12 = new javax.swing.JLabel());
        
        $JLabel12.setName("$JLabel12");
        $JLabel12.setText(_("Text:"));
        // inline creation of $JLabel13
        $objectMap.put("$JLabel13", $JLabel13 = new javax.swing.JLabel());
        
        $JLabel13.setName("$JLabel13");
        // inline creation of $JLabel14
        $objectMap.put("$JLabel14", $JLabel14 = new javax.swing.JLabel());
        
        $JLabel14.setName("$JLabel14");
        $JLabel14.setText(_("Text2:"));
        // inline creation of $JLabel15
        $objectMap.put("$JLabel15", $JLabel15 = new javax.swing.JLabel());
        
        $JLabel15.setName("$JLabel15");
        // inline creation of $JLabel16
        $objectMap.put("$JLabel16", $JLabel16 = new javax.swing.JLabel());
        
        $JLabel16.setName("$JLabel16");
        $JLabel16.setText(_("Ratio:"));
        // inline creation of $JLabel17
        $objectMap.put("$JLabel17", $JLabel17 = new javax.swing.JLabel());
        
        $JLabel17.setName("$JLabel17");
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new javax.swing.JPanel());
        
        $JPanel4.setName("$JPanel4");
        SwingUtil.setComponentHeight($JPanel4,180);
        $JPanel4.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel4,250);
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new jaxx.runtime.swing.Table());
        
        $Table5.setName("$Table5");
        // inline creation of $JLabel18
        $objectMap.put("$JLabel18", $JLabel18 = new javax.swing.JLabel());
        
        $JLabel18.setName("$JLabel18");
        $JLabel18.setText(_("FirstName:"));
        createFirstName();
        // inline creation of $JLabel19
        $objectMap.put("$JLabel19", $JLabel19 = new javax.swing.JLabel());
        
        $JLabel19.setName("$JLabel19");
        $JLabel19.setText(_("LastName:"));
        createLastName();
        // inline creation of $JLabel20
        $objectMap.put("$JLabel20", $JLabel20 = new javax.swing.JLabel());
        
        $JLabel20.setName("$JLabel20");
        $JLabel20.setText(_("Email:"));
        createEmail2();
        // inline creation of $JLabel21
        $objectMap.put("$JLabel21", $JLabel21 = new javax.swing.JLabel());
        
        $JLabel21.setName("$JLabel21");
        $JLabel21.setText(_("Age:"));
        createAge();
        // inline creation of $JLabel22
        $objectMap.put("$JLabel22", $JLabel22 = new javax.swing.JLabel());
        
        $JLabel22.setName("$JLabel22");
        $JLabel22.setText(_("Config file :"));
        createConfig();
        // inline creation of $JLabel23
        $objectMap.put("$JLabel23", $JLabel23 = new javax.swing.JLabel());
        
        $JLabel23.setName("$JLabel23");
        $JLabel23.setText(_("Working directory:"));
        createDir();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new javax.swing.JPanel());
        
        $JPanel5.setName("$JPanel5");
        SwingUtil.setComponentHeight($JPanel5,120);
        $JPanel5.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel5,250);
        // inline creation of $Table6
        $objectMap.put("$Table6", $Table6 = new jaxx.runtime.swing.Table());
        
        $Table6.setName("$Table6");
        // inline creation of $JLabel24
        $objectMap.put("$JLabel24", $JLabel24 = new javax.swing.JLabel());
        
        $JLabel24.setName("$JLabel24");
        $JLabel24.setText(_("FirstName:"));
        // inline creation of $JLabel25
        $objectMap.put("$JLabel25", $JLabel25 = new javax.swing.JLabel());
        
        $JLabel25.setName("$JLabel25");
        // inline creation of $JLabel26
        $objectMap.put("$JLabel26", $JLabel26 = new javax.swing.JLabel());
        
        $JLabel26.setName("$JLabel26");
        $JLabel26.setText(_("LastName:"));
        // inline creation of $JLabel27
        $objectMap.put("$JLabel27", $JLabel27 = new javax.swing.JLabel());
        
        $JLabel27.setName("$JLabel27");
        // inline creation of $JLabel28
        $objectMap.put("$JLabel28", $JLabel28 = new javax.swing.JLabel());
        
        $JLabel28.setName("$JLabel28");
        $JLabel28.setText(_("Email:"));
        // inline creation of $JLabel29
        $objectMap.put("$JLabel29", $JLabel29 = new javax.swing.JLabel());
        
        $JLabel29.setName("$JLabel29");
        // inline creation of $JLabel30
        $objectMap.put("$JLabel30", $JLabel30 = new javax.swing.JLabel());
        
        $JLabel30.setName("$JLabel30");
        $JLabel30.setText(_("Age:"));
        // inline creation of $JLabel31
        $objectMap.put("$JLabel31", $JLabel31 = new javax.swing.JLabel());
        
        $JLabel31.setName("$JLabel31");
        // inline creation of $JLabel32
        $objectMap.put("$JLabel32", $JLabel32 = new javax.swing.JLabel());
        
        $JLabel32.setName("$JLabel32");
        $JLabel32.setText(_("Config file:"));
        // inline creation of $JLabel33
        $objectMap.put("$JLabel33", $JLabel33 = new javax.swing.JLabel());
        
        $JLabel33.setName("$JLabel33");
        // inline creation of $JLabel34
        $objectMap.put("$JLabel34", $JLabel34 = new javax.swing.JLabel());
        
        $JLabel34.setName("$JLabel34");
        $JLabel34.setText(_("Directory file:"));
        // inline creation of $JLabel35
        $objectMap.put("$JLabel35", $JLabel35 = new javax.swing.JLabel());
        
        $JLabel35.setName("$JLabel35");
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new javax.swing.JPanel());
        
        $JPanel6.setName("$JPanel6");
        SwingUtil.setComponentHeight($JPanel6,200);
        $JPanel6.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel6,500);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new javax.swing.JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,2,0,0));
        createCancel();
        createOk();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 25 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 25 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TEXT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    jaxx.runtime.SwingUtil.setText(text, model1.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TEXT2_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    jaxx.runtime.SwingUtil.setText(text2, model1.getText2());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RATIO_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    ratio.setValue(model1.getRatio());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL4_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    $JLabel4.setText(_(model1.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL6_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    $JLabel6.setText(_(model1.getText2()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL8_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    $JLabel8.setText(_(model1.getRatio()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING__TEXT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    jaxx.runtime.SwingUtil.setText(_text, model2.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING__TEXT2_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    jaxx.runtime.SwingUtil.setText(_text2, model2.getText2());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING__RATIO_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    _ratio.setValue(model2.getRatio());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL13_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    $JLabel13.setText(_(model2.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL15_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    $JLabel15.setText(_(model2.getText2()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL17_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    $JLabel17.setText(_(model2.getRatio()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("firstName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    jaxx.runtime.SwingUtil.setText(firstName, identity.getFirstName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("firstName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("lastName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    jaxx.runtime.SwingUtil.setText(lastName, identity.getLastName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("lastName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL2_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("email", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    jaxx.runtime.SwingUtil.setText(email2, identity.getEmail());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("email", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AGE_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("age", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    age.setValue(identity.getAge());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("age", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONFIG_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    jaxx.runtime.SwingUtil.setText(config, identity.getConfig()+"");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DIR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("dir", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    jaxx.runtime.SwingUtil.setText(dir, identity.getDir()+"");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("dir", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL25_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("firstName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel25.setText(_(identity.getFirstName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("firstName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL27_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("lastName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel27.setText(_(identity.getLastName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("lastName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL29_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("email", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel29.setText(_(identity.getEmail()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("email", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL31_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("age", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel31.setText(_(identity.getAge()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("age", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL33_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel33.setText(_(identity.getConfig()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL35_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("dir", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel35.setText(_(identity.getDir()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("dir", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
    }

}