package jaxx.demo.component.jaxx.editor.datetime;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import static org.nuiton.i18n.I18n.t;

public class DateTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";
    public static final String BINDING_EDITOR_DATE_FORMAT = "editor.dateFormat";
    public static final String BINDING_EDITOR_LABEL = "editor.label";
    public static final String BINDING_RESULT_DATE_TEXT = "resultDate.text";
    public static final String BINDING_RESULT_DAY_DATE_TEXT = "resultDayDate.text";
    public static final String BINDING_RESULT_TIME_DATE_TEXT = "resultTimeDate.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8bRRh+bWIncdLmS00LFCk4VXFKtW4PCKqgNiXBQOUCIjlU+NKxd2JvNd7dzs42a1lF/AR+AtwRCIkbJ8SBMwcuiL+AEAeuiHdm9tPexNvWktfj9+N5P2bfZ+bbv6DicXj9EQkCg/u2sIbUuHf3wYNPuo9oTxxQr8ctVzgc9KdUhnIHlsxY7gnY7rSlezN0b+47Q9exqZ3y3m1DzRMjRr0BpULAa1mPnuc1D2P1buD6PEKNk8pD/fqfv8tfmV9+UwYIXMxuFUvZmuWVVDLXhrJlCljHSE9IkxG7j2lwy+5jvuekbJ8Rz/uYDOlj+ALm21B1CUcwAfXiJSsM5R+4ApauHNCh8ymxKbshYFcla6LE6EUQhpJR00IQwySCqkIOcHGEi/eVXGK4rkKtCqgMHZMyAXsvgHZfQiSQC1fuRTmuy0YEhneCfTG0VBotxrZLPcc+tvpKI+BSpv/a64h0mWrhSuy0ykiXsn3l2ZbLyUBKKI3Xk0ApHwGbGfMjGoiWRZmZdVk7dviQiFQcqbiYNVpOG0nZK1l9VbdPQNPhfcP28Y+t+3pimX0qvNMamy25yqnnMyH/rWU7uKI10jmbYz02qSUmcYaJdj3Sjs7COJexyoHZ0AaygLNwzmfN0kAcXs3sP062kUx2MnqlDlS4j2J8YTrTZPAZqjQNXJqgAQmotP9tbvz+058/ttKzfyHXNEVdOJMud1zKhSVDr+jB94XFmveJu9uBRY8y5D3Fa5dzEjsM1ZgcxluT7oZ0Nz4k3gAhKvN//PzL5sPfXoJyC2rMIWaLSPuPYFEMsG0Dh5mBe2dPZbR8siATx28Z3w5GRo6P1HJhbNOTrQ+4ZbaVpHHj+s2dp2jQdbiJmcNtZXBkCUbN95SsIRp1maoa/ehdDGdeD6fPibAcu76z8zTArl7O6WpcWnfx1383Dn/YizpbwkpfPtU86W7lc6haNrNsqng1pMxcHl1yPeqbTkKNeWQJWWpxQ3Z6Sz1vTfWwJGBOIAsIeLNQLwzFJoEv0e6oMuXqLuRwU/HQ74yLboUObzwhzKd1uSvTeaT5rngK14uF15yXF3aaM4sHv1W8fh3lzAZkiHlWEgu4ceFwjyJqwoNMxMu5LiW2gPmxOi5xopYj81Cv0oWa/GmpwEhO43QKBpK9PGgach4rTB9bF8epbcpYhIBrOqBUyUCNzDC//UzDrH/kFCN5JdmHBcybepXXyvAMK7CTz5maPhM0weSE1+riL9L22XGUNC/Q5FE6K2I5jlgfD4htMsrjjZrYNtn0BZmFvM3g/h8T5uXmkDqrixd8dWbBp+5tzulfvOxGtuzRZOWjZyw+e8koXv8bM+qP5jgvZt69pXgHrqU7EGEkLYglxXswcUEqMnTR6X/+XSyfbHUt28R77e0p9JJ81mYiSvF38vF9PsLqCyNsI8L/T75BZT4OAAA=";
    private static final Log log = LogFactory.getLog(DateTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected DateTimeEditor editor;
    protected JTextField formatConfig;
    protected JLabel formatConfigLabel;
    protected final DateTimeEditorDemoHandler handler = new DateTimeEditorDemoHandler();
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected DateTimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultDate;
    protected JLabel resultDateLabel;
    protected JTextField resultDayDate;
    protected JLabel resultDayDateLabel;
    protected JTextField resultTimeDate;
    protected JLabel resultTimeDateLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditorDemo $DemoPanel0 = this;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DateTimeEditorDemo() {
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public DateTimeEditor getEditor() {
        return editor;
    }

    public JTextField getFormatConfig() {
        return formatConfig;
    }

    public JLabel getFormatConfigLabel() {
        return formatConfigLabel;
    }

    public DateTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public DateTimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultDate() {
        return resultDate;
    }

    public JLabel getResultDateLabel() {
        return resultDateLabel;
    }

    public JTextField getResultDayDate() {
        return resultDayDate;
    }

    public JLabel getResultDayDateLabel() {
        return resultDayDateLabel;
    }

    public JTextField getResultTimeDate() {
        return resultTimeDate;
    }

    public JLabel getResultTimeDateLabel() {
        return resultTimeDateLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfigLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfig, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultDateLabel);
        result.add(resultDate);
        result.add(resultDayDateLabel);
        result.add(resultDayDate);
        result.add(resultTimeDateLabel);
        result.add(resultTimeDate);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
        configPanel.setLayout(new GridLayout(0,1));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new DateTimeEditor(this));
        
        editor.setName("editor");
        editor.setPropertyTimeDate("timeDate");
        editor.setPropertyDate("date");
        editor.setPropertyDayDate("dayDate");
    }

    protected void createFormatConfig() {
        $objectMap.put("formatConfig", formatConfig = new JTextField());
        
        formatConfig.setName("formatConfig");
        formatConfig.setColumns(15);
    }

    protected void createFormatConfigLabel() {
        $objectMap.put("formatConfigLabel", formatConfigLabel = new JLabel());
        
        formatConfigLabel.setName("formatConfigLabel");
        formatConfigLabel.setText(t("jaxxdemo.datetimeeditor.configuration.format"));
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
        labelConfigLabel.setText(t("jaxxdemo.datetimeeditor.configuration.label"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DateTimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultDate() {
        $objectMap.put("resultDate", resultDate = new JTextField());
        
        resultDate.setName("resultDate");
        resultDate.setColumns(15);
        resultDate.setEditable(false);
    }

    protected void createResultDateLabel() {
        $objectMap.put("resultDateLabel", resultDateLabel = new JLabel());
        
        resultDateLabel.setName("resultDateLabel");
        resultDateLabel.setText(t("jaxxdemo.datetimeeditor.result.date"));
    }

    protected void createResultDayDate() {
        $objectMap.put("resultDayDate", resultDayDate = new JTextField());
        
        resultDayDate.setName("resultDayDate");
        resultDayDate.setColumns(15);
        resultDayDate.setEditable(false);
    }

    protected void createResultDayDateLabel() {
        $objectMap.put("resultDayDateLabel", resultDayDateLabel = new JLabel());
        
        resultDayDateLabel.setName("resultDayDateLabel");
        resultDayDateLabel.setText(t("jaxxdemo.datetimeeditor.result.dayDate"));
    }

    protected void createResultTimeDate() {
        $objectMap.put("resultTimeDate", resultTimeDate = new JTextField());
        
        resultTimeDate.setName("resultTimeDate");
        resultTimeDate.setColumns(15);
        resultTimeDate.setEditable(false);
    }

    protected void createResultTimeDateLabel() {
        $objectMap.put("resultTimeDateLabel", resultTimeDateLabel = new JLabel());
        
        resultTimeDateLabel.setName("resultTimeDateLabel");
        resultTimeDateLabel.setText(t("jaxxdemo.datetimeeditor.result.timeDate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        configPanel.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.configuration")));
        SwingUtil.setText(labelConfig, t("jaxxdemo.datetimeeditor.configuration.label.value"));
        
        SwingUtil.setText(formatConfig, t("jaxxdemo.datetimeeditor.configuration.format.value"));
        
        editor.setBean(model);
        editor.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.editor")));
        result.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createFormatConfigLabel();
        createFormatConfig();
        createEditor();
        createResult();
        createResultDateLabel();
        createResultDate();
        createResultDayDateLabel();
        createResultDayDate();
        createResultTimeDateLabel();
        createResultTimeDate();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LABEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (labelConfig != null) {
                    $bindingSources.put("labelConfig.getDocument()", labelConfig.getDocument());
                    labelConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    labelConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (labelConfig != null) {
                    editor.setLabel(labelConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (labelConfig != null) {
                    Document $target = (Document) $bindingSources.remove("labelConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    labelConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatConfig != null) {
                    $bindingSources.put("formatConfig.getDocument()", formatConfig.getDocument());
                    formatConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    formatConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_FORMAT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatConfig != null) {
                    editor.setDateFormat(formatConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatConfig != null) {
                    Document $target = (Document) $bindingSources.remove("formatConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    }
                    formatConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_FORMAT));
                }
            }
        
            public void $pr$u1(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setDate(model.getDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultDate, handler.getDate(model.getDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DAY_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dayDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultDayDate, handler.getDayDate(model.getDayDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dayDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_TIME_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultTimeDate, handler.getTimeDate(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
    }

}