/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDHelper {
    protected static final Log log = LogFactory.getLog(IDHelper.class);
    protected final Map<String, Integer> autoGenIds = new TreeMap<String, Integer>();
    protected final Map<Object, String> uniqueIds = new HashMap<Object, String>();
    protected int optimizedAutogenId = 0;
    protected final boolean optimize;

    public IDHelper(boolean optimize) {
        this.optimize = optimize;
    }

    public String nextId(String name) {
        if (this.optimize) {
            return "$" + Integer.toString(this.optimizedAutogenId++, 36);
        }
        Integer integer = this.autoGenIds.get(name);
        if (integer == null) {
            integer = 0;
        }
        name = name.substring(name.lastIndexOf(".") + 1);
        String result = "$" + name + integer;
        integer = integer + 1;
        this.autoGenIds.put(name, integer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("new id = " + result));
        }
        return result;
    }

    public String getUniqueId(Object object) {
        String result = this.uniqueIds.computeIfAbsent(object, k -> "$u" + this.uniqueIds.size());
        if (log.isTraceEnabled()) {
            log.trace((Object)("new uniqueid = " + result));
        }
        return result;
    }

    public void clear() {
        this.autoGenIds.clear();
        this.uniqueIds.clear();
    }
}

