/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: KeyStrokeConverter.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.20/jaxx-compiler/src/main/java/jaxx/compiler/types/KeyStrokeConverter.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.types;

import javax.swing.KeyStroke;

public class KeyStrokeConverter implements TypeConverter {

    @Override
    public Class<?>[] getSupportedTypes() {
        return new Class<?>[]{KeyStroke.class};
    }

    @Override
    public String getJavaCode(Object object) {
        return "KeyStroke.getKeyStroke(\"" + object.toString() + "\")";
    }

    @Override
    public Object convertFromString(String string, Class<?> type) {
        if (!KeyStroke.class.equals(type)) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        return KeyStroke.getKeyStroke(string);
    }
}
