/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: FinalizeTask.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.2/jaxx-compiler/src/main/java/jaxx/compiler/tasks/FinalizeTask.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tasks;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Task to execute after stylesheet tasks and juste before generation task.
 * <p/>
 * This task will finialize all compilers.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class FinalizeTask extends JAXXEngineTask {

    /** Logger */
    private static final Log log = LogFactory.getLog(FinalizeTask.class);

    /** Task name */
    public static final String TASK_NAME = "Finalize";

    public FinalizeTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        boolean isVerbose = engine.getConfiguration().isVerbose();

        // check all files are attached to a compiler
        checkAllFilesCompiled(engine);

        JAXXCompilerFile[] files = engine.getCompiledFiles();
        
        for (JAXXCompilerFile jaxxFile : files) {

            if (isVerbose) {
                log.info("start " + jaxxFile.getClassName());
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            addStartProfileTime(engine, compiler);
            compiler.finalizeCompiler();
            addEndProfileTime(engine, compiler);
            if (compiler.isFailed()) {
                success = false;
            }
        }
        return success;
    }
}