/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: CompiledItemContainer.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.1/jaxx-compiler/src/main/java/jaxx/compiler/tags/swing/CompiledItemContainer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.tags.swing;

import jaxx.compiler.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.runtime.swing.Item;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/** Compiled representation of a class that contains Items arranged in a list or tree structure (JComboBox, JList, JTree). */
class CompiledItemContainer extends CompiledObject {

    private List<Item> items = new ArrayList<Item>();
    private Stack<Item> openNodes = new Stack<Item>();

    public CompiledItemContainer(String id, ClassDescriptor objectClass, JAXXCompiler compiler) throws CompilerException {
        super(id, objectClass, compiler);
    }

    public void openItem(Item item) {
        if (openNodes.isEmpty()) {
            items.add(item);
        } else {
            Item openNode = openNodes.peek();
            openNode.addChild(item);
        }
        openNodes.add(item);
    }

    public void closeItem(Item item) {
        if (!item.equals(openNodes.pop())) {
            throw new IllegalArgumentException(item + " was not at the top of the item stack");
        }
    }

    public List<Item> getItems() {
        return items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }
}
