/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.finalizers;

import java.util.List;
import java.util.Map;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElement;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.validator.BeanValidatorHandler;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorFinalizer
implements JAXXCompilerFinalizer {
    static Log log = LogFactory.getLog(ValidatorFinalizer.class);
    protected static final JavaField VALIDATOR_IDS_FIELD = JavaFileGenerator.newField(4, "java.util.List<String>", "validatorIds", true, "new ArrayList<String>()");

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return BeanValidatorHandler.hasValidator(compiler);
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        for (CompiledObject object : compiler.getObjects().values()) {
            List<CompiledObject.ChildRef> childs = object.getChilds();
            if (childs == null || childs.isEmpty()) continue;
            for (CompiledObject.ChildRef child : childs) {
                String javaCode = child.getChildJavaCode();
                boolean found = BeanValidatorHandler.isComponentUsedByValidator(compiler, child.getChild().getId());
                if (!found) continue;
                child.setChildJavaCode(SwingUtil.class.getSimpleName() + ".boxComponentWithJxLayer(" + javaCode + ")");
            }
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder builder = new StringBuilder();
        List<BeanValidatorHandler.CompiledBeanValidator> validators = BeanValidatorHandler.getValidators(compiler);
        javaFile.addImport(Validator.class);
        javaFile.addImport(ValidatorField.class);
        javaFile.addImport(SwingValidatorUtil.class);
        compiler.getJavaFile().addMethod(JavaFileGenerator.newMethod(1, "void", "registerValidatorFields", SwingValidatorUtil.class.getSimpleName() + ".installFields(this);", true, new JavaArgument[0]));
        builder.append("// register ");
        builder.append(validators.size());
        builder.append(" validator(s)");
        builder.append(eol);
        builder.append("validatorIds = ");
        builder.append(SwingValidatorUtil.class.getSimpleName()).append(".initUI(this);");
        builder.append(eol);
        builder.append(SwingValidatorUtil.class.getSimpleName()).append(".installUI(this);");
        builder.append(eol);
        compiler.appendLateInitializer(builder.toString());
        for (BeanValidatorHandler.CompiledBeanValidator validator : validators) {
            this.registerValidator(validator, compiler, javaFile);
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        Class<SwingValidator> validatorClass = SwingValidator.class;
        String validatorFQN = validatorClass.getName();
        javaFile.addImport(validatorFQN);
        Class<JAXXValidator> validatorInterface = JAXXValidator.class;
        ClassDescriptor superClass = ClassDescriptorHelper.getClassDescriptor(javaFile.getSuperClass());
        ClassDescriptor validatorInterfaceDescriptor = ClassDescriptorHelper.getClassDescriptor(validatorInterface);
        boolean parentIsValidator = validatorInterfaceDescriptor.isAssignableFrom(superClass);
        if (parentIsValidator) {
            return;
        }
        javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface));
        javaFile.addField(VALIDATOR_IDS_FIELD);
        javaFile.addMethod(JavaFileGenerator.newMethod(1, validatorFQN + "<?>", "getValidator", "return (" + validatorFQN + "<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);", true, new JavaArgument("String", "validatorId")));
    }

    public void registerValidator(BeanValidatorHandler.CompiledBeanValidator validator, JAXXCompiler compiler, JavaFile javaFile) {
        JavaField validatorField = javaFile.getField(validator.getId());
        String validatorId = TypeManager.getJavaCode(validator.getId());
        String validatorAnnotation = Validator.class.getSimpleName() + "( validatorId = " + validatorId + ")";
        validatorField.addAnnotation(validatorAnnotation);
        Map<String, String> fields = validator.getFields();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String propertyName = entry.getKey();
            String component = entry.getValue();
            if (!validator.checkBeanProperty(compiler, propertyName)) continue;
            String keyCode = TypeManager.getJavaCode(propertyName);
            String editorCode = TypeManager.getJavaCode(component);
            JavaElement editor = javaFile.getField(component);
            if (editor == null) {
                String message = "Could not find editor [" + component + "] for property [" + propertyName + "] for file " + javaFile.getName();
                log.warn((Object)message);
                CompiledObject compiledObject = compiler.getCompiledObject(component);
                if (compiledObject == null) {
                    String errorMessage = "Could not find editor [" + component + "] for property [" + propertyName + "] for file " + javaFile.getName();
                    throw new CompilerException(errorMessage);
                }
                String fqn = JAXXCompiler.getCanonicalName(compiledObject);
                editor = javaFile.addGetterMethod(component, 1, fqn, true, true);
            }
            String annotation = ValidatorField.class.getSimpleName() + "( validatorId = " + validatorId + "," + "  propertyName = " + keyCode + "," + "  editorName = " + editorCode + "" + ")";
            editor.addAnnotation(annotation);
        }
    }
}

