/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: GenerateTask.java 2118 2010-10-26 17:44:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.3/jaxx-compiler/src/main/java/jaxx/compiler/tasks/GenerateTask.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tasks;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.java.JavaFileGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Last task to generate java files.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class GenerateTask extends JAXXEngineTask {

    /** Logger */
    private static final Log log = LogFactory.getLog(GenerateTask.class);

    /** Task name */
    public static final String TASK_NAME = "Generate";

    public GenerateTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {

        // check all files are attached to a compiler
        checkAllFilesCompiled(engine);
        
        boolean success = true;

        boolean verbose = engine.isVerbose();

        JavaFileGenerator generator =
                new JavaFileGenerator(JAXXCompiler.getLineSeparator(), verbose);

        JAXXCompilerFile[] files = engine.getCompiledFiles();
        
        for (JAXXCompilerFile jaxxFile : files) {

            if (verbose) {
                log.info("start " + jaxxFile.getClassName());
            }

            JAXXCompiler compiler = jaxxFile.getCompiler();
            addStartProfileTime(engine, compiler);
            compiler.generate(generator);
            addEndProfileTime(engine, compiler);
            if (compiler.isFailed()) {
                success = false;
            }
        }
        return success;
    }
}