/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.css.parser;

import jaxx.compiler.css.parser.CSSParser;
import jaxx.compiler.css.parser.Node;
import jaxx.compiler.css.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected CSSParser parser;
    public Token firstToken;
    public Token lastToken;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(CSSParser p, int i) {
        this(i);
        this.parser = p;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    public SimpleNode getParent() {
        return (SimpleNode)this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public SimpleNode getChild(int i) {
        return (SimpleNode)this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getText() + "]";
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (Node aChildren : this.children) {
                SimpleNode n = (SimpleNode)aChildren;
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    private void appendSpecialTokens(StringBuilder s, Token st) {
        if (st != null) {
            this.appendSpecialTokens(s, st.specialToken);
            s.append(st.image);
        }
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        Token t = this.firstToken;
        while (t != null) {
            this.appendSpecialTokens(text, t.specialToken);
            text.append(t.image);
            if (t == this.lastToken) break;
            t = t.next;
        }
        return text.toString();
    }
}

