/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.tasks.JAXXEngineTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StyleSheetTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(StyleSheetTask.class);
    private static final long serialVersionUID = -1L;
    public static final String TASK_NAME = "StyleSheet";

    public StyleSheetTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        JAXXCompilerFile[] files;
        boolean success = true;
        boolean isVerbose = engine.getConfiguration().isVerbose();
        for (JAXXCompilerFile jaxxFile : files = engine.getCompilingFiles()) {
            String className = jaxxFile.getClassName();
            if (isVerbose) {
                log.info((Object)(this.getName() + " for " + className));
            }
            JAXXCompiler compiler = this.getSafeCompiler(jaxxFile);
            this.addStartProfileTime(engine, compiler);
            compiler.applyStylesheets();
            this.addEndProfileTime(engine, compiler);
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }
}

