/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import java.util.Arrays;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.tasks.JAXXEngineTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompileSecondPassTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(CompileSecondPassTask.class);
    private static final long serialVersionUID = -1L;
    public static final String TASK_NAME = "CompileSecondPass";

    public CompileSecondPassTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        Object[] files;
        boolean success = true;
        boolean isVerbose = engine.isVerbose();
        for (JAXXCompilerFile jAXXCompilerFile : files = engine.getCompilingFiles()) {
            String className = jAXXCompilerFile.getClassName();
            if (isVerbose) {
                log.info((Object)(this.getName() + " for " + className));
            }
            JAXXCompiler compiler = this.getSafeCompiler(jAXXCompilerFile);
            this.addStartProfileTime(engine, compiler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("runInitializers for " + className));
            }
            if (!compiler.isFailed()) {
                compiler.runInitializers();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("compile second pass for " + className));
            }
            compiler.compileSecondPass();
            this.addEndProfileTime(engine, compiler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("done with result [" + !compiler.isFailed() + "] for " + className));
            }
            if (!compiler.isFailed()) continue;
            success = false;
        }
        Object[] jaxxFilesClone = engine.getCompilingFiles();
        if (jaxxFilesClone.length > files.length) {
            throw new CompilerException("Internal error: compilation set altered during pass 2 (was " + Arrays.toString(jaxxFilesClone) + ", modified to " + Arrays.toString(files) + ")");
        }
        return success;
    }
}

