/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.io.IOException;
import java.util.List;
import javax.swing.event.TreeSelectionListener;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.tags.DefaultComponentHandler;
import jaxx.compiler.tags.swing.CompiledItemContainer;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXTree;
import org.w3c.dom.Element;

public class JAXXTreeHandler
extends DefaultComponentHandler {
    public JAXXTreeHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(this.getClass(), beanClass, JAXXTree.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectionCount", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionPath", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionPaths", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionRows", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionValue", TreeSelectionListener.class, "selectionModel");
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledItemContainer(id, this.getBeanClass(), compiler);
    }

    private void createItems(CompiledObject tree, List<Item> items, String addMethod, JAXXCompiler compiler) throws CompilerException {
        for (Item item : items) {
            String id = item.getId();
            CompiledObject compiledItem = new CompiledObject(id, ClassDescriptorLoader.getClassDescriptor(Item.class), compiler);
            compiledItem.setConstructorParams(compiler.getJavaCode(id) + ", " + compiler.getJavaCode(item.getLabel()) + ", " + compiler.getJavaCode(item.getValue()) + ", " + item.isSelected());
            compiler.registerCompiledObject(compiledItem);
            tree.appendAdditionCode(addMethod + "(" + id + ");");
            this.createItems(tree, item.getChildren(), id + ".addChild", compiler);
        }
    }

    @Override
    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileChildrenSecondPass(tag, compiler);
        CompiledItemContainer tree = (CompiledItemContainer)compiler.getOpenComponent();
        List<Item> items = tree.getItems();
        if (items != null && !items.isEmpty()) {
            String listName = tree.getId() + "$items";
            tree.appendAdditionCode("java.util.List<jaxx.runtime.swing.Item> " + listName + " = new java.util.ArrayList<jaxx.runtime.swing.Item>();");
            this.createItems(tree, items, listName + ".add", compiler);
            tree.appendAdditionCode(tree.getId() + ".setItems(" + listName + ");");
        }
    }
}

