/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.types;

import jaxx.types.*;
import java.awt.Insets;
import java.util.StringTokenizer;

public class InsetsConverter implements TypeConverter {
    public String getJavaCode(Object object) {
        Insets insets = (Insets) object;
        return "new Insets(" + insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + ")";
    }


    public Object convertFromString(String string, Class type) {
        if (type != Insets.class) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        int count = tokenizer.countTokens();
        if (count == 1) {
            int i = Integer.parseInt(tokenizer.nextToken().trim());
            return new Insets(i, i, i, i);
        }
        if (count == 4) {
            int[] insets = new int[count];
            for (int i = 0; tokenizer.hasMoreTokens(); i++) {
                insets[i] = Integer.parseInt(tokenizer.nextToken().trim());
            }
            return new Insets(insets[0], insets[1], insets[2], insets[3]);
        }
        throw new IllegalArgumentException("unable to convert string '" + string + "' to Insets");
    }
}