/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.validator;

import jaxx.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.tags.TagHandler;
import jaxx.tags.validator.BeanValidatorHandler.CompiledBeanValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

import java.io.IOException;

public class FieldValidatorHandler implements TagHandler {

    public static final String TAG = "field";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String COMPONENT_ATTRIBUTE = "component";

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(FieldValidatorHandler.class);

    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (compiler.getOptions().isVerbose()) {
            log.info(tag);
        }
        //todo check there is no child
    }

    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (compiler.getOptions().isVerbose()) {
            log.info(tag);
        }

        if (!ClassDescriptorLoader.getClassDescriptor(SwingValidator.class).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError(TAG + " tag may only appear within " + BeanValidatorHandler.TAG + " tag but was " + tag);
            return;
        }

        CompiledBeanValidator info = (CompiledBeanValidator) compiler.getOpenComponent();

        String name = tag.getAttribute(NAME_ATTRIBUTE);
        String component = tag.getAttribute(COMPONENT_ATTRIBUTE);
        if (name == null || name.trim().isEmpty()) {
            compiler.reportError(TAG + " tag requires a " + NAME_ATTRIBUTE + " attribute");
            return;
        }
        name = name.trim();
        if (component == null || component.trim().isEmpty()) {
            // try to use the name as component
            if (!compiler.checkReference(tag, name, false, name)) {
                compiler.reportError(TAG + " tag requires a " + COMPONENT_ATTRIBUTE + " attribute, try to use the name attribute [" + name + "] for the component, but no such component found");
                return;
            }
            component = name;
        }
        component = component.trim();

        // check component is not already used by this compiled object
        if (info.getFields().containsValue(component)) {
            compiler.reportError(TAG + " tag found a attribute " + COMPONENT_ATTRIBUTE + " [" + component + "] already used in this validator");
            return;
        }
        // check component exist (again perharps, but let the error knows exactly which tag failed...)
        if (compiler.checkReference(tag, component, true, COMPONENT_ATTRIBUTE)) {
            // add a field
            info.registerField(name, component, compiler);
        }


    }

}