package jaxx.reflect;

/**
 * Mirrors the class <code>java.lang.ref.Field</code>.  JAXX uses <code>ClassDescriptor</code> instead of <code>Class</code>
 * almost everywhere so that it can handle circular dependencies (there can't be a <code>Class</code> object for an uncompiled
 * JAXX or Java source file, and a compiler must be allow references to symbols in uncompiled source files in order to handle
 * circular dependencies).
 */
public class FieldDescriptor extends MemberDescriptor {
    private String type;


    public FieldDescriptor(String name, int modifiers, String type, ClassLoader classLoader) {
        super(name, modifiers, classLoader);
        this.type = type;
    }


    public ClassDescriptor getType() {
        try {
            return ClassDescriptorLoader.getClassDescriptor(type, getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}