/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx;

/** Thrown by the compiler when an unregistered tag is encountered. */
public class UnsupportedTagException extends CompilerException {
    private static final long serialVersionUID = 3199732135804426699L;

    /** Creates a new <code>UnsupportedTagException</code>. */
    public UnsupportedTagException() {
    }


    /**
     * Creates a new <code>UnsupportedTagException</code> with the specified detail message.
     *
     * @param msg the exception's detail message
     */
    public UnsupportedTagException(String msg) {
        super(msg);
    }


    /**
     * Creates a new <code>UnsupportedTagException</code> with the specified cause.
     *
     * @param initCause the exception's initCause
     */
    public UnsupportedTagException(Throwable initCause) {
        super(initCause);
    }


    /**
     * Creates a new <code>UnsupportedTagException</code> with the specified detail message and cause.
     *
     * @param msg       the exception's detail message
     * @param initCause the exception's initCause
     */
    public UnsupportedTagException(String msg, Throwable initCause) {
        super(msg, initCause);
    }
}