/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx;

/**
 * Thrown by <code>TagHandler</code> when an unsupported attribute is encountered.
 *
 * @see jaxx.tags.TagHandler
 */
public class UnsupportedAttributeException extends CompilerException {
    private static final long serialVersionUID = -6919583037172920343L;

    /** Creates a new <code>UnsupportedAttributeException</code>. */
    public UnsupportedAttributeException() {
    }


    /**
     * Creates a new <code>UnsupportedAttributeException</code> with the specified detail message.
     *
     * @param msg the exception's detail message
     */
    public UnsupportedAttributeException(String msg) {
        super(msg);
    }


    /**
     * Creates a new <code>UnsupportedAttributeException</code> with the specified cause.
     *
     * @param initCause the exception's initCause
     */
    public UnsupportedAttributeException(Throwable initCause) {
        super(initCause);
    }


    /**
     * Creates a new <code>UnsupportedAttributeException</code> with the specified detail message and cause.
     *
     * @param msg       the exception's detail message
     * @param initCause the exception's initCause
     */
    public UnsupportedAttributeException(String msg, Throwable initCause) {
        super(msg, initCause);
    }
}