/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import jaxx.compiler.JavaArgument;
import jaxx.compiler.JavaFile;

public class JavaMethod
implements Comparable<JavaMethod> {
    private int modifiers;
    private String returnType;
    private String name;
    private JavaArgument[] arguments;
    private String[] exceptions;
    private StringBuffer bodyCode;
    public static final Comparator<JavaMethod> COMPARATOR = new Comparator<JavaMethod>(){

        @Override
        public int compare(JavaMethod o1, JavaMethod o2) {
            return o1.name.compareTo(o2.name);
        }

        public int compareStatic(JavaMethod o1, JavaMethod o2) {
            if (Modifier.isStatic(o1.modifiers) && !Modifier.isStatic(o2.modifiers)) {
                return -1;
            }
            if (!Modifier.isStatic(o1.modifiers) && Modifier.isStatic(o2.modifiers)) {
                return 1;
            }
            return 0;
        }

        public int compareConstructor(JavaMethod o1, JavaMethod o2) {
            if (o1.returnType == null && o2.returnType != null) {
                return -1;
            }
            if (o1.returnType != null && o2.returnType == null) {
                return 1;
            }
            return 0;
        }

        public int compareVisibility(JavaMethod o1, JavaMethod o2) {
            if (Modifier.isPublic(o1.modifiers) && !Modifier.isPublic(o2.modifiers)) {
                return -1;
            }
            if (!Modifier.isPublic(o1.modifiers) && Modifier.isPublic(o2.modifiers)) {
                return 1;
            }
            if (Modifier.isProtected(o1.modifiers) && !Modifier.isProtected(o2.modifiers)) {
                return -1;
            }
            if (!Modifier.isProtected(o1.modifiers) && Modifier.isProtected(o2.modifiers)) {
                return 1;
            }
            if (Modifier.isPrivate(o1.modifiers) && !Modifier.isPrivate(o2.modifiers)) {
                return -1;
            }
            if (!Modifier.isPrivate(o1.modifiers) && Modifier.isPrivate(o2.modifiers)) {
                return 1;
            }
            return 0;
        }
    };

    public JavaMethod(int modifiers, String returnType, String name, JavaArgument[] arguments, String[] exceptions, String bodyCode) {
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.name = name;
        this.arguments = arguments;
        this.exceptions = exceptions;
        this.bodyCode = new StringBuffer(bodyCode != null ? bodyCode : "");
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public JavaArgument[] getArguments() {
        return this.arguments;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public String getBodyCode() {
        return this.bodyCode.toString();
    }

    public void appendBodyCode(String extraCode, String lineSeparator) {
        if (extraCode.length() == 0) {
            return;
        }
        if (this.bodyCode.length() > 0 && !this.bodyCode.toString().endsWith(lineSeparator)) {
            this.bodyCode.append(lineSeparator);
        }
        this.bodyCode.append(extraCode);
    }

    public String toString(String lineSeparator) {
        String formattedBodyCode;
        StringBuffer result = new StringBuffer();
        result.append(JavaFile.getModifiersText(this.modifiers));
        if (this.returnType != null) {
            result.append(this.returnType);
            result.append(' ');
        }
        result.append(this.name);
        result.append('(');
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.arguments[i].toString());
            }
        }
        result.append(") {");
        result.append(lineSeparator);
        if (this.bodyCode != null && (formattedBodyCode = JavaFile.addIndentation(this.bodyCode.toString().trim(), 4, lineSeparator)).length() > 0) {
            result.append(formattedBodyCode);
            result.append(lineSeparator);
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public int compareTo(JavaMethod o) {
        return COMPARATOR.compare(this, o);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String initializer, String[] exceptions, JavaArgument ... arguments) {
        return new JavaMethod(modifiers, returnType, name, arguments, exceptions, initializer);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String initializer, JavaArgument ... arguments) {
        return JavaMethod.newMethod(modifiers, returnType, name, initializer, new String[0], arguments);
    }

    public static EnumMap<MethodOrder, List<JavaMethod>> getSortedMethods(List<JavaMethod> methods) {
        int[] scopes;
        EnumMap<MethodOrder, List<JavaMethod>> result = new EnumMap<MethodOrder, List<JavaMethod>>(MethodOrder.class);
        for (MethodOrder methodOrder : MethodOrder.values()) {
            result.put(methodOrder, new ArrayList());
        }
        EnumSet<MethodOrder> allConstants = EnumSet.allOf(MethodOrder.class);
        ArrayList<JavaMethod> allMethods = new ArrayList<JavaMethod>(methods);
        for (int scope : scopes = new int[]{8, 1, 4, 2}) {
            EnumSet<MethodOrder> constants = JavaMethod.getMethodOrderScope(allConstants, scope);
            Iterator itMethods = allMethods.iterator();
            block2: while (itMethods.hasNext()) {
                JavaMethod method = (JavaMethod)itMethods.next();
                for (MethodOrder constant : constants) {
                    if (!constant.accept(method.getModifiers(), method)) continue;
                    result.get((Object)constant).add(method);
                    itMethods.remove();
                    continue block2;
                }
            }
            constants.clear();
        }
        if (!allMethods.isEmpty()) {
            throw new IllegalArgumentException("could not find a " + MethodOrder.class + " for method " + allMethods);
        }
        for (MethodOrder methodOrder : MethodOrder.values()) {
            Collections.sort(result.get((Object)methodOrder));
        }
        return result;
    }

    public static EnumSet<MethodOrder> getMethodOrderScope(EnumSet<MethodOrder> allConstants, int scope) {
        EnumSet<MethodOrder> constants = EnumSet.noneOf(MethodOrder.class);
        for (MethodOrder order : allConstants) {
            if (!order.accept(scope)) continue;
            constants.add(order);
        }
        return constants;
    }

    public static enum MethodOrder {
        statics(8, "/*---------------------------------------------------------------------------------*/\n/*-- Statics methods --------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){}
        ,
        constructors(1, "/*---------------------------------------------------------------------------------*/\n/*-- Constructors -----------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.returnType == null;
            }
        }
        ,
        JAXXObject(1, "/*---------------------------------------------------------------------------------*/\n/*-- JAXXObject implementation ----------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){
            private List<String> methods = Arrays.asList("applyDataBinding", "firePropertyChange", "getObjectById", "get$objectMap", "processDataBinding", "removeDataBinding");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.name);
            }
        }
        ,
        JAXXContext(1, "/*---------------------------------------------------------------------------------*/\n/*-- JAXXContext implementation ---------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){
            private List<String> methods = Arrays.asList("getContextValue", "getDelegateContext", "getParentContainer", "removeContextValue", "setContextValue");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.name);
            }
        }
        ,
        JAXXValidation(1, "/*---------------------------------------------------------------------------------*/\n/*-- JAXXValidation implementation ------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){
            private List<String> methods = Arrays.asList("getValidator", "getValidatorIds");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.name);
            }
        }
        ,
        events(1, "/*---------------------------------------------------------------------------------*/\n/*-- Event methods ----------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.name.startsWith("do") && method.name.indexOf("__") > -1;
            }
        }
        ,
        publicGetters(1, "/*---------------------------------------------------------------------------------*/\n/*-- public acessor methods -------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.name.startsWith("get") || method.name.startsWith("is");
            }
        }
        ,
        publicSetters(1, "/*---------------------------------------------------------------------------------*/\n/*-- public mutator methods -------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.name.startsWith("set");
            }
        }
        ,
        otherPublic(1, "/*---------------------------------------------------------------------------------*/\n/*-- public mutator methods -------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(int mod) {
                return super.accept(mod) && !Modifier.isStatic(mod);
            }
        }
        ,
        protectedGetters(4, "/*---------------------------------------------------------------------------------*/\n/*-- protected acessors methods ---------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.name.startsWith("get") || method.name.startsWith("is");
            }
        }
        ,
        createMethod(6, "/*---------------------------------------------------------------------------------*/\n/*-- ui creation methods ----------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.name.startsWith("create") || method.name.startsWith("add") || method.name.equals("$completeSetup") || method.name.equals("$initialize");
            }
        }
        ,
        protecteds(4, "/*---------------------------------------------------------------------------------*/\n/*-- Other protected methods ------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){}
        ,
        packageLocal(0, "/*---------------------------------------------------------------------------------*/\n/*-- Package methods --------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(int mod) {
                return !Modifier.isStatic(mod) && !Modifier.isPublic(mod) && !Modifier.isProtected(mod);
            }
        }
        ,
        privates(2, "/*---------------------------------------------------------------------------------*/\n/*-- Private methods --------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){};

        private final String header;
        private int modifier;

        private MethodOrder(int modifier, String header) {
            this.header = header;
            this.modifier = modifier;
        }

        public String getHeader() {
            return this.header;
        }

        public boolean accept(JavaMethod method) {
            return true;
        }

        public boolean accept(int mod) {
            return (mod & this.modifier) != 0;
        }

        public boolean accept(int mod, JavaMethod method) {
            return this.accept(mod) && this.accept(method);
        }

        public static MethodOrder valueOf(JavaMethod method, int scope) {
            for (MethodOrder o : MethodOrder.values()) {
                if (!o.accept(scope, method)) continue;
                return o;
            }
            throw new IllegalArgumentException("could not find a " + MethodOrder.class + " for method " + method);
        }

        public void generate(StringBuffer buffer, List<JavaMethod> methods, String lineSeparator) {
            if (methods.isEmpty()) {
                return;
            }
            buffer.append(JavaFile.addIndentation(this.header, 4, lineSeparator));
            buffer.append(lineSeparator).append(lineSeparator);
            for (JavaMethod method : methods) {
                buffer.append(JavaFile.addIndentation(method.toString(lineSeparator), 4, lineSeparator));
                buffer.append(lineSeparator).append(lineSeparator);
            }
        }
    }
}

