/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import jaxx.CompilerException;
import jaxx.UnsupportedAttributeException;
import jaxx.UnsupportedTagException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerOptions;
import jaxx.compiler.DataBinding;
import jaxx.compiler.EventHandler;
import jaxx.compiler.Generator;
import jaxx.compiler.JAXXCompilerLaunchor;
import jaxx.compiler.JavaField;
import jaxx.compiler.JavaFile;
import jaxx.compiler.JavaMethod;
import jaxx.compiler.ScriptManager;
import jaxx.compiler.SymbolTable;
import jaxx.css.Rule;
import jaxx.css.Stylesheet;
import jaxx.css.StylesheetHelper;
import jaxx.parser.ParseException;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.reflect.FieldDescriptor;
import jaxx.reflect.MethodDescriptor;
import jaxx.runtime.ComponentDescriptor;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.tags.DefaultObjectHandler;
import jaxx.tags.TagHandler;
import jaxx.tags.TagManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXXCompiler {
    protected static final Log log = LogFactory.getLog(JAXXCompiler.class);
    public static final boolean STRICT_CHECKS = false;
    public static final String JAXX_NAMESPACE = "http://www.jaxxframework.org/";
    public static final String JAXX_INTERNAL_NAMESPACE = "http://www.jaxxframework.org/internal";
    public static final int INLINE_THRESHOLD = 300;
    protected final DefaultObjectHandler firstPassClassTagHandler;
    protected List<String> staticImports = new ArrayList<String>();
    protected boolean failed;
    protected CompiledObject root;
    protected Set<String> importedPackages = new HashSet<String>();
    protected Set<String> importedClasses = new HashSet<String>();
    protected Stack<CompiledObject> openComponents = new Stack();
    protected int autogenID = 0;
    protected List<DataBinding> dataBindings = new ArrayList<DataBinding>();
    protected SymbolTable symbolTable = new SymbolTable();
    protected File baseDir;
    protected File src;
    protected Document document;
    protected String outputClassName;
    protected ScriptManager scriptManager = new ScriptManager(this);
    protected Stylesheet stylesheet;
    protected List<Rule> inlineStyles = new ArrayList<Rule>();
    protected Map<String, Map<ClassDescriptor, List<EventHandler>>> eventHandlers = new HashMap<String, Map<ClassDescriptor, List<EventHandler>>>();
    protected Map<Object, String> uniqueIds = new HashMap<Object, String>();
    protected Map<EventHandler, String> eventHandlerMethodNames = new HashMap<EventHandler, String>();
    protected ClassLoader classLoader;
    protected List<Runnable> initializers = new ArrayList<Runnable>();
    protected Matcher leftBraceMatcher = Pattern.compile("^(\\{)|[^\\\\](\\{)").matcher("");
    protected Matcher rightBraceMatcher = Pattern.compile("^(\\})|[^\\\\](\\})").matcher("");
    private String[] extraInterfaces;
    private boolean abstractClass;
    private String genericType;
    private String superGenericType;
    protected StringBuffer initializer = new StringBuffer();
    protected StringBuffer lateInitializer = new StringBuffer();
    protected StringBuffer bodyCode = new StringBuffer();
    protected StringBuffer initDataBindings = new StringBuffer();
    protected StringBuffer applyDataBinding = new StringBuffer();
    protected StringBuffer removeDataBinding = new StringBuffer();
    protected StringBuffer processDataBinding = new StringBuffer();
    protected boolean mainDeclared;
    protected JavaFile javaFile;
    protected CompilerOptions options;
    protected Stack<Element> tagsBeingCompiled = new Stack();
    protected Stack<File> sourceFiles = new Stack();
    protected Map<String, CompiledObject> objects = new LinkedHashMap<String, CompiledObject>();
    protected Map<CompiledObject, String> ids = new LinkedHashMap<CompiledObject, String>();
    protected CompiledObjectDecorator defaultDecorator;
    protected static String lineSeparator = System.getProperty("line.separator", "\n");

    protected JAXXCompiler(ClassLoader classLoader, DefaultObjectHandler firstPassClassTagHandler, String ... staticImports) {
        this.firstPassClassTagHandler = firstPassClassTagHandler;
        this.options = new CompilerOptions();
        this.classLoader = classLoader;
        if (staticImports == null || staticImports.length == 0) {
            staticImports = new String[]{};
        }
        this.staticImports = Arrays.asList(staticImports);
        this.addImport("java.lang.*");
    }

    protected JAXXCompiler(File baseDir, File src, String outputClassName, CompilerOptions options, DefaultObjectHandler firstPassClassTagHandler, String ... staticImports) {
        this.baseDir = baseDir;
        this.src = src;
        this.firstPassClassTagHandler = firstPassClassTagHandler;
        this.staticImports = Arrays.asList(staticImports);
        this.sourceFiles.push(src);
        this.outputClassName = outputClassName;
        this.options = options;
        this.addImport(outputClassName.substring(0, outputClassName.lastIndexOf(".") + 1) + "*");
        if (staticImports == null || staticImports.length == 0) {
            staticImports = new String[]{"java.lang.*"};
        }
        for (String staticImport : staticImports) {
            this.addImport(staticImport);
        }
        if (options.getExtraImports() != null) {
            for (String extraImport : options.getExtraImports()) {
                this.addImport(extraImport);
            }
        }
        this.defaultDecorator = CompiledObjectDecorator.getDecorator(options.getDefaultDecoratorClass());
        if (this.defaultDecorator == null) {
            log.error((Object)("could not find default decorator : " + options.getDefaultDecoratorClass()));
            throw new IllegalArgumentException("could not find default decorator : " + options.getDefaultDecoratorClass());
        }
    }

    public void runInitializers() {
        for (Runnable runnable : this.initializers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)runnable);
            }
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.reportError(e.getMessage());
                return;
            }
        }
        this.initializers.clear();
    }

    public void registerInitializer(Runnable r) {
        this.initializers.add(r);
    }

    public void compileFirstPass(final Element tag) throws IOException {
        TagHandler handler;
        String fullClassName;
        boolean namespacePrefix;
        this.tagsBeingCompiled.push(tag);
        String namespace = tag.getNamespaceURI();
        String localName = tag.getLocalName();
        boolean bl = namespacePrefix = tag.getPrefix() != null;
        if (namespace != null && namespace.endsWith("*")) {
            String packageName = namespace.substring(0, namespace.length() - 1);
            if (localName.startsWith(packageName)) {
                fullClassName = TagManager.resolveClassName(localName, this);
            } else {
                fullClassName = TagManager.resolveClassName(packageName + localName, this);
                if (fullClassName == null && !namespacePrefix) {
                    fullClassName = TagManager.resolveClassName(localName, this);
                }
            }
        } else {
            fullClassName = TagManager.resolveClassName(localName, this);
        }
        if (fullClassName != null) {
            String id;
            this.addDependencyClass(fullClassName);
            namespace = fullClassName.substring(0, fullClassName.lastIndexOf(".") + 1) + "*";
            if (this.symbolTable.getSuperclassName() == null) {
                this.symbolTable.setSuperclassName(fullClassName);
            }
            if ((id = tag.getAttribute("id")).length() > 0) {
                this.symbolTable.getClassTagIds().put(id, fullClassName);
                if (tag.getAttributeNode("javaBean") != null) {
                    String capitalizeName = StringUtils.capitalize((String)id);
                    this.symbolTable.getScriptMethods().add(new MethodDescriptor("get" + capitalizeName, 1, fullClassName, new String[0], this.classLoader));
                    if (Boolean.class.getName().equals(fullClassName)) {
                        this.symbolTable.getScriptMethods().add(new MethodDescriptor("is" + capitalizeName, 1, fullClassName, new String[0], this.classLoader));
                    }
                    this.symbolTable.getScriptMethods().add(new MethodDescriptor("set" + capitalizeName, 1, "void", new String[]{fullClassName}, this.classLoader));
                }
            }
        }
        TagHandler tagHandler = handler = namespace != null && namespace.endsWith("*") ? this.firstPassClassTagHandler : TagManager.getTagHandler(tag.getNamespaceURI(), localName, namespacePrefix, this);
        if (handler != this.firstPassClassTagHandler && handler instanceof DefaultObjectHandler) {
            fullClassName = ((DefaultObjectHandler)handler).getBeanClass().getName();
            handler = this.firstPassClassTagHandler;
        }
        if (handler == this.firstPassClassTagHandler) {
            final String finalClassName = fullClassName;
            this.registerInitializer(new Runnable(){

                @Override
                public void run() {
                    DefaultObjectHandler handler = (DefaultObjectHandler)TagManager.getTagHandler(null, finalClassName, JAXXCompiler.this);
                    if (handler == null) {
                        throw new CompilerException("Internal error: missing TagHandler for '" + finalClassName + "'");
                    }
                    handler.registerCompiledObject(tag, JAXXCompiler.this);
                }
            });
        }
        if (handler != null) {
            try {
                handler.compileFirstPass(tag, this);
            }
            catch (CompilerException e) {
                this.reportError(e);
            }
        } else {
            this.reportError("Could not find a Java class corresponding to: <" + tag.getTagName() + ">");
            this.failed = true;
        }
        Element finished = this.tagsBeingCompiled.pop();
        if (finished != tag) {
            throw new RuntimeException("internal error: just finished compiling " + tag + ", but top of tagsBeingCompiled stack is " + finished);
        }
    }

    public void compileSecondPass(Element tag) throws IOException {
        this.tagsBeingCompiled.push(tag);
        TagHandler handler = TagManager.getTagHandler(tag.getNamespaceURI(), tag.getLocalName(), tag.getPrefix() != null, this);
        if (handler != null) {
            handler.compileSecondPass(tag, this);
        } else {
            this.reportError("Could not find a Java class corresponding to: <" + tag.getTagName() + ">");
            assert (false) : "can't-happen error: error should have been reported during the fast pass and caused an abort";
            this.failed = true;
        }
        Element finished = this.tagsBeingCompiled.pop();
        if (finished != tag) {
            throw new RuntimeException("internal error: just finished compiling " + tag + ", but top of tagsBeingCompiled stack is " + finished);
        }
    }

    protected void compileFirstPass() throws IOException {
        try {
            FileInputStream in = new FileInputStream(this.src);
            this.document = JAXXCompiler.parseDocument(in);
            ((InputStream)in).close();
            this.compileFirstPass(this.document.getDocumentElement());
        }
        catch (SAXParseException e) {
            this.reportError(e.getLineNumber(), "Invalid XML: " + e.getMessage());
        }
        catch (SAXException e) {
            this.reportError(null, "Error parsing XML document: " + e);
        }
    }

    protected void compileSecondPass() throws IOException {
        if (!this.tagsBeingCompiled.isEmpty()) {
            throw new RuntimeException("Internal error: starting pass two, but tagsBeingCompiled is not empty: " + this.tagsBeingCompiled);
        }
        this.compileSecondPass(this.document.getDocumentElement());
    }

    public void openComponent(CompiledObject component) throws CompilerException {
        this.openComponent(component, null);
    }

    public void openComponent(CompiledObject component, String constraints) throws CompilerException {
        CompiledObject parent = this.getOpenComponent();
        this.openInvisibleComponent(component);
        if (parent != null && !component.isOverride()) {
            parent.addChild(component, constraints, this);
        }
    }

    public void openInvisibleComponent(CompiledObject component) {
        if (!this.ids.containsKey(component)) {
            this.registerCompiledObject(component);
        }
        this.openComponents.push(component);
    }

    public CompiledObject getOpenComponent() {
        if (this.openComponents.isEmpty()) {
            return null;
        }
        return this.openComponents.peek();
    }

    public void closeComponent(CompiledObject component) {
        if (this.openComponents.pop() != component) {
            throw new IllegalArgumentException("can only close the topmost open object");
        }
    }

    public void registerCompiledObject(CompiledObject object) {
        assert (JAXXCompilerLaunchor.get().symbolTables.values().contains(this.symbolTable)) : "attempting to register CompiledObject before pass 1 is complete";
        if (this.root == null) {
            this.root = object;
        }
        String id = object.getId();
        if (this.ids.containsKey(object)) {
            this.reportError("object '" + object + "' is already registered with id '" + this.ids.get(object) + "', cannot re-register as '" + id + "'");
        }
        if (this.objects.containsKey(id) && !(this.objects.get(id) instanceof Element)) {
            this.reportError("id '" + id + "' is already registered to component " + this.objects.get(id));
        }
        this.objects.put(id, object);
        this.ids.put(object, id);
        if (object.getDecorator() == null) {
            object.setDecorator(this.defaultDecorator);
        }
    }

    public CompiledObject getCompiledObject(String id) {
        this.runInitializers();
        assert (JAXXCompilerLaunchor.get().symbolTables.values().contains(this.symbolTable)) : "attempting to retrieve CompiledObject before pass 1 is complete";
        return this.objects.get(id);
    }

    public boolean inlineCreation(CompiledObject object) {
        return object.getId().startsWith("$") && object.getInitializationCode(this).length() < 300;
    }

    public void checkOverride(CompiledObject object) throws CompilerException {
        if (object.getId().startsWith("$")) {
            return;
        }
        ClassDescriptor ancestor = this.root.getObjectClass();
        if (ancestor == object.getObjectClass()) {
            return;
        }
        while (ancestor != null) {
            try {
                FieldDescriptor f = ancestor.getDeclaredFieldDescriptor(object.getId());
                if (!f.getType().isAssignableFrom(object.getObjectClass())) {
                    this.reportError("attempting to redefine superclass member '" + object.getId() + "' as incompatible type (was " + f.getType() + ", redefined as " + object.getObjectClass() + ")");
                }
                object.setOverride(true);
                object.setOverrideType(f.getType());
                break;
            }
            catch (NoSuchFieldException e) {
                ancestor = ancestor.getSuperclass();
            }
        }
    }

    public String processDataBindings(String stringValue, ClassDescriptor type) throws CompilerException {
        int pos = this.getNextLeftBrace(stringValue, 0);
        if (pos != -1) {
            StringBuffer expression = new StringBuffer();
            int lastPos = 0;
            while (pos != -1 && pos < stringValue.length()) {
                if (pos > lastPos) {
                    if (expression.length() > 0) {
                        expression.append(" + ");
                    }
                    expression.append('\"');
                    expression.append(JAXXCompiler.escapeJavaString(stringValue.substring(lastPos, pos)));
                    expression.append('\"');
                }
                if (expression.length() > 0) {
                    expression.append(" + ");
                }
                expression.append('(');
                int pos2 = this.getNextRightBrace(stringValue, pos + 1);
                if (pos2 == -1) {
                    this.reportError("unmatched '{' in expression: " + stringValue);
                    return "";
                }
                expression.append(stringValue.substring(pos + 1, pos2));
                expression.append(')');
                if (++pos2 < stringValue.length()) {
                    pos = this.getNextLeftBrace(stringValue, pos2);
                    lastPos = pos2;
                    continue;
                }
                lastPos = pos = stringValue.length();
            }
            if (lastPos < stringValue.length()) {
                if (expression.length() > 0) {
                    expression.append(" + ");
                }
                expression.append('\"');
                expression.append(JAXXCompiler.escapeJavaString(stringValue.substring(lastPos)));
                expression.append('\"');
            }
            return type == ClassDescriptorLoader.getClassDescriptor(String.class) ? "String.valueOf(" + expression + ")" : expression.toString();
        }
        return null;
    }

    public void registerDataBinding(String src, String dest, String assignment) {
        try {
            src = this.checkJavaCode(src);
            this.dataBindings.add(new DataBinding(src, dest, assignment, this));
        }
        catch (CompilerException e) {
            this.reportError("While parsing data binding for '" + dest.substring(dest.lastIndexOf(".") + 1) + "': " + e.getMessage());
        }
    }

    public void registerEventHandler(EventHandler handler) {
        ClassDescriptor listenerClass;
        List<EventHandler> handlerList;
        String objectCode = handler.getObjectCode();
        Map<ClassDescriptor, List<EventHandler>> listeners = this.eventHandlers.get(objectCode);
        if (listeners == null) {
            listeners = new HashMap<ClassDescriptor, List<EventHandler>>();
            this.eventHandlers.put(objectCode, listeners);
        }
        if ((handlerList = listeners.get(listenerClass = handler.getListenerClass())) == null) {
            handlerList = new ArrayList<EventHandler>();
            listeners.put(listenerClass, handlerList);
        }
        handlerList.add(handler);
    }

    public String getEventHandlerMethodName(EventHandler handler) {
        String result = this.eventHandlerMethodNames.get(handler);
        if (result == null) {
            if (this.getOptions().isOptimize()) {
                result = "$ev" + this.eventHandlerMethodNames.size();
            } else {
                String id = handler.getEventId().substring(0, handler.getEventId().indexOf("."));
                result = "do" + StringUtils.capitalize((String)handler.getListenerMethod().getName()) + "__on__" + id;
            }
            this.eventHandlerMethodNames.put(handler, result);
        }
        return result;
    }

    public void addScriptField(FieldDescriptor field) {
        this.symbolTable.getScriptFields().add(field);
    }

    public void addScriptMethod(MethodDescriptor method) {
        if (method.getName().equals("main") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].getName().equals("[Ljava.lang.String;")) {
            this.setMainDeclared(true);
        }
        this.symbolTable.getScriptMethods().add(method);
    }

    public void registerScript(String script) throws CompilerException {
        this.registerScript(script, null);
    }

    public void registerScript(String script, File sourceFile) throws CompilerException {
        File pop;
        if (sourceFile != null) {
            this.sourceFiles.push(sourceFile);
        }
        if (!("".equals(script = script.trim()) || script.endsWith("}") || script.endsWith(";"))) {
            script = script + ";";
        }
        this.scriptManager.registerScript(script);
        if (sourceFile != null && (pop = this.sourceFiles.pop()) != sourceFile) {
            throw new RuntimeException("leaving registerScript(), but " + sourceFile + " was not the top entry on the stack (found " + pop + " instead)");
        }
    }

    public String preprocessScript(String script) throws CompilerException {
        return this.scriptManager.preprocessScript(script);
    }

    public void applyStylesheets() {
        Iterator<CompiledObject> i$ = new ArrayList<CompiledObject>(this.objects.values()).iterator();
        while (i$.hasNext()) {
            CompiledObject o;
            CompiledObject object = o = i$.next();
            TagManager.getTagHandler(object.getObjectClass()).applyStylesheets(object, this);
        }
    }

    public void registerStylesheet(Stylesheet stylesheet) {
        if (this.stylesheet == null) {
            this.stylesheet = stylesheet;
        } else {
            this.stylesheet.add(stylesheet.getRules());
        }
    }

    public void addInlineStyle(CompiledObject object, String propertyName, boolean dataBinding) {
        this.inlineStyles.add(StylesheetHelper.inlineAttribute(object, propertyName, dataBinding));
    }

    public void reportWarning(String warning) {
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportWarning(currentTag, warning, 0);
    }

    public void reportWarning(Element tag, String warning, int lineOffset) {
        String lineAttr;
        String lineNumber = null;
        if (tag != null && (lineAttr = tag.getAttributeNS(JAXX_INTERNAL_NAMESPACE, "line")).length() > 0) {
            lineNumber = lineAttr;
        }
        File src = this.sourceFiles.peek();
        try {
            src = src.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        System.err.print(src);
        if (lineNumber != null) {
            System.err.print(":" + (this.sourceFiles.size() == 1 ? Integer.parseInt(lineNumber) + lineOffset : lineOffset + 1));
        }
        System.err.println(": Warning: " + warning);
        ++JAXXCompilerLaunchor.get().warningCount;
    }

    public void reportError(String error) {
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportError(currentTag, error);
    }

    public void reportError(CompilerException ex) {
        this.reportError(null, ex);
    }

    public void reportError(String extraMessage, CompilerException ex) {
        String message = ex.getMessage();
        if (ex.getClass() == UnsupportedAttributeException.class || ex.getClass() == UnsupportedTagException.class) {
            message = ex.getClass().getName().substring(ex.getClass().getName().lastIndexOf(".") + 1) + ": " + message;
        }
        int lineOffset = ex instanceof ParseException ? Math.max(0, ((ParseException)ex).getLine() - 1) : 0;
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportError(currentTag, extraMessage != null ? extraMessage + message : message, lineOffset);
    }

    public void reportError(Element tag, String error) {
        this.reportError(tag, error, 0);
    }

    public void reportError(Element tag, String error, int lineOffset) {
        String lineAttr;
        int lineNumber = 0;
        if (tag != null && (lineAttr = tag.getAttributeNS(JAXX_INTERNAL_NAMESPACE, "line")).length() > 0) {
            lineNumber = Integer.parseInt(lineAttr);
        }
        lineNumber = Math.max(lineNumber, 1) + lineOffset;
        this.reportError(lineNumber, error);
    }

    public void reportError(int lineNumber, String error) {
        File src = this.sourceFiles.isEmpty() ? null : this.sourceFiles.peek();
        try {
            if (src != null) {
                src = src.getCanonicalFile();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        System.err.print(src != null ? src.getPath() : "<unknown source>");
        if (lineNumber > 0) {
            System.err.print(":" + lineNumber);
        }
        System.err.println(": " + error);
        ++JAXXCompilerLaunchor.get().errorCount;
        this.failed = true;
    }

    public Map<String, CompiledObject> getObjects() {
        return this.objects;
    }

    public List<DataBinding> getDataBindings() {
        return this.dataBindings;
    }

    public Map<String, Map<ClassDescriptor, List<EventHandler>>> getEventHandlers() {
        return this.eventHandlers;
    }

    public CompilerOptions getOptions() {
        return this.options;
    }

    public String getOutputClassName() {
        return this.outputClassName;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Set<String> getImportedClasses() {
        return this.importedClasses;
    }

    public Set<String> getImportedPackages() {
        return this.importedPackages;
    }

    public Iterator<CompiledObject> getObjectCreationOrder() {
        return this.objects.values().iterator();
    }

    public CompiledObject getRootObject() {
        return this.root;
    }

    public Stack<File> getSourceFiles() {
        return this.sourceFiles;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Stylesheet getStylesheet() {
        Stylesheet merged = new Stylesheet();
        if (this.stylesheet != null) {
            merged.add(this.stylesheet.getRules());
        }
        merged.add(this.inlineStyles.toArray(new Rule[this.inlineStyles.size()]));
        return merged;
    }

    public FieldDescriptor[] getScriptFields() {
        List<FieldDescriptor> scriptFields = this.symbolTable.getScriptFields();
        return scriptFields.toArray(new FieldDescriptor[scriptFields.size()]);
    }

    public MethodDescriptor[] getScriptMethods() {
        List<MethodDescriptor> scriptMethods = this.symbolTable.getScriptMethods();
        return scriptMethods.toArray(new MethodDescriptor[scriptMethods.size()]);
    }

    public MethodDescriptor getScriptMethod(String methodName) {
        for (MethodDescriptor m : this.symbolTable.getScriptMethods()) {
            if (!methodName.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            if (this.options.getClassLoader() != null) {
                this.classLoader = this.options.getClassLoader();
            } else {
                String classPath = this.options.getClassPath();
                if (classPath == null) {
                    classPath = ".";
                }
                String[] paths = classPath.split(File.pathSeparator);
                URL[] urls = new URL[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    try {
                        urls[i] = new File(paths[i]).toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            }
        }
        return this.classLoader;
    }

    public JAXXObjectDescriptor getJAXXObjectDescriptor() {
        this.runInitializers();
        CompiledObject[] components = new ArrayList<CompiledObject>(this.objects.values()).toArray(new CompiledObject[this.objects.size()]);
        assert (this.initializers.isEmpty()) : "there are pending initializers remaining";
        assert (this.root != null) : "root object has not been defined";
        assert (Arrays.asList(components).contains(this.root)) : "root object is not registered";
        ComponentDescriptor[] descriptors = new ComponentDescriptor[components.length];
        for (int i = 0; i < components.length; ++i) {
            int j;
            CompiledObject parent = components[i].getParent();
            while (parent != null) {
                boolean found = false;
                for (j = i + 1; j < components.length; ++j) {
                    if (components[j] != parent) continue;
                    components[j] = components[i];
                    components[i] = parent;
                    found = true;
                    break;
                }
                if (!found) break;
                parent = components[i].getParent();
            }
            int parentIndex = -1;
            if (parent != null) {
                for (j = 0; j < i; ++j) {
                    if (components[j] != parent) continue;
                    parentIndex = j;
                    break;
                }
            }
            descriptors[i] = new ComponentDescriptor(components[i].getId(), components[i] == this.root ? this.outputClassName : components[i].getObjectClass().getName(), components[i].getStyleClass(), parentIndex != -1 ? descriptors[parentIndex] : null);
        }
        Stylesheet stylesheet = this.getStylesheet();
        if (stylesheet == null) {
            stylesheet = new Stylesheet();
        }
        return new JAXXObjectDescriptor(descriptors, stylesheet);
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public StringBuffer getInitializer() {
        return this.initializer;
    }

    public StringBuffer getLateInitializer() {
        return this.lateInitializer;
    }

    public StringBuffer getBodyCode() {
        return this.bodyCode;
    }

    public StringBuffer getInitDataBindings() {
        return this.initDataBindings;
    }

    public StringBuffer getApplyDataBinding() {
        return this.applyDataBinding;
    }

    public StringBuffer getRemoveDataBinding() {
        return this.removeDataBinding;
    }

    public StringBuffer getProcessDataBinding() {
        return this.processDataBinding;
    }

    public boolean isMainDeclared() {
        return this.mainDeclared;
    }

    public void setMainDeclared(boolean mainDeclared) {
        this.mainDeclared = mainDeclared;
    }

    public void appendInitializerCode(String code) {
        this.getInitializer().append(code);
    }

    public void appendBodyCode(String code) {
        this.getBodyCode().append(code);
    }

    public void appendInitDataBindings(String code) {
        this.getInitDataBindings().append(code);
    }

    public void appendProcessDataBinding(String code) {
        this.getProcessDataBinding().append(code);
    }

    public void appendApplyDataBinding(String code) {
        this.getApplyDataBinding().append(code);
    }

    public void appendRemoveDataBinding(String code) {
        this.getRemoveDataBinding().append(code);
    }

    public void appendLateInitializer(String code) {
        this.getLateInitializer().append(code);
    }

    public boolean haveProcessDataBinding() {
        return this.getProcessDataBinding().length() > 0;
    }

    public boolean haveApplyDataBinding() {
        return this.getApplyDataBinding().length() > 0;
    }

    public boolean haveRemoveDataBinding() {
        return this.getRemoveDataBinding().length() > 0;
    }

    public void addMethodToJavaFile(JavaMethod method) {
        this.getJavaFile().addMethod(method);
    }

    public boolean hasMethod(String methodName) {
        JavaMethod[] methods;
        for (JavaMethod method : methods = this.getJavaFile().getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    public void addImport(String text) {
        if (text.endsWith("*")) {
            this.importedPackages.add(text.substring(0, text.length() - 1));
        } else {
            this.importedClasses.add(text);
        }
        if (!text.equals("*")) {
            this.getJavaFile().addImport(text);
        }
    }

    public void addDependencyClass(String className) {
        if (!JAXXCompilerLaunchor.get().jaxxFileClassNames.contains(className)) {
            File jaxxFile;
            URL jaxxURL = this.getClassLoader().getResource(className.replace('.', '/') + ".jaxx");
            URL classURL = this.getClassLoader().getResource(className.replace('.', '/') + ".class");
            if (jaxxURL != null && classURL != null) {
                try {
                    jaxxFile = JAXXCompiler.URLtoFile(jaxxURL);
                    File classFile = JAXXCompiler.URLtoFile(classURL);
                    if (classFile.lastModified() > jaxxFile.lastModified()) {
                        return;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (jaxxURL != null && jaxxURL.toString().startsWith("file:")) {
                jaxxFile = JAXXCompiler.URLtoFile(jaxxURL);
                try {
                    jaxxFile = jaxxFile.getCanonicalFile();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                assert (jaxxFile.getName().equalsIgnoreCase(className.substring(className.lastIndexOf(".") + 1) + ".jaxx")) : "expecting file name to match " + className + ", but found " + jaxxFile.getName();
                if (jaxxFile.getName().equals(className.substring(className.lastIndexOf(".") + 1) + ".jaxx")) {
                    if (JAXXCompilerLaunchor.get().currentPass != JAXXCompilerLaunchor.LifeCycle.compile_first_pass) {
                        throw new AssertionError((Object)("Internal error: adding dependency class " + className + " during second compilation pass"));
                    }
                    JAXXCompilerLaunchor.get().jaxxFileClassNames.add(className);
                    JAXXCompilerLaunchor.get().jaxxFiles.add(jaxxFile);
                }
            }
        }
    }

    public String checkJavaCode(String javaCode) {
        javaCode = this.scriptManager.trimScript(javaCode);
        this.scriptManager.checkParse(javaCode);
        return javaCode;
    }

    public boolean checkReference(Element tag, String reference, boolean strict, String attribute) {
        String component = this.getSymbolTable().getClassTagIds().get(reference);
        if (component == null) {
            if (strict) {
                String msg = attribute != null ? "tag '" + tag.getLocalName() + "' could not find the reference '" + reference + "' on attribute [" + attribute + "]" : "tag '" + tag.getLocalName() + "' could not find the reference '" + reference + "'";
                this.reportError(msg);
            }
            return false;
        }
        return true;
    }

    protected int getNextLeftBrace(String string, int pos) {
        this.leftBraceMatcher.reset(string);
        return this.leftBraceMatcher.find(pos) ? Math.max(this.leftBraceMatcher.start(1), this.leftBraceMatcher.start(2)) : -1;
    }

    protected int getNextRightBrace(String string, int pos) {
        this.leftBraceMatcher.reset(string);
        this.rightBraceMatcher.reset(string);
        int openCount = 1;
        while (openCount > 0) {
            int rightPos;
            int leftPos = this.leftBraceMatcher.find(++pos) ? Math.max(this.leftBraceMatcher.start(1), this.leftBraceMatcher.start(2)) : -1;
            int n = rightPos = this.rightBraceMatcher.find(pos) ? Math.max(this.rightBraceMatcher.start(1), this.rightBraceMatcher.start(2)) : -1;
            assert (leftPos == -1 || leftPos >= pos);
            assert (rightPos == -1 || rightPos >= pos);
            if (leftPos != -1 && leftPos < rightPos) {
                pos = leftPos;
                ++openCount;
                continue;
            }
            if (rightPos != -1) {
                pos = rightPos;
                --openCount;
                continue;
            }
            openCount = 0;
        }
        return pos;
    }

    public String[] parseParameterList(String parameters) throws CompilerException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer current = new StringBuffer();
        int state = 0;
        block15: for (int i = 0; i < parameters.length(); ++i) {
            char c = parameters.charAt(i);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            current.append(c);
                            state = 1;
                            continue block15;
                        }
                        case '\\': {
                            current.append(c);
                            state = 2;
                            continue block15;
                        }
                        case ',': {
                            if (current.length() > 0) {
                                result.add(current.toString());
                                current.setLength(0);
                                continue block15;
                            }
                            this.reportError("error parsing parameter list: " + parameters);
                        }
                    }
                    current.append(c);
                    continue block15;
                }
                case 1: {
                    switch (c) {
                        case '\"': {
                            current.append(c);
                            state = 0;
                            continue block15;
                        }
                        case '\\': {
                            current.append(c);
                            state = 3;
                            continue block15;
                        }
                    }
                    current.append(c);
                    continue block15;
                }
                case 2: {
                    current.append(c);
                    state = 0;
                    continue block15;
                }
                case 3: {
                    current.append(c);
                    state = 1;
                }
            }
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getAutoId(ClassDescriptor objectClass) {
        if (this.options.getOptimize()) {
            return "$" + Integer.toString(this.autogenID++, 36);
        }
        String name = objectClass.getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        return "$" + name + this.autogenID++;
    }

    public String getUniqueId(Object object) {
        String result = this.uniqueIds.get(object);
        if (result == null) {
            result = "$u" + this.uniqueIds.size();
            this.uniqueIds.put(object, result);
        }
        return result;
    }

    public void setExtraInterfaces(String[] extraInterfaces) {
        this.extraInterfaces = extraInterfaces;
    }

    public String[] getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public String getGenericType() {
        return this.genericType;
    }

    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    public String getSuperGenericType() {
        return this.superGenericType;
    }

    public void setSuperGenericType(String superGenericType) {
        this.superGenericType = superGenericType;
    }

    public void addSimpleField(JavaField javaField) {
        this.getJavaFile().addSimpleField(javaField);
    }

    public JavaFile getJavaFile() {
        if (this.javaFile == null) {
            this.javaFile = new JavaFile();
        }
        return this.javaFile;
    }

    public void generateCode(Iterable<Generator> generatorIterator) throws IOException {
        File dest = this.getOptions().getTargetDirectory() != null ? new File(this.getOptions().getTargetDirectory(), this.getOutputClassName().replace('.', File.separatorChar) + ".java") : new File(this.getBaseDir(), this.getOutputClassName().substring(this.getOutputClassName().lastIndexOf(".") + 1) + ".java");
        if (dest.exists() && !dest.setLastModified(System.currentTimeMillis())) {
            log.warn((Object)("could not touch file " + dest));
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(dest));
            int dotPos = this.getOutputClassName().lastIndexOf(".");
            String packageName = dotPos != -1 ? this.getOutputClassName().substring(0, dotPos) : null;
            String simpleClassName = this.getOutputClassName().substring(dotPos + 1);
            CompiledObject compiledObject = this.getRootObject();
            for (Generator generator : generatorIterator) {
                generator.finalizeCompiler(compiledObject, this, this.javaFile, packageName, simpleClassName);
            }
            for (CompiledObject object : this.getObjects().values()) {
                object.finalizeCompiler();
            }
            for (Generator generator : generatorIterator) {
                generator.prepareJavaFile(compiledObject, this, this.javaFile, packageName, simpleClassName);
            }
            out.println(this.javaFile.toString(JAXXCompiler.getLineSeparator()));
            out.close();
        }
        catch (RuntimeException e) {
            if (!dest.delete()) {
                log.warn((Object)("could not delete file " + dest));
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (!dest.delete()) {
                log.warn((Object)("could not delete file " + dest));
            }
            throw new CompilerException(e);
        }
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getCanonicalName(Class clazz) {
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        return clazz.getName().replace('$', '.');
    }

    public static String getCanonicalName(ClassDescriptor clazz) {
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        return clazz.getName().replace('$', '.');
    }

    public static String getCanonicalName(CompiledObject compiled) {
        ClassDescriptor clazz = compiled.getObjectClass();
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                if (compiled.getGenericTypesLength() > 0) {
                    canonicalName = canonicalName + compiled.getGenericTypes();
                }
                return canonicalName + "[]";
            }
            return null;
        }
        String canonicalName = clazz.getName().replace('$', '.');
        if (compiled.getGenericTypesLength() > 0) {
            canonicalName = canonicalName + compiled.getGenericTypes();
        }
        return canonicalName;
    }

    public static String escapeJavaString(String raw) {
        StringBuffer out = new StringBuffer(raw);
        for (int i = 0; i < out.length(); ++i) {
            char c = out.charAt(i);
            if (c == '\\' || c == '\"') {
                out.insert(i, '\\');
                ++i;
                continue;
            }
            if (c == '\n') {
                out.replace(i, i + 1, "\\n");
                ++i;
                continue;
            }
            if (c == '\r') {
                out.replace(i, i + 1, "\\r");
                ++i;
                continue;
            }
            if (c >= ' ' && c <= '\u007f') continue;
            String value = Integer.toString(c, 16);
            while (value.length() < 4) {
                value = "0" + value;
            }
            out.replace(i, i + 1, "\\u" + value);
            i += 5;
        }
        return out.toString();
    }

    public static File URLtoFile(URL url) {
        return JAXXCompiler.URLtoFile(url.toString());
    }

    public static File URLtoFile(String urlString) {
        if (!urlString.startsWith("file:")) {
            throw new IllegalArgumentException("url must start with 'file:'");
        }
        if ((urlString = urlString.substring("file:".length())).startsWith("/") && System.getProperty("os.name").startsWith("Windows")) {
            urlString = urlString.substring(1);
        }
        try {
            return new File(URLDecoder.decode(urlString.replace('/', File.separatorChar), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SAXParser getSAXParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            return parser;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseDocument(InputStream in) throws IOException, SAXException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void error(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void fatalError(TransformerException ex) throws TransformerException {
                    throw ex;
                }
            });
            DOMResult result = new DOMResult();
            transformer.transform(new SAXSource(new XMLFilterImpl(JAXXCompiler.getSAXParser().getXMLReader()){
                Locator locator;

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    AttributesImpl resultAtts = new AttributesImpl(atts);
                    resultAtts.addAttribute(JAXXCompiler.JAXX_INTERNAL_NAMESPACE, "line", "internal:line", "CDATA", String.valueOf(this.locator.getLineNumber()));
                    this.getContentHandler().startElement(uri, localName, qName, resultAtts);
                }
            }, new InputSource(in)), result);
            return (Document)result.getNode();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            Throwable ex = e;
            while (((Throwable)ex).getCause() != null) {
                ex = ((Throwable)ex).getCause();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SAXException) {
                throw (SAXException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }
}

