package jaxx;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerLaunchor;
import jaxx.introspection.JAXXPropertyDescriptor;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.reflect.MethodDescriptor;
import jaxx.tags.DefaultObjectHandler;
import jaxx.tags.TagManager;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

/** Generates information about a tag for use on the jaxxframework.org web site. */
public class PrintTagInfo {
    /**
     * Displays information about the class name in arg[0].
     *
     * @param arg command-line arguments
     * @throws Exception if an error occurs
     */
    public static void main(String[] arg) throws Exception {
        if (arg.length < 1) {
            throw new IllegalArgumentException("programm needs at least two parameters : the file where to put the result, and at least one fqn class to treate");
        }
        String firstarg = arg[0];
        boolean toFile = false;
        BufferedWriter w;
        if (firstarg.startsWith("file:")) {
            w = new BufferedWriter(new FileWriter(firstarg.substring(5)));
            toFile = true;
        } else {
            w = new BufferedWriter(new OutputStreamWriter(System.out));
        }

        try {
            JAXXCompilerLaunchor.loadLibraries(false);
            for (int i = toFile ? 1 : 0; i < arg.length; i++) {
                String className = arg[i];
                treateClass(w, className);
            }
        } finally {
            w.flush();
            w.close();
        }

    }

    protected static void treateClass(BufferedWriter w, String className) throws ClassNotFoundException, IOException {

        ClassDescriptor beanClass = ClassDescriptorLoader.getClassDescriptor(className);
        DefaultObjectHandler handler = TagManager.getTagHandler(beanClass);

        DefaultObjectHandler superHandler = TagManager.getTagHandler(beanClass.getSuperclass());

        // dump all bean properties
        w.append("Properties in ").append(String.valueOf(beanClass));
        w.newLine();
        JAXXPropertyDescriptor[] properties = handler.getJAXXBeanInfo().getJAXXPropertyDescriptors();
        JAXXPropertyDescriptor[] superProperties = superHandler.getJAXXBeanInfo().getJAXXPropertyDescriptors();
        for (JAXXPropertyDescriptor property : properties) {
            if (property.getWriteMethodDescriptor() == null) {
                continue;
            }

            boolean found = false;
            String name = property.getName();
            for (JAXXPropertyDescriptor superProperty : superProperties) {
                if (superProperty.getName().equals(name)) {
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (property.getPropertyType() == null) {
                    System.err.println(name + " has null type");
                } else {
                    w.append("{{EquivalentAttribute|");
                    w.append(name);
                    w.append("|");
                    w.append(className.replace('.', '/'));
                    w.append("|set");
                    w.append(org.apache.commons.lang.StringUtils.capitalize(name));
                    w.append("|");
                    w.append(JAXXCompiler.getCanonicalName(property.getPropertyType()));
                    w.append("}}");
                    w.append("|-");
                    w.newLine();
                }
            }
        }

        w.newLine();
        w.newLine();

        // dump all bound methods
        dumpMethods(w, beanClass, handler);
    }

    protected static void dumpMethods(BufferedWriter w, ClassDescriptor beanClass, DefaultObjectHandler handler) throws IOException {
        MethodDescriptor[] methods = beanClass.getMethodDescriptors();
        w.append("Bound methods in ").append(String.valueOf(beanClass));
        w.newLine();
        for (MethodDescriptor method : methods) {
            try {
                if (handler.isMemberBound(method.getName())) {
                    w.append("* <tt>").append(method.getName()).append("()</tt>");
                    w.newLine();
                }
            } catch (Throwable e) {
                // ignore ?
            }
        }
    }
}