package org.nuiton.jaxx.application.swing.action;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * To box any error of a {@link AbstractApplicationAction}.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ApplicationActionException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private final AbstractApplicationAction action;

    public ApplicationActionException(AbstractApplicationAction action, Throwable cause) {
        super(cause);
        this.action = action;
    }

    public static ApplicationActionException propagateError(AbstractApplicationAction action,
                                                            Throwable cause) {
        ApplicationActionException result;
        if (cause instanceof ApplicationActionException) {
            result = ((ApplicationActionException) cause);
        } else {
            result = new ApplicationActionException(action, cause);
        }
        return result;
    }

    public AbstractApplicationAction getAction() {
        return action;
    }
}
