package org.nuiton.i18n.plugin.parser;

import org.apache.maven.plugin.logging.Log;
import org.nuiton.io.SortedProperties;

import java.io.File;
import java.io.IOException;


/**
 * the contract of a i18n file parser.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public interface FileParser {

    /**
     * maven logger to use.
     *
     * @return the logger
     */
    Log getLog();

    /** @return {@code true} if should print on logger when file is touched */
    boolean isShowTouchedFiles();

    /**
     * @return {@code true} if file was touched (says contains at least one i18n
     *         key)
     */
    boolean isTouched();

    /**
     * TODO As we do not used anylonger old language, we should directly TODO
     * use only a set of keys, no need to keep i18n value...
     *
     * @return the results of i18n keys found for the given file
     */
    SortedProperties getResult();

    /**
     * Parse sur un fichier
     *
     * @param file le fichier à parser
     * @throws IOException if any pb
     */
    void parseFile(File file) throws IOException;

    /**
     * Parse une partie du fichier
     *
     * @param file le fichier à parser
     * @param line la ligne à parser
     * @throws IOException if any pb
     */
    void parseLine(File file, String line) throws IOException;

    /** clean file parser. */
    void destroy();
}
