package org.nuiton.i18n.plugin.parser;

import org.apache.maven.plugin.logging.Log;
import org.nuiton.io.SortedProperties;


/**
 * A abstract implementation of a {@link FileParser} with no logic.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public abstract class AbstractFileParser implements FileParser {

    /** Instance logger */
    private final Log log;

    private final SortedProperties oldParser;

    private final boolean showTouchedFiles;

    private final SortedProperties result;

    private boolean touched;

    protected AbstractFileParser(Log log,
                                 String encoding,
                                 SortedProperties oldParser,
                                 boolean showTouchedFiles) {
        this.log = log;
        this.oldParser = oldParser;
        this.showTouchedFiles = showTouchedFiles;
        result = new SortedProperties(encoding);
    }

    public boolean isShowTouchedFiles() {
        return showTouchedFiles;
    }

    @Override
    public boolean isTouched() {
        return touched;
    }

    @Override
    public SortedProperties getResult() {
        return result;
    }

    @Override
    public void destroy() {
        result.clear();
        touched = false;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        destroy();
    }

    public Log getLog() {
        return log;
    }

    protected void registerKey(String key) {
        Object value = oldParser.get(key);
        if (value == null) {
            // nouvelle clef du parser, on utilise la clef comme valeur
            value = key;
        }
        // register result
        getResult().put(key, value);

        //old code with event
//        String keyModified = key;
//            for (ParserEvent event : events) {
//                event.eventChangeKey(key, !oldLanguage.containsKey(key));
//                keyModified = event.eventGetRealKey();
//            }
//            if (oldParser.containsKey(key)) {
//                result.put(keyModified, oldParser.get(key));
//            } else {
//                result.put(keyModified, key);
//            }
    }

    protected void setTouched(boolean touched) {
        this.touched = touched;
    }
}
