/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleFactory;
import org.nuiton.i18n.plugin.AbstractI18nPlugin;
import org.nuiton.i18n.plugin.I18nArtifact;
import org.nuiton.util.DependencyUtil;
import org.nuiton.util.PluginHelper;

public class Bundle
extends AbstractI18nPlugin {
    protected File bundleOutputDir;
    protected String bundleOutputName;
    protected boolean checkBundle;
    protected boolean showEmpty;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected List<?> remoteRepositories;
    protected DependencyTreeBuilder dependencyTreeBuilder;
    protected ArtifactFactory factory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector collector;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected I18nArtifact[] i18nArtifacts;
    protected ClassLoader loader;
    protected URL[] urls;

    @Override
    public void init() {
        super.init();
        if (this.locales == null || this.locales.length == 0) {
            throw new IllegalStateException("il faut au moins une locale declaree (utiliser la propriete 'bundles')");
        }
        if (!this.bundleOutputDir.exists()) {
            this.bundleOutputDir.mkdirs();
        }
        try {
            this.i18nArtifacts = this.detectI18nArtifacts();
            if (!this.silent) {
                this.getLog().info((CharSequence)("detected " + this.i18nArtifacts.length + " i18n artifact(s) : "));
                for (I18nArtifact a : this.i18nArtifacts) {
                    this.getLog().info((CharSequence)(" - " + a));
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String newresourceDir = this.bundleOutputDir.getParentFile().getAbsolutePath();
        PluginHelper.addResourceDir((String)newresourceDir, (MavenProject)this.project);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging()) || "site".equals(this.project.getPackaging())) {
            return;
        }
        long t00 = System.nanoTime();
        this.init();
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - bundle name : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - baseidr     : " + this.bundleOutputDir));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
        }
        Locale defaultLocale = this.locales[0];
        LinkedHashMap<Locale, String> bundleDico = new LinkedHashMap<Locale, String>(this.locales.length);
        try {
            for (Locale locale : this.locales) {
                long t0 = System.nanoTime();
                File bundleOut = this.getI18nFile(this.bundleOutputDir, this.bundleOutputName, locale, false);
                if (!this.silent) {
                    this.getLog().info((CharSequence)("generate bundle for locale " + locale));
                }
                PluginHelper.SortedProperties propertiesOut = new PluginHelper.SortedProperties(this.encoding, false);
                StringBuilder buffer = new StringBuilder();
                for (I18nArtifact artifact : this.i18nArtifacts) {
                    I18nBundleEntry[] bundleEntries;
                    for (I18nBundleEntry bundleEntry : bundleEntries = artifact.getBundleEntries(locale, defaultLocale)) {
                        bundleEntry.load((Properties)propertiesOut);
                        String strPath = bundleEntry.getPath().toString();
                        int index = strPath.indexOf("i18n/");
                        buffer.append(',').append(strPath.substring(index));
                        if (!this.verbose) continue;
                        this.getLog().info((CharSequence)("loaded " + bundleEntry.getPath() + " in " + PluginHelper.convertTime((long)t0, (long)System.nanoTime())));
                    }
                }
                if (buffer.length() > 0) {
                    bundleDico.put(locale, buffer.substring(1));
                    if (!this.silent) {
                        this.getLog().info((CharSequence)("bundles for locale : " + (String)bundleDico.get(locale)));
                    }
                }
                propertiesOut.store(bundleOut);
                if (!this.silent && this.verbose) {
                    this.getLog().info((CharSequence)("bundle created in " + PluginHelper.convertTime((long)t0, (long)System.nanoTime()) + " (detected sentences : " + propertiesOut.size() + ")"));
                }
                if (!this.checkBundle) continue;
                this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty);
            }
            String f = String.format(I18nBundleFactory.UNIQUE_BUNDLE_DEF, this.bundleOutputName);
            File defOut = new File(this.bundleOutputDir, f);
            if (!this.silent) {
                this.getLog().info((CharSequence)("prepare i18n definition " + defOut.getAbsolutePath()));
            }
            PluginHelper.SortedProperties p = new PluginHelper.SortedProperties(this.encoding, false);
            p.setProperty(I18nBundleFactory.BUNDLE_DEF_LOCALES, this.bundles);
            for (Map.Entry e : bundleDico.entrySet()) {
                p.setProperty(I18nBundleFactory.BUNDLES_FOR_LOCALE + ((Locale)e.getKey()).toString(), (String)e.getValue());
            }
            p.store((OutputStream)new FileOutputStream(defOut), null);
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)t00, (long)System.nanoTime())));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"File Error I/O ", (Throwable)e);
            throw new MojoFailureException("File Error I/O ");
        }
    }

    protected I18nArtifact[] detectI18nArtifacts() throws MalformedURLException, IOException, DependencyTreeBuilderException {
        I18nArtifact i18nArtifact;
        HashMap<Artifact, I18nArtifact> dico = new HashMap<Artifact, I18nArtifact>();
        for (Object o : this.project.getArtifacts()) {
            i18nArtifact = new I18nArtifact((Artifact)o);
            if (i18nArtifact.detectBundles()) {
                if (!this.silent && this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("detected artifact " + i18nArtifact));
                }
                dico.put(i18nArtifact.getArtifact(), i18nArtifact);
                continue;
            }
            if (this.silent || !this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("reject artifact " + i18nArtifact));
        }
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("runtime");
        DependencyNode rootNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.factory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.collector);
        ArrayList artifacts = new ArrayList(dico.keySet());
        DependencyUtil.sortArtifacts((DependencyNode)rootNode, artifacts, (boolean)this.getLog().isDebugEnabled());
        Artifact projectArtifact = this.project.getArtifact();
        i18nArtifact = new I18nArtifact(projectArtifact, this.src.getParentFile());
        if (i18nArtifact.detectBundles()) {
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("detected artifact " + i18nArtifact));
            }
            artifacts.add(i18nArtifact.getArtifact());
            dico.put(i18nArtifact.getArtifact(), i18nArtifact);
        }
        I18nArtifact[] result = new I18nArtifact[artifacts.size()];
        int i = 0;
        for (Artifact artifact : artifacts) {
            result[i++] = (I18nArtifact)dico.get(artifact);
        }
        return result;
    }
}

