/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import org.apache.maven.plugin.AbstractMojo;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.plugin.I18nLogger;
import org.nuiton.i18n.plugin.parser.ParserEvent;
import org.nuiton.util.PluginHelper;

public abstract class AbstractI18nPlugin
extends AbstractMojo {
    private static int NB_GETTER_FILES = 0;
    protected static final String DIRECTORY_INSTALL = "i18n" + File.separatorChar;
    protected String artifactId;
    protected String bundles;
    protected File src;
    protected File out;
    protected String encoding;
    protected boolean genSrc;
    protected boolean keysModifier;
    protected boolean verbose;
    protected boolean silent;
    protected boolean keepBackup;
    protected boolean strictMode;
    protected List<ParserEvent> events = new ArrayList<ParserEvent>();
    protected Locale[] locales;
    protected I18nLogger verboseLog;

    protected void addParserEvent(ParserEvent parserEvent) {
        this.events.add(parserEvent);
    }

    protected void removeParserEvent(ParserEvent parserEvent) {
        this.events.remove(parserEvent);
    }

    public void init() {
        this.verboseLog = new I18nLogger(this);
        if (this.verbose) {
            this.getLog().info((CharSequence)"config - verbose mode is on");
        }
        this.locales = I18nUtil.parseLocales((String)this.bundles);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    protected boolean needGeneration() {
        boolean needGeneration = NB_GETTER_FILES > 0;
        return needGeneration;
    }

    protected void addGetter() {
        ++NB_GETTER_FILES;
    }

    protected I18nLogger getVerboseLog() {
        return this.verboseLog;
    }

    public File getI18nFile(File root, String artifactId, Locale locale, boolean create) throws IOException {
        File file = new File(root.getAbsolutePath() + File.separatorChar + artifactId + "-" + locale.toString() + ".properties");
        if (create && !file.exists()) {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public File getGetterFile(File root, String getter, boolean create) throws IOException {
        File file = new File(root.getAbsolutePath() + File.separatorChar + getter);
        if (create && !file.exists()) {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public File getGetterFileBackup(File root, String getter) {
        return new File(root.getAbsolutePath() + File.separatorChar + getter + '~');
    }

    public File getI18nFileBackup(File root, String artifactId, Locale bundle) {
        return new File(root.getAbsolutePath() + File.separatorChar + artifactId + "-" + bundle.toString() + ".properties~");
    }

    protected void checkBundle(Locale locale, Properties propertiesOut, boolean showEmpty) {
        SortedSet emptyEntries = PluginHelper.getEmptyKeys((Map)propertiesOut);
        if (!emptyEntries.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            int size = emptyEntries.size();
            buffer.append("bundle " + locale + " contains " + size + "/" + propertiesOut.size() + " empty entries!");
            if (showEmpty) {
                int index = 0;
                for (String key : emptyEntries) {
                    buffer.append("\n  - " + index++ + "/" + size + " : " + key);
                }
            } else {
                buffer.append(" (use -Di18n.showEmpty to see these entries)");
            }
            this.getLog().warn((CharSequence)buffer.toString());
        } else if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("bundle " + locale + " is valid (no empty entries)."));
        }
    }

    protected void backupFile(File f) throws IOException {
        PluginHelper.copy((File)f, (File)new File(f.getAbsolutePath() + "~"));
    }

    protected void copyFile(File src, File dst) throws IOException {
        PluginHelper.copy((File)src, (File)dst);
    }
}

