/*
 * *##% Plugin maven pour i18n
 * Copyright (C) 2007 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

package org.nuiton.i18n.plugin.parser;

import java.io.File;

/**
 * Permet d'ajouter des évènements sur les parsers
 *
 * @author julien
 */
public interface ParserEvent {

    /**
     * M�thode appelée quand on change de fichier parsé
     *
     * @param file
     */
    public void eventChangeFile(File file);

    /**
     * Méthode appelée après le parsing du fichier
     *
     * @param file
     */
    public void eventNextFile(File file);

    /**
     * M�thode appelée quand on change de clé
     *
     * @param keyI18n
     * @param newKey
     */
    public void eventChangeKey(String keyI18n, boolean newKey);

    /**
     * M�thode appelée pour récupérer la nouvelle valeur de clé
     *
     * @return
     */
    public String eventGetRealKey();

}
